/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.com.google.common.collect.Iterables;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;

public class CustomTraversalPolicy
extends FocusTraversalPolicy {
    List<Component> order;

    public CustomTraversalPolicy(List<Component> order) {
        this.order = new ArrayList<Component>(order.size());
        this.order.addAll(order);
    }

    public void setComponent(Component element, int index) {
        this.order.set(index, element);
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
        return this.order.get(idx);
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        int idx = this.order.indexOf(aComponent) - 1;
        if (idx < 0) {
            idx = this.order.size() - 1;
        }
        return this.order.get(idx);
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.order.get(0);
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        return (Component)Iterables.getLast(this.order);
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        return this.order.get(0);
    }
}

