/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.gui.action.OBDADataQueryAction;
import it.unibz.inf.ontop.protege.gui.action.OBDASaveQueryResultToFileAction;
import it.unibz.inf.ontop.protege.gui.treemodels.IncrementalResultSetTableModel;
import it.unibz.inf.ontop.protege.panels.QueryInterfacePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ResultViewTablePanel
extends JPanel {
    private static final long serialVersionUID = -8494558136315031084L;
    private OBDADataQueryAction countAllTuplesAction;
    private QueryInterfacePanel querypanel;
    private OBDASaveQueryResultToFileAction saveToFileAction;
    private JButton cmdExportResult;
    private JLabel lblComment;
    private JLabel lblHint;
    private JPanel pnlCommandButton;
    private JPanel pnlComment;
    private JTabbedPane resultTabbedPanel;
    private JScrollPane sparqlQueryResult;
    private JPanel sparqlResultPanel;
    private JScrollPane sqlTranslationPanel;
    private JTable tblQueryResult;
    private JTextArea txtSqlTranslation;

    public ResultViewTablePanel(QueryInterfacePanel panel) {
        this.querypanel = panel;
        this.initComponents();
        this.addPopUpMenu();
    }

    private void initComponents() {
        this.resultTabbedPanel = new JTabbedPane();
        this.sparqlResultPanel = new JPanel();
        this.sparqlQueryResult = new JScrollPane();
        this.tblQueryResult = new JTable();
        this.pnlCommandButton = new JPanel();
        this.pnlComment = new JPanel();
        this.lblHint = new JLabel();
        this.lblComment = new JLabel();
        this.cmdExportResult = new JButton();
        this.sqlTranslationPanel = new JScrollPane();
        this.txtSqlTranslation = new JTextArea();
        this.setMinimumSize(new Dimension(400, 250));
        this.setPreferredSize(new Dimension(400, 250));
        this.setLayout(new BorderLayout(0, 5));
        this.resultTabbedPanel.setPreferredSize(new Dimension(400, 240));
        this.sparqlResultPanel.setPreferredSize(new Dimension(400, 230));
        this.sparqlResultPanel.setLayout(new BorderLayout());
        this.tblQueryResult.setModel(new DefaultTableModel(new Object[0][], new String[]{"Results"}));
        this.sparqlQueryResult.setViewportView(this.tblQueryResult);
        this.sparqlResultPanel.add((Component)this.sparqlQueryResult, "Center");
        this.pnlCommandButton.setMinimumSize(new Dimension(500, 32));
        this.pnlCommandButton.setPreferredSize(new Dimension(500, 36));
        this.pnlCommandButton.setLayout(new BorderLayout(0, 5));
        this.pnlComment.setPreferredSize(new Dimension(64, 36));
        this.pnlComment.setLayout(new FlowLayout(0, 7, 5));
        this.lblHint.setFont(new Font("Tahoma", 1, 11));
        this.lblHint.setText("Hint:");
        this.pnlComment.add(this.lblHint);
        this.lblComment.setText("--");
        this.pnlComment.add(this.lblComment);
        this.pnlCommandButton.add((Component)this.pnlComment, "Center");
        this.cmdExportResult.setIcon(IconLoader.getImageIcon("images/export.png"));
        this.cmdExportResult.setText("Export to CSV...");
        this.cmdExportResult.setBorder(BorderFactory.createEtchedBorder());
        this.cmdExportResult.setContentAreaFilled(false);
        this.cmdExportResult.setFocusable(false);
        this.cmdExportResult.setIconTextGap(5);
        this.cmdExportResult.setMaximumSize(new Dimension(125, 25));
        this.cmdExportResult.setMinimumSize(new Dimension(125, 25));
        this.cmdExportResult.setPreferredSize(new Dimension(125, 36));
        this.cmdExportResult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResultViewTablePanel.this.cmdExportResultActionPerformed(evt);
            }
        });
        this.pnlCommandButton.add((Component)this.cmdExportResult, "East");
        this.sparqlResultPanel.add((Component)this.pnlCommandButton, "South");
        this.resultTabbedPanel.addTab("SPARQL results", this.sparqlResultPanel);
        this.sqlTranslationPanel.setViewportView(this.txtSqlTranslation);
        this.resultTabbedPanel.addTab("SQL Translation", this.sqlTranslationPanel);
        this.add((Component)this.resultTabbedPanel, "Center");
    }

    private void cmdExportResultActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
        fileChooser.setDialogTitle("Export to...");
        int response = fileChooser.showSaveDialog(this);
        if (response == 0) {
            File targetFile = fileChooser.getSelectedFile();
            String fileLocation = targetFile.getPath();
            if (this.canWrite(targetFile)) {
                Thread thread = new Thread(() -> this.getOBDASaveQueryToFileAction().run(fileLocation));
                thread.start();
            }
        }
    }

    private boolean canWrite(File outputFile) {
        boolean fileIsValid = false;
        if (outputFile.exists()) {
            int result = JOptionPane.showConfirmDialog(this, "File exists, overwrite?", "Warning", 1);
            switch (result) {
                case 0: {
                    fileIsValid = true;
                    break;
                }
                default: {
                    fileIsValid = false;
                    break;
                }
            }
        } else {
            fileIsValid = true;
        }
        return fileIsValid;
    }

    public void setTableModel(TableModel newmodel) {
        Runnable updateModel = () -> {
            this.tblQueryResult.setAutoResizeMode(2);
            ToolTipManager.sharedInstance().unregisterComponent(this.tblQueryResult);
            ToolTipManager.sharedInstance().unregisterComponent(this.tblQueryResult.getTableHeader());
            TableModel oldmodel = this.tblQueryResult.getModel();
            if (oldmodel != null) {
                oldmodel.removeTableModelListener(this.tblQueryResult);
                if (oldmodel instanceof IncrementalResultSetTableModel) {
                    IncrementalResultSetTableModel incm = (IncrementalResultSetTableModel)oldmodel;
                    incm.close();
                }
            }
            this.tblQueryResult.setModel(newmodel);
            this.addNotify();
            this.tblQueryResult.invalidate();
            this.tblQueryResult.repaint();
        };
        SwingUtilities.invokeLater(updateModel);
        this.writeHintMessage();
    }

    private void writeHintMessage() {
        String msg = "--";
        if (this.querypanel.isFetchAllSelect() || this.querypanel.canGetMoreTuples()) {
            msg = "Try to continue scrolling down the table to retrieve more results.";
        }
        this.lblComment.setText(msg);
    }

    private void addPopUpMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem countAll = new JMenuItem();
        countAll.setText("count all tuples");
        countAll.addActionListener(e -> {
            Thread thread = new Thread(() -> {
                String query = this.querypanel.getQuery();
                this.getCountAllTuplesActionForUCQ().run(query);
            });
            thread.start();
        });
        menu.add(countAll);
        this.tblQueryResult.setComponentPopupMenu(menu);
    }

    public OBDADataQueryAction getCountAllTuplesActionForUCQ() {
        return this.countAllTuplesAction;
    }

    public void setCountAllTuplesActionForUCQ(OBDADataQueryAction countAllTuples) {
        this.countAllTuplesAction = countAllTuples;
    }

    public void setOBDASaveQueryToFileAction(OBDASaveQueryResultToFileAction action) {
        this.saveToFileAction = action;
    }

    public OBDASaveQueryResultToFileAction getOBDASaveQueryToFileAction() {
        return this.saveToFileAction;
    }

    public void setSQLTranslation(String sql) {
        this.txtSqlTranslation.setText(sql);
    }
}

