/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.protege.core.DisposableProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class QuestConfigPanel
extends JPanel {
    private static final long serialVersionUID = 602382682995021070L;
    private DisposableProperties preference;
    private ButtonGroup AboxMode;
    private JCheckBox chkAnnotations;
    private JCheckBox chkRewrite;
    private JCheckBox chkSameAs;
    private ButtonGroup datalocationGroup;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JLabel labelNote;
    private ButtonGroup mapper;
    private ButtonGroup mappingMode;
    private JPanel pnlReformulationMethods;

    public QuestConfigPanel(DisposableProperties preference) {
        this.preference = preference;
        this.initComponents();
        this.setSelections(preference);
        this.setMaximumSize(new Dimension(1024, 768));
        this.setMinimumSize(new Dimension(1024, 768));
    }

    private void setSelections(DisposableProperties preference) {
        boolean bChecked = preference.getBoolean("ontop.existentialReasoning");
        this.chkRewrite.setSelected(bChecked);
        bChecked = preference.getBoolean("ontop.queryOntologyAnnotation");
        this.chkAnnotations.setSelected(bChecked);
        bChecked = preference.getBoolean("ontop.sameAs");
        this.chkSameAs.setSelected(bChecked);
    }

    private void initComponents() {
        this.mappingMode = new ButtonGroup();
        this.mapper = new ButtonGroup();
        this.datalocationGroup = new ButtonGroup();
        this.AboxMode = new ButtonGroup();
        this.labelNote = new JLabel();
        this.pnlReformulationMethods = new JPanel();
        this.chkRewrite = new JCheckBox();
        this.chkAnnotations = new JCheckBox();
        this.chkSameAs = new JCheckBox();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setMinimumSize(new Dimension(620, 300));
        this.setPreferredSize(new Dimension(620, 300));
        this.setLayout(new GridBagLayout());
        this.labelNote.setText("<html><b>Note:</b> You will need to restart Ontop Reasoner for any changes to take effect.<p/>&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; (i.e., select \"Reasoner-> None\" and then \"Reasoner -> Ontop\" in Protege's menu)</html>");
        this.labelNote.setAlignmentX(0.5f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.labelNote, gridBagConstraints);
        this.pnlReformulationMethods.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray), "First Order reformulation"));
        this.pnlReformulationMethods.setMinimumSize(new Dimension(620, 120));
        this.pnlReformulationMethods.setPreferredSize(new Dimension(620, 120));
        this.pnlReformulationMethods.setLayout(new GridBagLayout());
        this.chkRewrite.setText("Enable reasoning over anonymous individuals (tree-witness rewriting) ");
        this.chkRewrite.setToolTipText("Enable only if your application requires reasoning w.r.t. to existential constants in the queries");
        this.chkRewrite.setHorizontalAlignment(2);
        this.chkRewrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuestConfigPanel.this.chkRewriteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.pnlReformulationMethods.add((Component)this.chkRewrite, gridBagConstraints);
        this.chkAnnotations.setText("Enable querying annotations in the ontology");
        this.chkAnnotations.setToolTipText("Enable only if your application requires querying annotation properties defined in the ontology.");
        this.chkAnnotations.setHorizontalAlignment(2);
        this.chkAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuestConfigPanel.this.chkAnnotationsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.pnlReformulationMethods.add((Component)this.chkAnnotations, gridBagConstraints);
        this.chkSameAs.setText("Enable reasoning with owl:sameAs from mappings");
        this.chkSameAs.setToolTipText("Enable only if your application requires reasoning with owl:sameAs from mappings");
        this.chkSameAs.setHorizontalAlignment(2);
        this.chkSameAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuestConfigPanel.this.chkSameAsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.pnlReformulationMethods.add((Component)this.chkSameAs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.pnlReformulationMethods.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.pnlReformulationMethods, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private void chkRewriteActionPerformed(ActionEvent evt) {
        this.preference.put("ontop.existentialReasoning", String.valueOf(this.chkRewrite.isSelected()));
    }

    private void chkAnnotationsActionPerformed(ActionEvent evt) {
        this.preference.put("ontop.queryOntologyAnnotation", String.valueOf(this.chkAnnotations.isSelected()));
    }

    private void chkSameAsActionPerformed(ActionEvent evt) {
        this.preference.put("ontop.sameAs", String.valueOf(this.chkSameAs.isSelected()));
    }
}

