/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class SQLResultTable
extends JTable {
    private static final long serialVersionUID = -7327949276473574914L;
    private int selectedColumn;

    public SQLResultTable() {
        this.setAutoscrolls(false);
        this.setColumnSelectionAllowed(true);
        this.setCellSelectionEnabled(true);
        this.setDefaultRenderer(String.class, new ColumnHighlightRenderer());
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        this.setIntercellSpacing(new Dimension(1, 1));
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        tableHeader.setDefaultRenderer(new HeaderHighlightRenderer());
        tableHeader.addMouseListener(new ColumnHeaderAdapter(this));
    }

    public void setColumnOnSelect(int index) {
        this.selectedColumn = index;
    }

    public int getColumnOnSelect() {
        return this.selectedColumn;
    }

    class HeaderHighlightRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setFont(new Font("Tahoma", 1, 13));
            SQLResultTable resultTable = (SQLResultTable)table;
            if (resultTable.getColumnOnSelect() == col) {
                this.setBackground(UIManager.getDefaults().getColor("Button.select"));
            } else {
                this.setBackground(UIManager.getDefaults().getColor("Button.background"));
            }
            return this;
        }
    }

    class ColumnHighlightRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            SQLResultTable resultTable = (SQLResultTable)table;
            this.setBackground(UIManager.getDefaults().getColor("Table.background"));
            return this;
        }
    }

    class ColumnHeaderAdapter
    extends MouseAdapter {
        private SQLResultTable table;
        private JTextField textFieldOnFocus;

        public ColumnHeaderAdapter(SQLResultTable table) {
            this.table = table;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 1) {
                return;
            }
            JTableHeader header = this.table.getTableHeader();
            int index = header.columnAtPoint(e.getPoint());
            this.table.setColumnOnSelect(index);
            this.table.repaint();
            header.repaint();
            Container parent = this.findParentContainer(this.table);
            Component compOnFocus = this.findFocus(parent);
            if (compOnFocus != null && compOnFocus instanceof JTextField) {
                this.textFieldOnFocus = (JTextField)compOnFocus;
                String existingText = this.getExistingText();
                if (existingText.isEmpty()) {
                    String text = String.format("{%s}", this.table.getColumnName(index));
                    this.textFieldOnFocus.setText(text);
                } else if (this.hasPrefix(existingText) || this.writtenInFullUri(existingText)) {
                    int caretPosition = this.textFieldOnFocus.getCaretPosition();
                    String firstPortion = existingText.substring(0, caretPosition);
                    String secondPortion = existingText.substring(caretPosition, existingText.length());
                    String columnName = this.table.getColumnName(index);
                    String text = String.format("%s{%s}%s", firstPortion, columnName, secondPortion);
                    this.textFieldOnFocus.setText(text);
                    this.textFieldOnFocus.setCaretPosition(text.length());
                }
            }
        }

        private boolean hasPrefix(String input) {
            String prefix = input.substring(0, input.indexOf(":") + 1);
            return !prefix.isEmpty();
        }

        private boolean writtenInFullUri(String input) {
            return input.startsWith("<") || input.endsWith(">");
        }

        private String getExistingText() {
            String existingText = this.textFieldOnFocus.getText();
            String selectedText = this.textFieldOnFocus.getSelectedText();
            if (selectedText != null) {
                return existingText.replace(selectedText, "");
            }
            return existingText;
        }

        private Container findParentContainer(Component c) {
            boolean loop = true;
            Component comp = c;
            while (loop) {
                if ((comp = comp.getParent()) != null) {
                    String compName;
                    if (!(comp instanceof JPanel) || (compName = comp.getName()) == null || !compName.equals("panel_master")) continue;
                    return (Container)comp;
                }
                loop = false;
            }
            return null;
        }

        private Component findFocus(Container c) {
            Component[] comps = c.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp;
                if (comps[i].isFocusOwner()) {
                    return comps[i];
                }
                if (!(comps[i] instanceof Container) || (comp = this.findFocus((Container)comps[i])) == null) continue;
                return comp;
            }
            return null;
        }
    }
}

