/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

abstract class WrappedAction
implements Action {
    private Action originalAction;
    private JComponent component;
    private Object actionKey;

    public WrappedAction(JComponent component, KeyStroke keyStroke) {
        this.component = component;
        Object actionKey = this.getKeyForActionMap(component, keyStroke);
        if (actionKey != null) {
            this.setActionForKey(actionKey);
        }
    }

    public WrappedAction(JComponent component, Object actionKey) {
        this.component = component;
        this.setActionForKey(actionKey);
    }

    private Object getKeyForActionMap(JComponent component, KeyStroke keyStroke) {
        for (int i = 0; i < 3; ++i) {
            Object key;
            InputMap inputMap = component.getInputMap(i);
            if (inputMap == null || (key = inputMap.get(keyStroke)) == null) continue;
            return key;
        }
        return null;
    }

    private void setActionForKey(Object actionKey) {
        this.actionKey = actionKey;
        this.originalAction = this.component.getActionMap().get(actionKey);
        if (this.originalAction == null) {
            String message = "no Action for action key: " + actionKey;
            throw new IllegalArgumentException(message);
        }
        this.install();
    }

    public void invokeOriginalAction(ActionEvent e) {
        this.originalAction.actionPerformed(e);
    }

    public void install() {
        this.component.getActionMap().put(this.actionKey, this);
    }

    public void unInstall() {
        this.component.getActionMap().put(this.actionKey, this.originalAction);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.originalAction.addPropertyChangeListener(listener);
    }

    @Override
    public Object getValue(String key) {
        return this.originalAction.getValue(key);
    }

    @Override
    public boolean isEnabled() {
        return this.originalAction.isEnabled();
    }

    @Override
    public void putValue(String key, Object newValue) {
        this.originalAction.putValue(key, newValue);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.originalAction.removePropertyChangeListener(listener);
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.originalAction.setEnabled(newValue);
    }

    public Object[] getKeys() {
        if (this.originalAction instanceof AbstractAction) {
            AbstractAction abstractAction = (AbstractAction)this.originalAction;
            return abstractAction.getKeys();
        }
        return null;
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.originalAction instanceof AbstractAction) {
            AbstractAction abstractAction = (AbstractAction)this.originalAction;
            return abstractAction.getPropertyChangeListeners();
        }
        return null;
    }
}

