/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.action;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllConfiguration;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.protege.core.DuplicateMappingException;
import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import it.unibz.inf.ontop.spec.mapping.parser.DataSource2PropertiesConvertor;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.SQLPPMappingImpl;
import it.unibz.inf.ontop.spec.mapping.util.MappingOntologyUtils;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLWorkspace;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RMLImportAction
extends ProtegeAction {
    private static final long serialVersionUID = -1211395039869926309L;
    private OWLEditorKit editorKit = null;
    private OBDAModel obdaModelController = null;
    private OWLModelManager modelManager;
    private Logger log = LoggerFactory.getLogger(R2RMLImportAction.class);

    public void initialise() {
        this.editorKit = (OWLEditorKit)this.getEditorKit();
        this.obdaModelController = ((OBDAModelManager)this.editorKit.get((Object)SQLPPMappingImpl.class.getName())).getActiveOBDAModel();
        this.modelManager = this.editorKit.getOWLWorkspace().getOWLModelManager();
    }

    public void dispose() {
    }

    public void actionPerformed(ActionEvent arg0) {
        final OWLWorkspace workspace = this.editorKit.getWorkspace();
        if (this.obdaModelController.getSources().isEmpty()) {
            JOptionPane.showMessageDialog((Component)workspace, "The data source is missing. Create one in ontop Mappings. ");
        } else {
            String message = "The imported mappings will be appended to the existing data source. Continue?";
            int response = JOptionPane.showConfirmDialog((Component)workspace, message, "Confirmation", 0);
            if (response == 0) {
                OWLOntology activeOntology = this.modelManager.getActiveOntology();
                IRI documentIRI = this.modelManager.getOWLOntologyManager().getOntologyDocumentIRI(activeOntology);
                File ontologyDir = new File(documentIRI.toURI().getPath());
                JFileChooser fc = new JFileChooser(ontologyDir);
                fc.showOpenDialog((Component)workspace);
                File file = null;
                try {
                    file = fc.getSelectedFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (file != null) {
                    final File finalFile = file;
                    Thread th = new Thread("R2RML Import Thread"){

                        @Override
                        public void run() {
                            try {
                                OBDAProgressMonitor monitor = new OBDAProgressMonitor("Importing R2RML mapping ...", (Component)workspace);
                                R2RMLImportThread t = new R2RMLImportThread();
                                monitor.addProgressListener(t);
                                monitor.start();
                                t.run(finalFile);
                                monitor.stop();
                                JOptionPane.showMessageDialog((Component)workspace, "R2RML Import completed.", "Done", 1);
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog((Component)workspace, "An error occurred. For more info, see the logs.");
                                R2RMLImportAction.this.log.error("Error during R2RML import. \n", (Object)e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    };
                    th.start();
                }
            }
        }
    }

    private class R2RMLImportThread
    implements OBDAProgressListener {
        private R2RMLImportThread() {
        }

        @Override
        public void actionCanceled() throws Exception {
        }

        public void run(File file) throws Exception {
            OBDADataSource dataSource = (OBDADataSource)R2RMLImportAction.this.obdaModelController.getSources().get(0);
            OntopMappingSQLAllConfiguration configuration = ((OntopMappingSQLAllConfiguration.Builder)OntopMappingSQLAllConfiguration.defaultBuilder().properties(DataSource2PropertiesConvertor.convert(dataSource))).r2rmlMappingFile(file).build();
            SQLPPMapping parsedModel = configuration.loadProvidedPPMapping();
            OWLOntologyManager manager = R2RMLImportAction.this.modelManager.getOWLOntologyManager();
            ImmutableList tripleMaps = parsedModel.getTripleMaps();
            tripleMaps.forEach(tm -> this.registerTripleMap((SQLPPTriplesMap)tm));
            ImmutableList addAxioms = (ImmutableList)MappingOntologyUtils.extractDeclarationAxioms((OWLOntologyManager)manager, tripleMaps.stream().flatMap(tm -> tm.getTargetAtoms().stream()), (TypeFactory)R2RMLImportAction.this.obdaModelController.getTypeFactory(), (boolean)false).stream().map(ax -> new AddAxiom(R2RMLImportAction.this.modelManager.getActiveOntology(), (OWLAxiom)ax)).collect(ImmutableCollectors.toList());
            R2RMLImportAction.this.modelManager.applyChanges((List)addAxioms);
        }

        private void registerTripleMap(SQLPPTriplesMap tm) {
            try {
                R2RMLImportAction.this.obdaModelController.addTriplesMap(tm, false);
            }
            catch (DuplicateMappingException dm) {
                JOptionPane.showMessageDialog((Component)R2RMLImportAction.this.getWorkspace(), "Duplicate mapping id found. Please correct the Resource node name: " + dm.getLocalizedMessage());
                throw new RuntimeException("Duplicate mapping found: " + dm.getMessage());
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isErrorShown() {
            return false;
        }
    }
}

