/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.action;

import it.unibz.inf.ontop.owlapi.validation.QuestOWLEmptyEntitiesChecker;
import it.unibz.inf.ontop.protege.core.OntopProtegeReasoner;
import it.unibz.inf.ontop.protege.panels.EmptiesCheckPanel;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class EmptiesCheckAction
extends ProtegeAction {
    private static final long serialVersionUID = 3322509244957306932L;
    private OWLEditorKit editorKit = null;
    private OWLModelManager owlManager = null;
    private QuestOWLEmptyEntitiesChecker check;

    public void initialise() throws Exception {
        this.editorKit = (OWLEditorKit)this.getEditorKit();
        this.owlManager = this.editorKit.getOWLModelManager();
    }

    public void dispose() throws Exception {
    }

    public void actionPerformed(ActionEvent e) {
        OWLReasoner reasoner = this.owlManager.getOWLReasonerManager().getCurrentReasoner();
        if (reasoner instanceof OntopProtegeReasoner) {
            try {
                this.check = ((OntopProtegeReasoner)reasoner).getEmptyEntitiesChecker();
                final JDialog dialog = new JDialog();
                dialog.setModal(true);
                dialog.setSize(520, 400);
                dialog.setLocationRelativeTo(null);
                dialog.setTitle("Empties Check");
                final EmptiesCheckPanel emptiesPanel = new EmptiesCheckPanel();
                Thread th = new Thread("EmptyEntitiesCheck Thread"){

                    @Override
                    public void run() {
                        OBDAProgressMonitor monitor = new OBDAProgressMonitor("Finding empty entities...", (Component)EmptiesCheckAction.this.getWorkspace());
                        monitor.addProgressListener(emptiesPanel);
                        monitor.start();
                        emptiesPanel.initContent(EmptiesCheckAction.this.check);
                        monitor.stop();
                        if (!emptiesPanel.isCancelled() && !emptiesPanel.isErrorShown()) {
                            dialog.setVisible(true);
                        }
                    }
                };
                th.start();
                JPanel pnlCommandButton = this.createButtonPanel(dialog);
                dialog.setLayout(new BorderLayout());
                dialog.add((Component)emptiesPanel, "Center");
                dialog.add((Component)pnlCommandButton, "South");
                DialogUtils.installEscapeCloseOperation(dialog);
                dialog.pack();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog((Component)this.getWorkspace(), "An error occurred. For more info, see the logs.");
            }
        } else {
            JOptionPane.showMessageDialog((Component)this.getWorkspace(), "You have to start ontop reasoner for this feature.");
        }
    }

    private JPanel createButtonPanel(JDialog parent) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton cmdCloseInformation = new JButton();
        cmdCloseInformation.setText("Close Information");
        cmdCloseInformation.addActionListener(evt -> {
            parent.setVisible(false);
            parent.removeAll();
            parent.dispose();
        });
        panel.add(cmdCloseInformation);
        return panel;
    }
}

