/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.com.google.common.base.Preconditions;
import it.unibz.inf.ontop.protege.core.OntopProtegeOWLConfiguration;
import it.unibz.inf.ontop.protege.core.OntopProtegeReasoner;
import it.unibz.inf.ontop.protege.utils.OptionPaneUtils;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntopProtegeOWLFactory
implements OWLReasonerFactory {
    private final Logger log = LoggerFactory.getLogger(OntopProtegeOWLFactory.class);

    private void handleError(Exception e) {
        String message = "Error during reasoner initialization: " + e;
        OptionPaneUtils.showPrettyMessageDialog(null, message, "Ontop Initialization Error", 0);
    }

    @Nonnull
    public String getReasonerName() {
        return "Ontop";
    }

    @Nonnull
    public OntopProtegeReasoner createNonBufferingReasoner(@Nonnull OWLOntology ontology) {
        UnsupportedOperationException e = new UnsupportedOperationException("Ontop is a buffering reasoner");
        this.handleError(e);
        throw e;
    }

    public OntopProtegeReasoner createReasoner(@Nonnull OWLOntology ontology) {
        UnsupportedOperationException e = new UnsupportedOperationException("A configuration is required");
        this.handleError(e);
        throw e;
    }

    @Nonnull
    public OntopProtegeReasoner createNonBufferingReasoner(@Nonnull OWLOntology ontology, @Nonnull OWLReasonerConfiguration config) throws IllegalConfigurationException {
        UnsupportedOperationException e = new UnsupportedOperationException("Ontop is a buffering reasoner");
        this.handleError(e);
        throw e;
    }

    @Nonnull
    public OntopProtegeReasoner createReasoner(@Nonnull OWLOntology ontology, @Nonnull OWLReasonerConfiguration config) throws IllegalConfigurationException {
        try {
            Preconditions.checkArgument((boolean)(config instanceof OntopProtegeOWLConfiguration), (String)"config %s is not an instance of OntopProtegeOWLConfiguration", (Object)config);
            return new OntopProtegeReasoner(ontology, (OntopProtegeOWLConfiguration)config);
        }
        catch (Exception e) {
            this.handleError(e);
            throw e;
        }
    }
}

