/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.InvalidMappingException;
import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllConfiguration;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.TargetQueryParserFactory;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.protege.core.DuplicateMappingException;
import it.unibz.inf.ontop.protege.core.MutableOntologyVocabulary;
import it.unibz.inf.ontop.protege.core.MutableOntologyVocabularyImpl;
import it.unibz.inf.ontop.protege.core.MutablePrefixManager;
import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDADataSourceFactory;
import it.unibz.inf.ontop.protege.core.OBDAMappingListener;
import it.unibz.inf.ontop.protege.core.OBDAModelListener;
import it.unibz.inf.ontop.protege.core.impl.OBDADataSourceFactoryImpl;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQuery;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQueryFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.parser.TargetQueryParser;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;

public class OBDAModel {
    private final SQLPPMappingFactory ppMappingFactory;
    private Map<String, SQLPPTriplesMap> triplesMapMap;
    private final OBDADataSource source;
    private MutablePrefixManager prefixManager;
    private MutableOntologyVocabulary currentMutableVocabulary;
    private Optional<String> explicitDefaultPrefixNamespace = Optional.empty();
    private final List<OBDAModelListener> sourceListeners;
    private final List<OBDAMappingListener> mappingListeners;
    private static final OBDADataSourceFactory DS_FACTORY = OBDADataSourceFactoryImpl.getInstance();
    private final AtomFactory atomFactory;
    private final TermFactory termFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TypeFactory typeFactory;
    private final RDF rdfFactory;
    private final TargetQueryParserFactory targetQueryParserFactory;
    private final SQLPPSourceQueryFactory sourceQueryFactory;

    public OBDAModel(SQLPPMappingFactory ppMappingFactory, PrefixDocumentFormat owlPrefixManager, AtomFactory atomFactory, TermFactory termFactory, TypeFactory typeFactory, TargetAtomFactory targetAtomFactory, SubstitutionFactory substitutionFactory, RDF rdfFactory, TargetQueryParserFactory targetQueryParserFactory, SQLPPSourceQueryFactory sourceQueryFactory) {
        this.ppMappingFactory = ppMappingFactory;
        this.atomFactory = atomFactory;
        this.prefixManager = new MutablePrefixManager(owlPrefixManager);
        this.termFactory = termFactory;
        this.typeFactory = typeFactory;
        this.targetAtomFactory = targetAtomFactory;
        this.substitutionFactory = substitutionFactory;
        this.rdfFactory = rdfFactory;
        this.targetQueryParserFactory = targetQueryParserFactory;
        this.sourceQueryFactory = sourceQueryFactory;
        this.triplesMapMap = new LinkedHashMap<String, SQLPPTriplesMap>();
        this.sourceListeners = new ArrayList<OBDAModelListener>();
        this.mappingListeners = new ArrayList<OBDAMappingListener>();
        this.source = OBDAModel.initDataSource();
        this.currentMutableVocabulary = new MutableOntologyVocabularyImpl();
    }

    private static OBDADataSource initDataSource() {
        return DS_FACTORY.getJDBCDataSource("", "", "", "");
    }

    public SQLPPMapping generatePPMapping() {
        ImmutableList triplesMaps = ImmutableList.copyOf(this.triplesMapMap.values());
        return this.ppMappingFactory.createSQLPreProcessedMapping(triplesMaps, (PrefixManager)this.prefixManager);
    }

    public void parseMapping(Reader mappingReader, Properties properties) throws DuplicateMappingException, InvalidMappingException, MappingIOException {
        OntopMappingSQLAllConfiguration configuration = ((OntopMappingSQLAllConfiguration.Builder)OntopMappingSQLAllConfiguration.defaultBuilder().nativeOntopMappingReader(mappingReader).properties(properties)).build();
        SQLMappingParser mappingParser = (SQLMappingParser)configuration.getInjector().getInstance(SQLMappingParser.class);
        SQLPPMapping ppMapping = mappingParser.parse(mappingReader);
        this.prefixManager.addPrefixes((ImmutableMap<String, String>)ppMapping.getPrefixManager().getPrefixMap());
        this.triplesMapMap = ppMapping.getTripleMaps().stream().collect(OBDAModel.collectTriplesMaps(SQLPPTriplesMap::getId, m -> m));
    }

    public MutablePrefixManager getMutablePrefixManager() {
        return this.prefixManager;
    }

    public ImmutableList<SQLPPTriplesMap> getMapping(URI sourceUri) {
        if (sourceUri.equals(this.getSourceId())) {
            return ImmutableList.copyOf(this.triplesMapMap.values());
        }
        return ImmutableList.of();
    }

    public ImmutableList<OBDADataSource> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public SQLPPTriplesMap getTriplesMap(String mappingId) {
        return this.triplesMapMap.get(mappingId);
    }

    public void addPrefix(String prefix, String uri) {
        this.prefixManager.addPrefix(prefix, uri);
    }

    public int changePredicateIri(IRI removedPredicateIri, IRI newPredicatIri) {
        AtomicInteger counter = new AtomicInteger();
        this.triplesMapMap = this.triplesMapMap.entrySet().stream().collect(OBDAModel.collectTriplesMaps(Map.Entry::getKey, e -> this.changePredicateIri((SQLPPTriplesMap)e.getValue(), removedPredicateIri, newPredicatIri, counter)));
        return counter.get();
    }

    private SQLPPTriplesMap changePredicateIri(SQLPPTriplesMap formerTriplesMap, IRI removedIRI, IRI newIRI, AtomicInteger counter) {
        int formerCount = counter.get();
        ImmutableList newTargetAtoms = (ImmutableList)formerTriplesMap.getTargetAtoms().stream().map(a -> {
            if (a.getPredicateIRI().filter(i -> i.equals((Object)removedIRI)).isPresent()) {
                DistinctVariableOnlyDataAtom projectionAtom = a.getProjectionAtom();
                RDFAtomPredicate predicate = (RDFAtomPredicate)projectionAtom.getPredicate();
                boolean isClass = predicate.getClassIRI(a.getSubstitutedTerms()).isPresent();
                Variable predicateVariable = isClass ? (Variable)predicate.getObject(projectionAtom.getArguments()) : (Variable)predicate.getProperty(projectionAtom.getArguments());
                ImmutableSubstitution newSubstitution = this.substitutionFactory.getSubstitution((ImmutableMap)a.getSubstitution().getImmutableMap().entrySet().stream().map(e -> ((Variable)e.getKey()).equals(predicateVariable) ? Maps.immutableEntry((Object)predicateVariable, (Object)this.termFactory.getConstantIRI(newIRI)) : e).collect(ImmutableCollectors.toMap()));
                counter.incrementAndGet();
                return this.targetAtomFactory.getTargetAtom(projectionAtom, newSubstitution);
            }
            return a;
        }).collect(ImmutableCollectors.toList());
        if (counter.get() > formerCount) {
            OntopNativeSQLPPTriplesMap newTriplesMap = new OntopNativeSQLPPTriplesMap(formerTriplesMap.getId(), formerTriplesMap.getSourceQuery(), newTargetAtoms);
            this.fireMappingUpdated();
            return newTriplesMap;
        }
        return formerTriplesMap;
    }

    private void fireMappingUpdated() {
        for (OBDAMappingListener listener : this.mappingListeners) {
            listener.mappingUpdated();
        }
    }

    public void deletePredicateIRI(IRI removedPredicateIRI) {
        this.triplesMapMap = this.triplesMapMap.values().stream().filter(m -> this.mustBePreserved((SQLPPTriplesMap)m, removedPredicateIRI, new AtomicInteger())).map(m -> this.updateMapping((SQLPPTriplesMap)m, removedPredicateIRI, new AtomicInteger())).collect(OBDAModel.collectTriplesMaps(SQLPPTriplesMap::getId, Function.identity()));
        this.fireMappingUpdated();
    }

    private boolean mustBePreserved(SQLPPTriplesMap formerTriplesMap, IRI removedPredicateIRI, AtomicInteger counter) {
        int initialCount = counter.get();
        ImmutableList<TargetAtom> newTargetAtoms = this.getNewTargetAtoms(formerTriplesMap, removedPredicateIRI, counter);
        return counter.get() <= initialCount || !newTargetAtoms.isEmpty();
    }

    private ImmutableList<TargetAtom> getNewTargetAtoms(SQLPPTriplesMap formerTriplesMap, IRI removedPredicateIRI, AtomicInteger counter) {
        return (ImmutableList)formerTriplesMap.getTargetAtoms().stream().filter(a -> {
            if (a.getPredicateIRI().filter(i -> i.equals((Object)removedPredicateIRI)).isPresent()) {
                counter.incrementAndGet();
                return false;
            }
            return true;
        }).collect(ImmutableCollectors.toList());
    }

    private SQLPPTriplesMap updateMapping(SQLPPTriplesMap formerTriplesMap, IRI removedPredicateIRI, AtomicInteger counter) {
        int initialCount = counter.get();
        ImmutableList<TargetAtom> newTargetAtoms = this.getNewTargetAtoms(formerTriplesMap, removedPredicateIRI, counter);
        if (counter.get() > initialCount) {
            if (newTargetAtoms.isEmpty()) {
                throw new IllegalStateException("Mapping should be deleted");
            }
            OntopNativeSQLPPTriplesMap newTriplesMap = new OntopNativeSQLPPTriplesMap(formerTriplesMap.getId(), formerTriplesMap.getSourceQuery(), (String)formerTriplesMap.getOptionalTargetString().get(), newTargetAtoms);
            return newTriplesMap;
        }
        return formerTriplesMap;
    }

    private URI getSourceId() {
        return this.source.getSourceID();
    }

    public void addSourceListener(OBDAModelListener listener) {
        if (this.sourceListeners.contains(listener)) {
            return;
        }
        this.sourceListeners.add(listener);
    }

    public void addMappingsListener(OBDAMappingListener mlistener) {
        if (this.mappingListeners.contains(mlistener)) {
            return;
        }
        this.mappingListeners.add(mlistener);
    }

    public void fireSourceParametersUpdated() {
        for (OBDAModelListener listener : this.sourceListeners) {
            listener.datasourceParametersUpdated();
        }
    }

    public void reset(PrefixDocumentFormat owlPrefixMapper) {
        this.triplesMapMap.clear();
        this.prefixManager = new MutablePrefixManager(owlPrefixMapper);
        this.currentMutableVocabulary = new MutableOntologyVocabularyImpl();
        this.explicitDefaultPrefixNamespace = Optional.empty();
    }

    @Deprecated
    public void addTriplesMap(URI sourceID, SQLPPTriplesMap triplesMap, boolean disableFiringMappingInsertedEvent) throws DuplicateMappingException {
        String mapId = triplesMap.getId();
        if (this.triplesMapMap.containsKey(mapId)) {
            throw new DuplicateMappingException("ID " + mapId);
        }
        this.triplesMapMap.put(mapId, triplesMap);
        if (!disableFiringMappingInsertedEvent) {
            this.fireMappingInserted(sourceID);
        }
    }

    public void addTriplesMap(SQLPPTriplesMap triplesMap, boolean disableFiringMappingInsertedEvent) throws DuplicateMappingException {
        String mapId = triplesMap.getId();
        if (this.triplesMapMap.containsKey(mapId)) {
            throw new DuplicateMappingException("ID " + mapId);
        }
        this.triplesMapMap.put(mapId, triplesMap);
        if (!disableFiringMappingInsertedEvent) {
            this.fireMappingInserted(this.source.getSourceID());
        }
    }

    public void removeTriplesMap(URI dataSourceURI, String mappingId) {
        if (this.triplesMapMap.remove(mappingId) != null) {
            this.fireMappingDeleted(dataSourceURI);
        }
    }

    public void updateMappingsSourceQuery(String triplesMapId, SQLPPSourceQuery sourceQuery) {
        SQLPPTriplesMap formerTriplesMap = this.getTriplesMap(triplesMapId);
        if (formerTriplesMap != null) {
            OntopNativeSQLPPTriplesMap newTriplesMap = new OntopNativeSQLPPTriplesMap(triplesMapId, sourceQuery, formerTriplesMap.getTargetAtoms());
            this.triplesMapMap.put(triplesMapId, (SQLPPTriplesMap)newTriplesMap);
            this.fireMappingUpdated();
        }
    }

    public void updateTargetQueryMapping(String id, ImmutableList<TargetAtom> targetQuery) {
        SQLPPTriplesMap formerTriplesMap = this.getTriplesMap(id);
        if (formerTriplesMap != null) {
            OntopNativeSQLPPTriplesMap newTriplesMap = new OntopNativeSQLPPTriplesMap(id, formerTriplesMap.getSourceQuery(), targetQuery);
            this.triplesMapMap.put(id, (SQLPPTriplesMap)newTriplesMap);
            this.fireMappingUpdated();
        }
    }

    public void updateMappingId(String formerMappingId, String newMappingId) throws DuplicateMappingException {
        SQLPPTriplesMap formerTriplesMap;
        if (!formerMappingId.equals(newMappingId) && (formerTriplesMap = this.getTriplesMap(formerMappingId)) != null) {
            OntopNativeSQLPPTriplesMap newTriplesMap = new OntopNativeSQLPPTriplesMap(newMappingId, formerTriplesMap.getSourceQuery(), formerTriplesMap.getTargetAtoms());
            this.addTriplesMap((SQLPPTriplesMap)newTriplesMap, false);
            this.triplesMapMap.remove(formerMappingId);
            this.fireMappingUpdated();
        }
    }

    public int indexOf(String mappingId) {
        ImmutableList sourceMappings = ImmutableList.copyOf(this.triplesMapMap.values());
        if (sourceMappings == null) {
            return -1;
        }
        for (int i = 0; i < sourceMappings.size(); ++i) {
            if (!((SQLPPTriplesMap)sourceMappings.get(i)).getId().equals(mappingId)) continue;
            return i;
        }
        return -1;
    }

    private void fireMappingDeleted(URI srcuri) {
        for (OBDAMappingListener listener : this.mappingListeners) {
            listener.mappingDeleted(srcuri);
        }
    }

    private void fireMappingInserted(URI srcuri) {
        for (OBDAMappingListener listener : this.mappingListeners) {
            listener.mappingInserted(srcuri);
        }
    }

    public OBDADataSource getDatasource() {
        return this.source;
    }

    public MutableOntologyVocabulary getCurrentVocabulary() {
        return this.currentMutableVocabulary;
    }

    private static <I> Collector<I, ?, LinkedHashMap<String, SQLPPTriplesMap>> collectTriplesMaps(Function<I, String> keyFunction, Function<I, SQLPPTriplesMap> mapFunction) {
        return Collectors.toMap(keyFunction, mapFunction, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new);
    }

    public AtomFactory getAtomFactory() {
        return this.atomFactory;
    }

    public TermFactory getTermFactory() {
        return this.termFactory;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public TargetAtomFactory getTargetAtomFactory() {
        return this.targetAtomFactory;
    }

    public RDF getRdfFactory() {
        return this.rdfFactory;
    }

    public SQLPPSourceQueryFactory getSourceQueryFactory() {
        return this.sourceQueryFactory;
    }

    public TargetQueryParser createTargetQueryParser() {
        return this.targetQueryParserFactory.createParser(this.getMutablePrefixManager().getPrefixMap());
    }

    public TargetQueryParser createTargetQueryParser(ImmutableMap<String, String> prefixMap) {
        return this.targetQueryParserFactory.createParser(prefixMap);
    }

    boolean hasTripleMaps() {
        return !this.triplesMapMap.isEmpty();
    }

    Optional<String> getExplicitDefaultPrefixNamespace() {
        return this.explicitDefaultPrefixNamespace;
    }

    void setExplicitDefaultPrefixNamespace(String ns) {
        this.explicitDefaultPrefixNamespace = Optional.of(ns);
        this.addPrefix(":", ns);
    }
}

