/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.converter;

import it.unibz.inf.ontop.exception.MappingIOException;
import it.unibz.inf.ontop.protege.core.OBDADataSourceFactory;
import it.unibz.inf.ontop.protege.core.impl.OBDADataSourceFactoryImpl;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldSyntaxMappingConverter {
    protected static final String SOURCE_DECLARATION_TAG = "[SourceDeclaration]";
    private static final OBDADataSourceFactory DS_FACTORY = OBDADataSourceFactoryImpl.getInstance();
    private static final Logger LOG = LoggerFactory.getLogger(OldSyntaxMappingConverter.class);
    private Properties dataSourceProperties;
    private Reader outputReader;

    public OldSyntaxMappingConverter(Reader fileReader, String fileName) throws MappingIOException {
        this.outputReader = new StringReader(this.extractSourceDeclaration(fileReader, fileName).toString());
    }

    public Optional<Properties> getOBDADataSourceProperties() {
        return Optional.ofNullable(this.dataSourceProperties);
    }

    public Reader getOutputReader() {
        return this.outputReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Writer extractSourceDeclaration(Reader reader, String fileName) throws MappingIOException {
        StringWriter fileWriter = new StringWriter();
        try (LineNumberReader lineNumberReader = new LineNumberReader(reader);){
            String line;
            while ((line = lineNumberReader.readLine()) != null) {
                try {
                    if (line.contains(SOURCE_DECLARATION_TAG)) {
                        LOG.warn("Old Syntax in the OBDA file, the datasource declaration will be removed from the mapping file.");
                        this.readSourceDeclaration(lineNumberReader);
                        continue;
                    }
                    ((Writer)fileWriter).write(line + System.lineSeparator());
                }
                catch (Exception e) {
                    throw new IOException(String.format("ERROR reading %s at line: %s", fileName, lineNumberReader.getLineNumber() + " \nMESSAGE: " + e.getMessage()), e);
                }
            }
            ((Writer)fileWriter).close();
            return fileWriter;
        }
        catch (IOException e) {
            throw new MappingIOException((Exception)e);
        }
    }

    private void readSourceDeclaration(LineNumberReader reader) throws IOException {
        String line;
        this.dataSourceProperties = new Properties();
        while (!(line = reader.readLine()).isEmpty()) {
            int lineNumber = reader.getLineNumber();
            String[] tokens = line.split("[\t| ]+", 2);
            String parameter = tokens[0].trim();
            String inputParameter = tokens[1].trim();
            if (parameter.equals(Label.sourceUri.name())) {
                this.dataSourceProperties.put("jdbc.name", inputParameter);
                continue;
            }
            if (parameter.equals(Label.connectionUrl.name())) {
                this.dataSourceProperties.put("jdbc.url", inputParameter);
                continue;
            }
            if (parameter.equals(Label.username.name())) {
                this.dataSourceProperties.put("jdbc.user", inputParameter);
                continue;
            }
            if (parameter.equals(Label.password.name())) {
                this.dataSourceProperties.put("jdbc.password", inputParameter);
                continue;
            }
            if (parameter.equals(Label.driverClass.name())) {
                this.dataSourceProperties.put("jdbc.driver", inputParameter);
                continue;
            }
            String msg = String.format("Unknown parameter name \"%s\" at line: %d.", parameter, lineNumber);
            throw new IOException(msg);
        }
    }

    protected static enum Label {
        sourceUri,
        connectionUrl,
        username,
        password,
        driverClass,
        mappingId,
        target,
        source;

    }
}

