/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.views;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class OWLAxiomToTurtleVisitor
extends OWLAxiomVisitorAdapter {
    private final StringBuilder parentBuffer = new StringBuilder();
    private final StringBuilder classAssertionBuffer = new StringBuilder();
    private final StringBuilder objectPropertyAssertionBuffer = new StringBuilder();
    private final StringBuilder dataPropertyAssertionBuffer = new StringBuilder();
    private final PrefixManager prefixManager;

    public OWLAxiomToTurtleVisitor(PrefixManager prefixManager) {
        this.prefixManager = prefixManager;
        ImmutableMap namespaces = prefixManager.getPrefixMap();
        for (String prefix : namespaces.keySet()) {
            this.parentBuffer.append(String.format("@prefix %s <%s> .\n", prefix, namespaces.get(prefix)));
        }
        this.parentBuffer.append("\n");
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        String subject = this.prefixManager.getShortForm(axiom.getSubject().toString());
        String predicate = this.prefixManager.getShortForm(((OWLObjectPropertyExpression)axiom.getProperty()).toString());
        String object = this.prefixManager.getShortForm(((OWLIndividual)axiom.getObject()).toString());
        this.objectPropertyAssertionBuffer.append(String.format("%s %s %s .\n", subject, predicate, object));
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        String subject = this.prefixManager.getShortForm(axiom.getIndividual().toString());
        String object = this.prefixManager.getShortForm(axiom.getClassExpression().toString());
        this.classAssertionBuffer.append(String.format("%s rdf:type %s .\n", subject, object));
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        String subject = this.prefixManager.getShortForm(axiom.getSubject().toString());
        String predicate = this.prefixManager.getShortForm(((OWLDataPropertyExpression)axiom.getProperty()).toString());
        String object = ToStringRenderer.getInstance().getRendering((OWLObject)axiom.getObject());
        this.dataPropertyAssertionBuffer.append(String.format("%s %s %s .\n", subject, predicate, object));
    }

    public String getString() {
        this.parentBuffer.append("# Class assertion axioms\n");
        this.parentBuffer.append((CharSequence)this.classAssertionBuffer);
        this.parentBuffer.append("\n");
        this.parentBuffer.append("# Object property assertion axioms\n");
        this.parentBuffer.append((CharSequence)this.objectPropertyAssertionBuffer);
        this.parentBuffer.append("\n");
        this.parentBuffer.append("# Data property assertion axioms\n");
        this.parentBuffer.append((CharSequence)this.dataPropertyAssertionBuffer);
        return this.parentBuffer.toString();
    }
}

