/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.utils.QueryPainter;
import it.unibz.inf.ontop.protege.utils.SQLQueryPainter;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQuery;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.SourceQueryRenderer;
import it.unibz.inf.ontop.spec.mapping.serializer.TargetQueryRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class OBDAMappingListRenderer
implements ListCellRenderer<SQLPPTriplesMap> {
    private PrefixManager prefixManager;
    private JTextPane mapTextPane;
    private JTextPane trgQueryTextPane;
    private JTextPane srcQueryTextPane;
    private JPanel renderingComponent;
    private int preferredWidth;
    private int minTextHeight;
    private Font plainFont;
    public static final Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("List.selectionBackground");
    public static final Color SELECTION_FOREGROUND = UIManager.getDefaults().getColor("List.selectionForeground");
    public static final Color FOREGROUND = UIManager.getDefaults().getColor("List.foreground");
    private int plainFontHeight;
    private Style plainStyle;
    private Style boldStyle;
    private Style nonBoldStyle;
    private Style selectionForeground;
    private Style foreground;
    private Style fontSizeStyle;
    private int width;
    private int plainFontWidth;
    private Style background;
    private Style alignment;
    private JPanel trgQueryPanel;
    private JPanel srcQueryPanel;
    private JPanel mapPanel;
    private JPanel mainPanel;
    private QueryPainter painter;
    private SQLQueryPainter sqlpainter;
    int textWidth;
    int textidHeight;
    int textTargetHeight;
    int textSourceHeight;
    int height;
    int totalWidth;
    int totalHeight;

    public OBDAMappingListRenderer(OBDAModel obdaModel) {
        this.prefixManager = obdaModel.getMutablePrefixManager();
        this.trgQueryTextPane = new JTextPane();
        this.painter = new QueryPainter(obdaModel, this.trgQueryTextPane);
        this.trgQueryTextPane.setMargin(new Insets(4, 4, 4, 4));
        this.srcQueryTextPane = new JTextPane();
        this.srcQueryTextPane.setMargin(new Insets(4, 4, 4, 4));
        this.sqlpainter = new SQLQueryPainter(this.srcQueryTextPane);
        this.mapTextPane = new JTextPane();
        this.mapTextPane.setMargin(new Insets(4, 4, 4, 4));
        this.trgQueryPanel = new JPanel();
        this.trgQueryPanel.add(this.trgQueryTextPane);
        this.srcQueryPanel = new JPanel();
        this.srcQueryPanel.add(this.srcQueryTextPane);
        this.mapPanel = new JPanel();
        this.mapPanel.add(this.mapTextPane);
        this.mainPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.mainPanel.add(this.mapTextPane);
        this.mainPanel.add(this.trgQueryTextPane);
        this.mainPanel.add(this.srcQueryTextPane);
        this.mainPanel.setBorder(BorderFactory.createLineBorder(new Color(192, 192, 192), 1));
        this.mainPanel.setOpaque(true);
        this.mapTextPane.setOpaque(false);
        this.srcQueryTextPane.setOpaque(false);
        this.trgQueryTextPane.setOpaque(false);
        SpringLayout layout = new SpringLayout();
        this.renderingComponent = new JPanel(layout);
        this.renderingComponent.setBorder(null);
        this.renderingComponent.add(this.mainPanel);
        layout.putConstraint("West", (Component)this.mainPanel, 2, "West", (Component)this.renderingComponent);
        layout.putConstraint("North", (Component)this.mainPanel, 2, "North", (Component)this.renderingComponent);
        this.renderingComponent.setBackground(Color.white);
        this.prepareStyles();
        this.setupFont();
    }

    private void resetStyles(StyledDocument doc) {
        doc.setParagraphAttributes(0, doc.getLength(), this.plainStyle, true);
        StyleConstants.setFontSize(this.fontSizeStyle, 14);
        Font f = this.plainFont;
        StyleConstants.setFontFamily(this.fontSizeStyle, f.getFamily());
        doc.setParagraphAttributes(0, doc.getLength(), this.fontSizeStyle, false);
        this.setupFont();
    }

    private void prepareStyles() {
        StyledDocument doc = this.trgQueryTextPane.getStyledDocument();
        this.plainStyle = doc.addStyle("PLAIN_STYLE", null);
        StyleConstants.setItalic(this.plainStyle, false);
        this.boldStyle = doc.addStyle("BOLD_STYLE", null);
        StyleConstants.setBold(this.boldStyle, true);
        this.nonBoldStyle = doc.addStyle("NON_BOLD_STYLE", null);
        StyleConstants.setBold(this.nonBoldStyle, false);
        this.selectionForeground = doc.addStyle("SEL_FG_STYPE", null);
        if (this.selectionForeground != null && SELECTION_FOREGROUND != null) {
            StyleConstants.setForeground(this.selectionForeground, SELECTION_FOREGROUND);
        }
        this.foreground = doc.addStyle("FG_STYLE", null);
        if (this.foreground != null && FOREGROUND != null) {
            StyleConstants.setForeground(this.foreground, FOREGROUND);
        }
        this.background = doc.addStyle("BG_STYLE", null);
        if (this.background != null) {
            // empty if block
        }
        this.alignment = doc.addStyle("ALIGNMENT_STYLE", null);
        if (this.alignment != null) {
            StyleConstants.setAlignment(this.alignment, 0);
        }
        this.fontSizeStyle = doc.addStyle("FONT_SIZE", null);
        StyleConstants.setFontSize(this.fontSizeStyle, 40);
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    private void setupFont() {
        this.plainFont = new Font("Lucida Grande", 0, 14);
        this.plainFontHeight = this.trgQueryTextPane.getFontMetrics(this.plainFont).getHeight();
        int[] widths = this.trgQueryTextPane.getFontMetrics(this.plainFont).getWidths();
        int sum = 0;
        for (int i = 0; i < widths.length; ++i) {
            int j = widths[i];
            sum += j;
        }
        this.plainFontWidth = sum / widths.length;
        this.trgQueryTextPane.setFont(this.plainFont);
    }

    private void computeDimensions(JPanel parent) {
        Insets rcInsets = this.renderingComponent.getInsets();
        if (this.preferredWidth != -1) {
            this.textWidth = this.preferredWidth - rcInsets.left - rcInsets.right - 10;
            int maxChars = this.textWidth / this.plainFontWidth - 10;
            String trgQuery = this.trgQueryTextPane.getText();
            String[] split = trgQuery.split(" ");
            int currentWidth = 0;
            StringBuffer currentLine = new StringBuffer();
            int linesTarget = 1;
            FontMetrics m = this.trgQueryTextPane.getFontMetrics(this.plainFont);
            for (String splitst : split) {
                int newSize;
                boolean space = false;
                if (currentLine.length() != 0) {
                    currentLine.append(" ");
                    space = true;
                }
                if (currentWidth + (newSize = m.stringWidth((space ? " " : "") + splitst)) <= this.textWidth) {
                    currentLine.append(splitst);
                    currentWidth += newSize;
                    continue;
                }
                currentLine.setLength(0);
                currentLine.append(splitst);
                currentWidth = m.stringWidth(splitst);
                ++linesTarget;
            }
            String srcQuery = this.srcQueryTextPane.getText();
            int linesSource = srcQuery.length() / maxChars + 1;
            this.textTargetHeight = m.getHeight() * linesTarget;
            this.textSourceHeight = this.minTextHeight * linesSource;
            this.textidHeight = this.minTextHeight;
            this.trgQueryTextPane.getUI().getRootView(this.trgQueryTextPane);
            this.trgQueryTextPane.setPreferredSize(new Dimension(this.textWidth, this.textTargetHeight));
            this.srcQueryTextPane.getUI().getRootView(this.srcQueryTextPane);
            this.srcQueryTextPane.setPreferredSize(new Dimension(this.textWidth, this.textSourceHeight));
            this.mapTextPane.getUI().getRootView(this.mapTextPane);
            this.mapTextPane.setPreferredSize(new Dimension(this.textWidth, this.textidHeight));
            this.width = this.preferredWidth;
        } else {
            this.textWidth = this.mapTextPane.getPreferredSize().width;
            this.textidHeight = this.mapTextPane.getPreferredSize().height;
            this.textSourceHeight = this.srcQueryTextPane.getPreferredSize().height;
            this.textTargetHeight = this.trgQueryTextPane.getPreferredSize().width;
            this.width = this.textWidth;
        }
        this.height = this.textidHeight;
        int minHeight = this.minTextHeight;
        if (this.height < minHeight) {
            this.height = minHeight;
        }
        this.totalWidth = this.width;
        this.totalHeight = this.textidHeight + this.textSourceHeight + this.textTargetHeight;
    }

    @Override
    public Component getListCellRendererComponent(JList list, SQLPPTriplesMap value, int index, boolean isSelected, boolean cellHasFocus) {
        this.preferredWidth = list.getParent().getParent().getWidth();
        this.minTextHeight = this.plainFontHeight + 6;
        Component c = this.prepareRenderer(value, isSelected);
        return c;
    }

    private Component prepareRenderer(SQLPPTriplesMap value, boolean isSelected) {
        this.renderingComponent.setOpaque(false);
        this.prepareTextPanes(value, isSelected);
        if (isSelected) {
            this.mainPanel.setBackground(SELECTION_BACKGROUND);
        } else {
            this.mainPanel.setBackground(new Color(240, 245, 240));
        }
        this.computeDimensions(this.renderingComponent);
        this.trgQueryTextPane.setPreferredSize(new Dimension(this.textWidth, this.textTargetHeight));
        this.srcQueryTextPane.setPreferredSize(new Dimension(this.textWidth, this.textSourceHeight));
        this.mapTextPane.setPreferredSize(new Dimension(this.textWidth, this.textidHeight));
        this.mainPanel.setPreferredSize(new Dimension(this.totalWidth - 4, this.totalHeight + 2));
        this.renderingComponent.setPreferredSize(new Dimension(this.totalWidth, this.totalHeight + 5));
        boolean debugColors = false;
        if (debugColors) {
            this.mapTextPane.setOpaque(true);
            this.srcQueryTextPane.setOpaque(true);
            this.trgQueryTextPane.setOpaque(true);
            this.mainPanel.setBackground(Color.yellow);
            this.renderingComponent.setBackground(Color.yellow);
            this.trgQueryTextPane.setBackground(Color.ORANGE);
            this.trgQueryTextPane.setOpaque(true);
            this.trgQueryPanel.setBackground(Color.orange);
            this.srcQueryTextPane.setBackground(Color.pink);
            this.srcQueryPanel.setBackground(Color.yellow);
            this.mapTextPane.setBackground(Color.green);
            this.mapPanel.setBackground(Color.BLACK);
        }
        try {
            this.painter.recolorQuery();
            this.sqlpainter.recolorQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.trgQueryTextPane.setBorder(null);
        this.renderingComponent.revalidate();
        return this.renderingComponent;
    }

    private void prepareTextPanes(SQLPPTriplesMap map, boolean selected) {
        String trgQuery = TargetQueryRenderer.encode((ImmutableList)map.getTargetAtoms(), (PrefixManager)this.prefixManager);
        this.trgQueryTextPane.setText(trgQuery);
        SQLPPSourceQuery sourceQuery = map.getSourceQuery();
        String srcQuery = SourceQueryRenderer.encode((SQLPPSourceQuery)sourceQuery);
        this.srcQueryTextPane.setText(srcQuery);
        this.mapTextPane.setText(map.getId());
        StyledDocument doc = this.trgQueryTextPane.getStyledDocument();
        this.resetStyles(doc);
        doc.setParagraphAttributes(0, doc.getLength(), this.background, false);
        doc.setParagraphAttributes(0, doc.getLength(), this.alignment, false);
        if (selected) {
            doc.setParagraphAttributes(0, doc.getLength(), this.selectionForeground, false);
        } else {
            doc.setParagraphAttributes(0, doc.getLength(), this.foreground, false);
        }
        doc = this.srcQueryTextPane.getStyledDocument();
        this.resetStyles(doc);
        doc.setParagraphAttributes(0, doc.getLength(), this.background, false);
        doc.setParagraphAttributes(0, doc.getLength(), this.alignment, false);
        if (selected) {
            doc.setParagraphAttributes(0, doc.getLength(), this.selectionForeground, false);
        } else {
            doc.setParagraphAttributes(0, doc.getLength(), this.foreground, false);
        }
        doc = this.mapTextPane.getStyledDocument();
        this.resetStyles(doc);
        doc.setParagraphAttributes(0, doc.getLength(), this.boldStyle, false);
        doc.setParagraphAttributes(0, doc.getLength(), this.background, false);
        doc.setParagraphAttributes(0, doc.getLength(), this.alignment, false);
        if (selected) {
            doc.setParagraphAttributes(0, doc.getLength(), this.selectionForeground, false);
        } else {
            doc.setParagraphAttributes(0, doc.getLength(), this.foreground, false);
        }
    }
}

