/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;

public class SelectPrefixPanel
extends JPanel {
    private static final long serialVersionUID = -8277829841902027620L;
    private Map<String, String> prefixMap = null;
    private JDialog parent = null;
    private JTextPane querypane = null;
    private Vector<JCheckBox> checkboxes = null;
    private JButton jButtonAccept;
    private JButton jButtonCancel;
    private JButton jButtonSelectAll;
    private JButton jButtonSelectNone;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabelHeader;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public SelectPrefixPanel(PrefixManager manager, JTextPane parent) {
        this.prefixMap = manager.getPrefixMap();
        this.querypane = parent;
        this.initComponents();
        this.drawCheckBoxes();
    }

    @Override
    public void show() {
        this.parent = new JDialog();
        this.parent.setModal(true);
        this.parent.setDefaultCloseOperation(2);
        this.parent.setContentPane(this);
        this.parent.setLocationRelativeTo(this.querypane);
        this.parent.pack();
        this.jButtonAccept.requestFocus();
        DialogUtils.installEscapeCloseOperation(this.parent);
        DialogUtils.centerDialogWRTParent(this.querypane, this.parent);
        this.parent.setVisible(true);
    }

    private boolean isBasePrefix(String prefix) {
        return prefix.equals(":");
    }

    private void drawCheckBoxes() {
        this.checkboxes = new Vector();
        int gridYIndex = 1;
        for (String key : this.prefixMap.keySet()) {
            if (key.equals("version")) continue;
            this.jCheckBox1 = new JCheckBox();
            this.jCheckBox1.setText(key);
            this.jCheckBox1.setPreferredSize(new Dimension(444, 18));
            this.jCheckBox1.setFont(new Font("Tahoma", 1, 11));
            this.jCheckBox1.setPreferredSize(new Dimension(75, 15));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.isBasePrefix(key) ? 0 : gridYIndex;
            gridBagConstraints.weightx = 0.0;
            this.jPanel2.add((Component)this.jCheckBox1, gridBagConstraints);
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("<" + this.prefixMap.get(key) + ">");
            this.jLabel1.setPreferredSize(new Dimension(350, 15));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = this.isBasePrefix(key) ? 0 : gridYIndex;
            gridBagConstraints.weightx = 1.0;
            this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
            if (this.isBasePrefix(key)) {
                this.checkboxes.add(0, this.jCheckBox1);
            } else {
                this.checkboxes.add(this.jCheckBox1);
            }
            ++gridYIndex;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridYIndex + 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jButtonCancel.setToolTipText("Cancel the attachment of prefixes. (ESCAPE)");
        this.jButtonCancel.addActionListener(e -> this.cancel());
        this.jButtonSelectAll.setToolTipText("Select all shown prefixes. (CTRL+A)");
        this.jButtonSelectAll.addActionListener(e -> this.selectAll());
        this.jButtonSelectAll.setToolTipText("Unselect all shown prefixes. (CTRL+N)");
        this.jButtonSelectNone.addActionListener(e -> this.selectNone());
        this.jButtonAccept.setToolTipText("Add selected prefixes to query. (ENTER)");
        this.jButtonAccept.addActionListener(e -> this.accept());
        ActionListener actionListenerCancel = actionEvent -> this.cancel();
        KeyStroke ks_ecape = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyboardAction(actionListenerCancel, ks_ecape, 2);
        this.jButtonAccept.requestFocusInWindow();
        ActionListener actionListenerAccept = actionEvent -> this.accept();
        KeyStroke ks_enter = KeyStroke.getKeyStroke(10, 0);
        this.registerKeyboardAction(actionListenerAccept, ks_enter, 2);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonSelectAll.setMnemonic('a');
        this.jButtonSelectNone.setMnemonic('n');
        this.jButtonAccept.setPreferredSize(new Dimension(80, 22));
        this.jButtonCancel.setPreferredSize(new Dimension(80, 22));
        this.jButtonSelectAll.setPreferredSize(new Dimension(80, 22));
        this.jButtonSelectNone.setPreferredSize(new Dimension(80, 22));
        this.jPanel3.setPreferredSize(new Dimension(1, 1));
    }

    private void selectAll() {
        for (JCheckBox box : this.checkboxes) {
            box.setSelected(true);
        }
    }

    private void selectNone() {
        for (JCheckBox box : this.checkboxes) {
            box.setSelected(false);
        }
    }

    private void accept() {
        StringBuffer directive = new StringBuffer();
        for (JCheckBox checkbox : this.checkboxes) {
            if (!checkbox.isSelected()) continue;
            String prefix = checkbox.getText();
            directive.append("PREFIX ");
            directive.append(prefix);
            directive.append(" ");
            directive.append("<");
            directive.append(this.prefixMap.get(prefix));
            directive.append(">");
            directive.append("\n");
        }
        String currentcontent = this.querypane.getText();
        String newContent = directive + currentcontent;
        this.querypane.setText(newContent);
        this.parent.setVisible(false);
        this.parent.dispose();
    }

    private void cancel() {
        this.parent.setVisible(false);
        this.parent.dispose();
    }

    private void initComponents() {
        this.jLabelHeader = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButtonAccept = new JButton();
        this.jButtonSelectAll = new JButton();
        this.jButtonSelectNone = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.setMinimumSize(new Dimension(100, 100));
        this.setLayout(new GridBagLayout());
        this.jLabelHeader.setText("Select the prefixes relevant for your query:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabelHeader, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonAccept.setText("Accept");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButtonAccept, gridBagConstraints);
        this.jButtonSelectAll.setText("Select All");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButtonSelectAll, gridBagConstraints);
        this.jButtonSelectNone.setText("Select None");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButtonSelectNone, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }
}

