/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.gui.treemodels.ResultSetTableModel;
import it.unibz.inf.ontop.protege.utils.ConnectionTools;
import it.unibz.inf.ontop.protege.utils.DatasourceSelectorListener;
import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import it.unibz.inf.ontop.protege.utils.OptionPaneUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLQueryPanel
extends JPanel
implements DatasourceSelectorListener {
    private static final long serialVersionUID = 7600557919206933923L;
    private Logger log = LoggerFactory.getLogger(SQLQueryPanel.class);
    private OBDADataSource selectedSource;
    private JButton cmdExecute;
    private JPanel pnlQueryResult;
    private JPanel pnlSqlQuery;
    private JScrollPane scrQueryResult;
    private JScrollPane scrSqlQuery;
    private JSplitPane splSqlQuery;
    private JTable tblQueryResult;
    private JTextArea txtSqlQuery;

    public SQLQueryPanel() {
        this.initComponents();
    }

    public SQLQueryPanel(OBDADataSource ds, String query) {
        this.initComponents();
        this.txtSqlQuery.setText(query);
        this.selectedSource = ds;
        this.cmdExecuteActionPerformed(null);
    }

    private void initComponents() {
        this.splSqlQuery = new JSplitPane();
        this.pnlSqlQuery = new JPanel();
        this.scrSqlQuery = new JScrollPane();
        this.txtSqlQuery = new JTextArea();
        this.cmdExecute = new JButton();
        this.pnlQueryResult = new JPanel();
        this.scrQueryResult = new JScrollPane();
        this.tblQueryResult = new JTable();
        this.setBorder(BorderFactory.createTitledBorder("SQL Query"));
        this.setAlignmentX(5.0f);
        this.setAlignmentY(5.0f);
        this.setFont(new Font("Arial", 0, 18));
        this.setPreferredSize(new Dimension(640, 480));
        this.setLayout(new BorderLayout(5, 5));
        this.splSqlQuery.setOrientation(0);
        this.splSqlQuery.setResizeWeight(0.3);
        this.pnlSqlQuery.setMinimumSize(new Dimension(156, 100));
        this.pnlSqlQuery.setPreferredSize(new Dimension(156, 100));
        this.pnlSqlQuery.setLayout(new GridBagLayout());
        this.scrSqlQuery.setPreferredSize(new Dimension(600, 100));
        this.txtSqlQuery.setColumns(20);
        this.txtSqlQuery.setFont(new Font("Dialog", 0, 12));
        this.txtSqlQuery.setLineWrap(true);
        this.txtSqlQuery.setRows(2);
        this.txtSqlQuery.setBorder(null);
        this.txtSqlQuery.setPreferredSize(new Dimension(600, 100));
        this.scrSqlQuery.setViewportView(this.txtSqlQuery);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        this.pnlSqlQuery.add((Component)this.scrSqlQuery, gridBagConstraints);
        this.cmdExecute.setIcon(IconLoader.getImageIcon("images/execute.png"));
        this.cmdExecute.setMnemonic('x');
        this.cmdExecute.setText("Execute");
        this.cmdExecute.setToolTipText("Execute the SQL query");
        this.cmdExecute.setBorder(BorderFactory.createEtchedBorder());
        this.cmdExecute.setContentAreaFilled(false);
        this.cmdExecute.setMargin(new Insets(5, 14, 5, 14));
        this.cmdExecute.setMaximumSize(new Dimension(85, 25));
        this.cmdExecute.setMinimumSize(new Dimension(85, 25));
        this.cmdExecute.setPreferredSize(new Dimension(85, 25));
        this.cmdExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLQueryPanel.this.cmdExecuteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 13;
        this.pnlSqlQuery.add((Component)this.cmdExecute, gridBagConstraints);
        this.splSqlQuery.setLeftComponent(this.pnlSqlQuery);
        this.pnlQueryResult.setLayout(new BorderLayout());
        this.tblQueryResult.setModel(new DefaultTableModel(new Object[0][], new String[]{"Results"}));
        this.tblQueryResult.setAutoResizeMode(0);
        this.scrQueryResult.setViewportView(this.tblQueryResult);
        this.pnlQueryResult.add((Component)this.scrQueryResult, "Center");
        this.splSqlQuery.setRightComponent(this.pnlQueryResult);
        this.add((Component)this.splSqlQuery, "Center");
    }

    private void cmdExecuteActionPerformed(ActionEvent evt) {
        this.releaseResultset();
        try {
            if (this.selectedSource == null) {
                JOptionPane.showMessageDialog(this, "Please select data source first", "Error", 0);
            } else {
                OBDAProgressMonitor progMonitor = new OBDAProgressMonitor("Executing query...", this.getRootPane());
                CountDownLatch latch = new CountDownLatch(1);
                ExecuteSQLQueryAction action = new ExecuteSQLQueryAction(latch);
                progMonitor.addProgressListener(action);
                progMonitor.start();
                action.run();
                latch.await();
                progMonitor.stop();
                ResultSet set = action.getResult();
                if (set != null) {
                    ResultSetTableModel model = new ResultSetTableModel(set);
                    this.tblQueryResult.setModel(model);
                    set.close();
                }
            }
        }
        catch (Exception e) {
            OptionPaneUtils.showPrettyMessageDialog(null, e.getMessage(), "Error", 0);
            this.log.error("Error while executing query.", (Throwable)e);
        }
    }

    private void releaseResultset() {
        TableModel model = this.tblQueryResult.getModel();
        if (model == null) {
            return;
        }
        if (!(model instanceof ResultSetTableModel)) {
            return;
        }
        ResultSetTableModel imodel = (ResultSetTableModel)model;
        imodel.close();
    }

    @Override
    public void datasourceChanged(OBDADataSource oldSource, OBDADataSource newSource) {
        this.selectedSource = newSource;
        this.releaseResultset();
    }

    public void finalize() {
        this.releaseResultset();
    }

    private class ExecuteSQLQueryAction
    implements OBDAProgressListener {
        CountDownLatch latch = null;
        Thread thread = null;
        ResultSet result = null;
        Statement statement = null;
        private boolean isCancelled = false;
        private boolean errorShown = false;

        private ExecuteSQLQueryAction(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void actionCanceled() throws SQLException {
            this.isCancelled = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
            }
            this.result = null;
            this.latch.countDown();
        }

        public ResultSet getResult() {
            return this.result;
        }

        public void run() {
            this.thread = new Thread(){

                @Override
                public void run() {
                    try {
                        TableModel oldmodel = SQLQueryPanel.this.tblQueryResult.getModel();
                        if (oldmodel != null && oldmodel instanceof ResultSetTableModel) {
                            ResultSetTableModel rstm = (ResultSetTableModel)oldmodel;
                            rstm.close();
                        }
                        Connection c = ConnectionTools.getConnection(SQLQueryPanel.this.selectedSource);
                        Statement s = c.createStatement();
                        s.setMaxRows(100);
                        ExecuteSQLQueryAction.this.result = s.executeQuery(SQLQueryPanel.this.txtSqlQuery.getText());
                        ExecuteSQLQueryAction.this.latch.countDown();
                    }
                    catch (Exception e) {
                        ExecuteSQLQueryAction.this.latch.countDown();
                        ExecuteSQLQueryAction.this.errorShown = true;
                        OptionPaneUtils.showPrettyMessageDialog(null, e.getMessage(), "Error", 0);
                        SQLQueryPanel.this.log.error("Error while executing query.", (Throwable)e);
                    }
                }
            };
            this.thread.start();
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isErrorShown() {
            return this.errorShown;
        }
    }
}

