/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.protege.core.DisposableOBDAPreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;

public class OBDAPreferencesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DisposableOBDAPreferences pref = null;
    private HashMap<String, KeyStroke> shortCuts = new HashMap();
    private JButton cmdClassColor;
    private JButton cmdDataPropertyColor;
    private JButton cmdFontFamily;
    private JButton cmdFunctorColor;
    private JButton cmdObjectPropertyColor;
    private JButton cmdParameterColor;
    private JButton cmdVariableColor;
    private JCheckBox jCheckBoxUseDefault;
    private JLabel jLabelPlaceholder;
    private JLabel jLabelplaceholder2;
    private JLabel lblAddMapping;
    private JLabel lblAddMappingKey;
    private JLabel lblClass;
    private JLabel lblDataProperty;
    private JLabel lblDeleteMapping;
    private JLabel lblDeleteMappingKey;
    private JLabel lblEditMappingBody;
    private JLabel lblEditMappingBodyKey;
    private JLabel lblEditMappingHead;
    private JLabel lblEditMappingHeadKey;
    private JLabel lblEditMappingId;
    private JLabel lblFunctors;
    private JLabel lblInfo;
    private JLabel lblMappingBody;
    private JLabel lblMappingIdKey;
    private JLabel lblObjectProperty;
    private JLabel lblParameter;
    private JLabel lblVariable;
    private JPanel pnlClassPreferences;
    private JPanel pnlDisplayPreferencesTab;
    private JPanel pnlEditingShortcutTab;
    private JPanel pnlMappingPreferences;
    private JPanel pnlShortcutSettings;
    private JPanel pnlVariablePreferences;
    private JTabbedPane tabMainPanel;

    public OBDAPreferencesPanel(DisposableOBDAPreferences preference) {
        this.pref = preference;
        this.initComponents();
        this.addListener();
        this.applyPreferences();
    }

    private boolean isKeyStrokeAlreadyAssigned(KeyStroke stroke) {
        return this.shortCuts.containsValue(stroke);
    }

    private void addListener() {
        this.cmdClassColor.addActionListener(arg0 -> {
            ColorChooser cc = new ColorChooser(this.cmdClassColor, "class_Color");
            cc.setVisible(true);
        });
        this.cmdDataPropertyColor.addActionListener(arg0 -> {
            ColorChooser cc = new ColorChooser(this.cmdDataPropertyColor, "dataProperty_Color");
            cc.setVisible(true);
        });
        this.cmdFunctorColor.addActionListener(arg0 -> {
            ColorChooser cc = new ColorChooser(this.cmdFunctorColor, "functor_Color");
            cc.setVisible(true);
        });
        this.cmdObjectPropertyColor.addActionListener(arg0 -> {
            ColorChooser cc = new ColorChooser(this.cmdObjectPropertyColor, "objectproperty_Color");
            cc.setVisible(true);
        });
        this.cmdParameterColor.addActionListener(arg0 -> {
            ColorChooser cc = new ColorChooser(this.cmdParameterColor, "parameter_Color");
            cc.setVisible(true);
        });
        this.cmdVariableColor.addActionListener(arg0 -> {
            ColorChooser cc = new ColorChooser(this.cmdVariableColor, "variable_Color");
            cc.setVisible(true);
        });
        String aux = this.pref.getOBDAPreference("add.Mapping");
        KeyStroke ks = KeyStroke.getKeyStroke(aux);
        this.lblAddMappingKey.setText(KeyEvent.getKeyModifiersText(ks.getModifiers()) + " + " + KeyEvent.getKeyText(ks.getKeyCode()));
        this.lblAddMappingKey.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OBDAPreferencesPanel.this.lblAddMappingKey.setText("");
                OBDAPreferencesPanel.this.lblAddMappingKey.requestFocus();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.lblAddMappingKey.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                int mod = e.getModifiers();
                int key = e.getKeyCode();
                if (key == 17 || key == 3 || key == 18 || key == 65406 || key == 16 || key == 27) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStroke(key, mod);
                if (!OBDAPreferencesPanel.this.isKeyStrokeAlreadyAssigned(stroke)) {
                    OBDAPreferencesPanel.this.shortCuts.put("add.Mapping", stroke);
                    OBDAPreferencesPanel.this.lblAddMappingKey.setText(KeyEvent.getKeyModifiersText(stroke.getModifiers()) + " + " + KeyEvent.getKeyText(stroke.getKeyCode()));
                    OBDAPreferencesPanel.this.lblAddMappingKey.setToolTipText(stroke.toString());
                    OBDAPreferencesPanel.this.pref.put("add.Mapping", stroke.toString());
                } else {
                    KeyStroke oldValue = (KeyStroke)OBDAPreferencesPanel.this.shortCuts.get("add.Mapping");
                    if (oldValue != null) {
                        OBDAPreferencesPanel.this.lblAddMappingKey.setText(KeyEvent.getKeyModifiersText(oldValue.getModifiers()) + " + " + KeyEvent.getKeyText(oldValue.getKeyCode()));
                    }
                    JOptionPane.showMessageDialog(OBDAPreferencesPanel.this.getRootPane(), "Key stroke already assigned. Please choose an other combination.", "ERROR", 0);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        String aux2 = this.pref.get("edit.Mapping.Body").toString();
        KeyStroke ks2 = KeyStroke.getKeyStroke(aux2);
        this.lblEditMappingBodyKey.setText(KeyEvent.getKeyModifiersText(ks2.getModifiers()) + " + " + KeyEvent.getKeyText(ks2.getKeyCode()));
        this.lblEditMappingBodyKey.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OBDAPreferencesPanel.this.lblEditMappingBodyKey.setText("");
                OBDAPreferencesPanel.this.lblEditMappingBodyKey.requestFocus();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.lblEditMappingBodyKey.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                int mod = e.getModifiers();
                int key = e.getKeyCode();
                if (key == 17 || key == 3 || key == 18 || key == 65406 || key == 16 || key == 27) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStroke(key, mod);
                if (!OBDAPreferencesPanel.this.isKeyStrokeAlreadyAssigned(stroke)) {
                    OBDAPreferencesPanel.this.shortCuts.put("edit.Mapping.Body", stroke);
                    OBDAPreferencesPanel.this.lblEditMappingBodyKey.setText(KeyEvent.getKeyModifiersText(stroke.getModifiers()) + " + " + KeyEvent.getKeyText(stroke.getKeyCode()));
                    OBDAPreferencesPanel.this.lblEditMappingBodyKey.setToolTipText(stroke.toString());
                    OBDAPreferencesPanel.this.pref.put("edit.Mapping.Body", stroke.toString());
                } else {
                    KeyStroke oldValue = (KeyStroke)OBDAPreferencesPanel.this.shortCuts.get("edit.Mapping.Body");
                    if (oldValue != null) {
                        OBDAPreferencesPanel.this.lblEditMappingBodyKey.setText(KeyEvent.getKeyModifiersText(oldValue.getModifiers()) + " + " + KeyEvent.getKeyText(oldValue.getKeyCode()));
                    }
                    JOptionPane.showMessageDialog(OBDAPreferencesPanel.this.getRootPane(), "Key stroke already assigned. Please choose an other combination.", "ERROR", 0);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        String aux3 = this.pref.get("edit.Mapping.Head").toString();
        KeyStroke ks3 = KeyStroke.getKeyStroke(aux3);
        this.lblEditMappingHeadKey.setText(KeyEvent.getKeyModifiersText(ks3.getModifiers()) + " + " + KeyEvent.getKeyText(ks3.getKeyCode()));
        this.lblEditMappingHeadKey.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OBDAPreferencesPanel.this.lblEditMappingHeadKey.setText("");
                OBDAPreferencesPanel.this.lblEditMappingHeadKey.requestFocus();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.lblEditMappingHeadKey.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                int mod = e.getModifiers();
                int key = e.getKeyCode();
                if (key == 17 || key == 3 || key == 18 || key == 65406 || key == 16 || key == 27) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStroke(key, mod);
                if (!OBDAPreferencesPanel.this.isKeyStrokeAlreadyAssigned(stroke)) {
                    OBDAPreferencesPanel.this.shortCuts.put("edit.Mapping.Head", stroke);
                    OBDAPreferencesPanel.this.lblEditMappingHeadKey.setText(KeyEvent.getKeyModifiersText(stroke.getModifiers()) + " + " + KeyEvent.getKeyText(stroke.getKeyCode()));
                    OBDAPreferencesPanel.this.lblEditMappingHeadKey.setToolTipText(stroke.toString());
                    OBDAPreferencesPanel.this.pref.put("edit.Mapping.Head", stroke.toString());
                } else {
                    KeyStroke oldValue = (KeyStroke)OBDAPreferencesPanel.this.shortCuts.get("edit.Mapping.Head");
                    if (oldValue != null) {
                        OBDAPreferencesPanel.this.lblEditMappingHeadKey.setText(KeyEvent.getKeyModifiersText(oldValue.getModifiers()) + " + " + KeyEvent.getKeyText(oldValue.getKeyCode()));
                    }
                    JOptionPane.showMessageDialog(OBDAPreferencesPanel.this.getRootPane(), "Key stroke already assigned. Please choose an other combination.", "ERROR", 0);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        String aux4 = this.pref.get("edit.Mapping.id").toString();
        KeyStroke ks4 = KeyStroke.getKeyStroke(aux4);
        this.lblMappingIdKey.setText(KeyEvent.getKeyModifiersText(ks4.getModifiers()) + " + " + KeyEvent.getKeyText(ks4.getKeyCode()));
        this.lblMappingIdKey.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OBDAPreferencesPanel.this.lblMappingIdKey.setText("");
                OBDAPreferencesPanel.this.lblMappingIdKey.requestFocus();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.lblMappingIdKey.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                int mod = e.getModifiers();
                int key = e.getKeyCode();
                if (key == 17 || key == 3 || key == 18 || key == 65406 || key == 16 || key == 27) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStroke(key, mod);
                if (!OBDAPreferencesPanel.this.isKeyStrokeAlreadyAssigned(stroke)) {
                    OBDAPreferencesPanel.this.shortCuts.put("edit.Mapping.id", stroke);
                    OBDAPreferencesPanel.this.lblMappingIdKey.setText(KeyEvent.getKeyModifiersText(stroke.getModifiers()) + " + " + KeyEvent.getKeyText(stroke.getKeyCode()));
                    OBDAPreferencesPanel.this.lblMappingIdKey.setToolTipText(stroke.toString());
                    OBDAPreferencesPanel.this.pref.put("edit.Mapping.id", stroke.toString());
                } else {
                    KeyStroke oldValue = (KeyStroke)OBDAPreferencesPanel.this.shortCuts.get("edit.Mapping.id");
                    if (oldValue != null) {
                        OBDAPreferencesPanel.this.lblMappingIdKey.setText(KeyEvent.getKeyModifiersText(oldValue.getModifiers()) + " + " + KeyEvent.getKeyText(oldValue.getKeyCode()));
                    }
                    JOptionPane.showMessageDialog(OBDAPreferencesPanel.this.getRootPane(), "Key stroke already assigned. Please choose an other combination.", "ERROR", 0);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private void applyPreferences() {
        Color clazz = new Color(Integer.parseInt(this.pref.get("class_Color").toString()));
        this.cmdClassColor.setBackground(clazz);
        this.cmdClassColor.setOpaque(true);
        this.cmdClassColor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 3));
        Color dp = new Color(Integer.parseInt(this.pref.get("dataProperty_Color").toString()));
        this.cmdDataPropertyColor.setBackground(dp);
        this.cmdDataPropertyColor.setOpaque(true);
        this.cmdDataPropertyColor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 3));
        Color op = new Color(Integer.parseInt(this.pref.get("objectproperty_Color").toString()));
        this.cmdObjectPropertyColor.setBackground(op);
        this.cmdObjectPropertyColor.setOpaque(true);
        this.cmdObjectPropertyColor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 3));
        Color var = new Color(Integer.parseInt(this.pref.get("variable_Color").toString()));
        this.cmdVariableColor.setBackground(var);
        this.cmdVariableColor.setOpaque(true);
        this.cmdVariableColor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 3));
        Color par = new Color(Integer.parseInt(this.pref.get("parameter_Color").toString()));
        this.cmdParameterColor.setBackground(par);
        this.cmdParameterColor.setOpaque(true);
        this.cmdParameterColor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 3));
        Color fun = new Color(Integer.parseInt(this.pref.get("functor_Color").toString()));
        this.cmdFunctorColor.setBackground(fun);
        this.cmdFunctorColor.setOpaque(true);
        this.cmdFunctorColor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 3));
        String fontBody = this.pref.get("fontfamily").toString();
        int bodySize = Integer.parseInt(this.pref.get("fontsize").toString());
        this.cmdFontFamily.setText(fontBody + ", " + bodySize);
        this.cmdFontFamily.setToolTipText(fontBody + ", " + bodySize);
        this.jCheckBoxUseDefault.setSelected(new Boolean(this.pref.get("use.default.fontsettings").toString()));
        if (this.jCheckBoxUseDefault.isSelected()) {
            this.cmdFontFamily.setEnabled(false);
        } else {
            this.cmdFontFamily.setEnabled(true);
        }
    }

    private void initComponents() {
        this.tabMainPanel = new JTabbedPane();
        this.pnlDisplayPreferencesTab = new JPanel();
        this.pnlClassPreferences = new JPanel();
        this.lblClass = new JLabel();
        this.cmdClassColor = new JButton();
        this.lblDataProperty = new JLabel();
        this.cmdDataPropertyColor = new JButton();
        this.lblObjectProperty = new JLabel();
        this.cmdObjectPropertyColor = new JButton();
        this.pnlVariablePreferences = new JPanel();
        this.lblParameter = new JLabel();
        this.cmdParameterColor = new JButton();
        this.lblVariable = new JLabel();
        this.cmdVariableColor = new JButton();
        this.lblFunctors = new JLabel();
        this.cmdFunctorColor = new JButton();
        this.pnlMappingPreferences = new JPanel();
        this.lblMappingBody = new JLabel();
        this.cmdFontFamily = new JButton();
        this.jCheckBoxUseDefault = new JCheckBox();
        this.jLabelplaceholder2 = new JLabel();
        this.pnlEditingShortcutTab = new JPanel();
        this.pnlShortcutSettings = new JPanel();
        this.lblAddMapping = new JLabel();
        this.lblAddMappingKey = new JLabel();
        this.lblDeleteMapping = new JLabel();
        this.lblDeleteMappingKey = new JLabel();
        this.lblEditMappingHead = new JLabel();
        this.lblEditMappingHeadKey = new JLabel();
        this.lblEditMappingBody = new JLabel();
        this.lblEditMappingBodyKey = new JLabel();
        this.lblEditMappingId = new JLabel();
        this.lblMappingIdKey = new JLabel();
        this.lblInfo = new JLabel();
        this.jLabelPlaceholder = new JLabel();
        this.setMinimumSize(new Dimension(520, 600));
        this.setPreferredSize(new Dimension(520, 600));
        this.setLayout(new BorderLayout());
        this.tabMainPanel.setMinimumSize(new Dimension(200, 200));
        this.tabMainPanel.setOpaque(true);
        this.tabMainPanel.setPreferredSize(new Dimension(500, 800));
        this.pnlDisplayPreferencesTab.setMinimumSize(new Dimension(485, 560));
        this.pnlDisplayPreferencesTab.setPreferredSize(new Dimension(485, 560));
        this.pnlDisplayPreferencesTab.setLayout(new GridBagLayout());
        this.pnlClassPreferences.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray), "OWL Entities preferences"));
        this.pnlClassPreferences.setMinimumSize(new Dimension(475, 110));
        this.pnlClassPreferences.setPreferredSize(new Dimension(475, 110));
        this.pnlClassPreferences.setLayout(new GridBagLayout());
        this.lblClass.setText("Class:\n\n\n");
        this.lblClass.setMaximumSize(new Dimension(100, 20));
        this.lblClass.setMinimumSize(new Dimension(100, 20));
        this.lblClass.setPreferredSize(new Dimension(100, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlClassPreferences.add((Component)this.lblClass, gridBagConstraints);
        this.cmdClassColor.setFont(new Font("DejaVu Sans", 0, 10));
        this.cmdClassColor.setMaximumSize(new Dimension(200, 17));
        this.cmdClassColor.setMinimumSize(new Dimension(60, 17));
        this.cmdClassColor.setPreferredSize(new Dimension(120, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.pnlClassPreferences.add((Component)this.cmdClassColor, gridBagConstraints);
        this.lblDataProperty.setText("Data Property:");
        this.lblDataProperty.setMaximumSize(new Dimension(100, 20));
        this.lblDataProperty.setMinimumSize(new Dimension(100, 20));
        this.lblDataProperty.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlClassPreferences.add((Component)this.lblDataProperty, gridBagConstraints);
        this.cmdDataPropertyColor.setFont(new Font("DejaVu Sans", 0, 10));
        this.cmdDataPropertyColor.setMaximumSize(new Dimension(200, 17));
        this.cmdDataPropertyColor.setMinimumSize(new Dimension(60, 17));
        this.cmdDataPropertyColor.setPreferredSize(new Dimension(120, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.pnlClassPreferences.add((Component)this.cmdDataPropertyColor, gridBagConstraints);
        this.lblObjectProperty.setText("Object Property:");
        this.lblObjectProperty.setMaximumSize(new Dimension(100, 20));
        this.lblObjectProperty.setMinimumSize(new Dimension(100, 20));
        this.lblObjectProperty.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlClassPreferences.add((Component)this.lblObjectProperty, gridBagConstraints);
        this.cmdObjectPropertyColor.setFont(new Font("DejaVu Sans", 0, 10));
        this.cmdObjectPropertyColor.setMaximumSize(new Dimension(200, 17));
        this.cmdObjectPropertyColor.setMinimumSize(new Dimension(60, 17));
        this.cmdObjectPropertyColor.setPreferredSize(new Dimension(120, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.pnlClassPreferences.add((Component)this.cmdObjectPropertyColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.pnlDisplayPreferencesTab.add((Component)this.pnlClassPreferences, gridBagConstraints);
        this.pnlVariablePreferences.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray), "Variable preferences"));
        this.pnlVariablePreferences.setMinimumSize(new Dimension(475, 110));
        this.pnlVariablePreferences.setPreferredSize(new Dimension(475, 110));
        this.pnlVariablePreferences.setLayout(new GridBagLayout());
        this.lblParameter.setText("Parameter:");
        this.lblParameter.setMaximumSize(new Dimension(100, 20));
        this.lblParameter.setMinimumSize(new Dimension(100, 20));
        this.lblParameter.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlVariablePreferences.add((Component)this.lblParameter, gridBagConstraints);
        this.cmdParameterColor.setFont(new Font("DejaVu Sans", 0, 10));
        this.cmdParameterColor.setMaximumSize(new Dimension(200, 17));
        this.cmdParameterColor.setMinimumSize(new Dimension(60, 17));
        this.cmdParameterColor.setPreferredSize(new Dimension(120, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.pnlVariablePreferences.add((Component)this.cmdParameterColor, gridBagConstraints);
        this.lblVariable.setText("Variable:");
        this.lblVariable.setMaximumSize(new Dimension(100, 20));
        this.lblVariable.setMinimumSize(new Dimension(100, 20));
        this.lblVariable.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlVariablePreferences.add((Component)this.lblVariable, gridBagConstraints);
        this.cmdVariableColor.setFont(new Font("DejaVu Sans", 0, 10));
        this.cmdVariableColor.setMaximumSize(new Dimension(200, 17));
        this.cmdVariableColor.setMinimumSize(new Dimension(60, 17));
        this.cmdVariableColor.setPreferredSize(new Dimension(120, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.pnlVariablePreferences.add((Component)this.cmdVariableColor, gridBagConstraints);
        this.lblFunctors.setText("Functor:");
        this.lblFunctors.setMaximumSize(new Dimension(100, 20));
        this.lblFunctors.setMinimumSize(new Dimension(100, 20));
        this.lblFunctors.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlVariablePreferences.add((Component)this.lblFunctors, gridBagConstraints);
        this.cmdFunctorColor.setFont(new Font("DejaVu Sans", 0, 10));
        this.cmdFunctorColor.setMaximumSize(new Dimension(200, 17));
        this.cmdFunctorColor.setMinimumSize(new Dimension(60, 17));
        this.cmdFunctorColor.setPreferredSize(new Dimension(120, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.pnlVariablePreferences.add((Component)this.cmdFunctorColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.pnlDisplayPreferencesTab.add((Component)this.pnlVariablePreferences, gridBagConstraints);
        this.pnlMappingPreferences.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray), "Font Preferences"));
        this.pnlMappingPreferences.setMinimumSize(new Dimension(475, 90));
        this.pnlMappingPreferences.setPreferredSize(new Dimension(475, 90));
        this.pnlMappingPreferences.setLayout(new GridBagLayout());
        this.lblMappingBody.setText("Font Family:");
        this.lblMappingBody.setMaximumSize(new Dimension(100, 20));
        this.lblMappingBody.setMinimumSize(new Dimension(100, 20));
        this.lblMappingBody.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlMappingPreferences.add((Component)this.lblMappingBody, gridBagConstraints);
        this.cmdFontFamily.setFont(new Font("DejaVu Sans", 0, 10));
        this.cmdFontFamily.setMaximumSize(new Dimension(200, 17));
        this.cmdFontFamily.setMinimumSize(new Dimension(90, 17));
        this.cmdFontFamily.setPreferredSize(new Dimension(120, 17));
        this.cmdFontFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OBDAPreferencesPanel.this.cmdFontFamilyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.pnlMappingPreferences.add((Component)this.cmdFontFamily, gridBagConstraints);
        this.jCheckBoxUseDefault.setText("Use default fonts        ");
        this.jCheckBoxUseDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OBDAPreferencesPanel.this.jCheckBoxUseDefaultActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 0, 20);
        this.pnlMappingPreferences.add((Component)this.jCheckBoxUseDefault, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.pnlDisplayPreferencesTab.add((Component)this.pnlMappingPreferences, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.pnlDisplayPreferencesTab.add((Component)this.jLabelplaceholder2, gridBagConstraints);
        this.tabMainPanel.addTab("Display Preference", this.pnlDisplayPreferencesTab);
        this.pnlEditingShortcutTab.setMinimumSize(new Dimension(212, 150));
        this.pnlEditingShortcutTab.setPreferredSize(new Dimension(450, 150));
        this.pnlEditingShortcutTab.setLayout(new GridBagLayout());
        this.pnlShortcutSettings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray), "Shortcut Settings"));
        this.pnlShortcutSettings.setMinimumSize(new Dimension(475, 165));
        this.pnlShortcutSettings.setPreferredSize(new Dimension(475, 165));
        this.pnlShortcutSettings.setLayout(new GridBagLayout());
        this.lblAddMapping.setText("Add Mapping: *");
        this.lblAddMapping.setMaximumSize(new Dimension(100, 20));
        this.lblAddMapping.setMinimumSize(new Dimension(100, 20));
        this.lblAddMapping.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 170;
        gridBagConstraints.anchor = 17;
        this.pnlShortcutSettings.add((Component)this.lblAddMapping, gridBagConstraints);
        this.lblAddMappingKey.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblAddMappingKey.setMaximumSize(new Dimension(120, 20));
        this.lblAddMappingKey.setMinimumSize(new Dimension(120, 20));
        this.lblAddMappingKey.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlShortcutSettings.add((Component)this.lblAddMappingKey, gridBagConstraints);
        this.lblDeleteMapping.setText("Delete Mapping: *");
        this.lblDeleteMapping.setMaximumSize(new Dimension(100, 20));
        this.lblDeleteMapping.setMinimumSize(new Dimension(100, 20));
        this.lblDeleteMapping.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 170;
        gridBagConstraints.anchor = 17;
        this.pnlShortcutSettings.add((Component)this.lblDeleteMapping, gridBagConstraints);
        this.lblDeleteMappingKey.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblDeleteMappingKey.setEnabled(false);
        this.lblDeleteMappingKey.setMaximumSize(new Dimension(120, 20));
        this.lblDeleteMappingKey.setMinimumSize(new Dimension(120, 20));
        this.lblDeleteMappingKey.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlShortcutSettings.add((Component)this.lblDeleteMappingKey, gridBagConstraints);
        this.lblEditMappingHead.setText("Edit Target Query: *");
        this.lblEditMappingHead.setMaximumSize(new Dimension(100, 20));
        this.lblEditMappingHead.setMinimumSize(new Dimension(100, 20));
        this.lblEditMappingHead.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 170;
        gridBagConstraints.anchor = 17;
        this.pnlShortcutSettings.add((Component)this.lblEditMappingHead, gridBagConstraints);
        this.lblEditMappingHeadKey.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblEditMappingHeadKey.setMaximumSize(new Dimension(120, 20));
        this.lblEditMappingHeadKey.setMinimumSize(new Dimension(120, 20));
        this.lblEditMappingHeadKey.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlShortcutSettings.add((Component)this.lblEditMappingHeadKey, gridBagConstraints);
        this.lblEditMappingBody.setText("Edit Source Query: *");
        this.lblEditMappingBody.setMaximumSize(new Dimension(100, 20));
        this.lblEditMappingBody.setMinimumSize(new Dimension(100, 20));
        this.lblEditMappingBody.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 170;
        gridBagConstraints.anchor = 17;
        this.pnlShortcutSettings.add((Component)this.lblEditMappingBody, gridBagConstraints);
        this.lblEditMappingBodyKey.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblEditMappingBodyKey.setMaximumSize(new Dimension(120, 20));
        this.lblEditMappingBodyKey.setMinimumSize(new Dimension(120, 20));
        this.lblEditMappingBodyKey.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlShortcutSettings.add((Component)this.lblEditMappingBodyKey, gridBagConstraints);
        this.lblEditMappingId.setText("Edit Mapping ID: *");
        this.lblEditMappingId.setMaximumSize(new Dimension(100, 20));
        this.lblEditMappingId.setMinimumSize(new Dimension(100, 20));
        this.lblEditMappingId.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 170;
        gridBagConstraints.anchor = 17;
        this.pnlShortcutSettings.add((Component)this.lblEditMappingId, gridBagConstraints);
        this.lblMappingIdKey.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblMappingIdKey.setMaximumSize(new Dimension(120, 20));
        this.lblMappingIdKey.setMinimumSize(new Dimension(120, 20));
        this.lblMappingIdKey.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlShortcutSettings.add((Component)this.lblMappingIdKey, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 25;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlEditingShortcutTab.add((Component)this.pnlShortcutSettings, gridBagConstraints);
        this.lblInfo.setText("* Having the effect of the new shortcut requires a program restart.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlEditingShortcutTab.add((Component)this.lblInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.pnlEditingShortcutTab.add((Component)this.jLabelPlaceholder, gridBagConstraints);
        this.tabMainPanel.addTab("Mapping Editing Shortcut", this.pnlEditingShortcutTab);
        this.add((Component)this.tabMainPanel, "Center");
    }

    private void cmdFontFamilyActionPerformed(ActionEvent evt) {
        FontChooser2 fe = new FontChooser2(this.cmdFontFamily, "fontfamily", "fontsize", "isBold");
    }

    private void jCheckBoxUseDefaultActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxUseDefault.isSelected()) {
            this.pref.put("use.default.fontsettings", "true");
            this.cmdFontFamily.setEnabled(false);
        } else {
            this.pref.put("use.default.fontsettings", "false");
            this.cmdFontFamily.setEnabled(true);
        }
    }

    public class FontChooser2
    extends JPanel {
        private static final long serialVersionUID = -602845875138513553L;
        protected Font resultFont;
        protected String resultName;
        protected int resultSize;
        protected boolean isBold;
        protected boolean isItalic;
        protected String displayText = "Qwerty Yuiop";
        protected String[] fontList;
        protected JList fontNameChoice;
        protected JList fontSizeChoice;
        JCheckBox bold;
        protected String[] fontSizes = new String[]{"8", "10", "11", "12", "14", "16", "18", "20", "24", "30", "36", "40", "48", "60", "72"};
        protected static final int DEFAULT_SIZE = 4;
        protected String fontfamily = null;
        protected String fontsize = null;
        protected String isbold = null;
        protected JButton button = null;

        public FontChooser2(JButton b, String ff, String fs, String isb) {
            int ret;
            this.fontfamily = ff;
            this.fontsize = fs;
            this.isbold = isb;
            this.button = b;
            this.init();
            JOptionPane pane = new JOptionPane(this, -1, 2);
            JDialog d = pane.createDialog("Font Chooser");
            d.setModal(true);
            d.setSize(400, 300);
            d.setResizable(true);
            d.setVisible(true);
            Object o = pane.getValue();
            if (o != null && (ret = ((Integer)o).intValue()) == 0) {
                this.applyChanges();
            }
        }

        private void init() {
            this.fontNameChoice = new JList();
            this.fontSizeChoice = new JList();
            JScrollPane scrFontNameList = new JScrollPane();
            JScrollPane scrFontSizeList = new JScrollPane();
            this.bold = new JCheckBox();
            OBDAPreferencesPanel.this.pnlDisplayPreferencesTab = new JPanel();
            this.setMinimumSize(new Dimension(400, 300));
            this.setLayout(new GridBagLayout());
            this.fontNameChoice.setModel(new AbstractListModel(){
                private static final long serialVersionUID = -1794346954116474402L;
                String[] strings = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

                @Override
                public int getSize() {
                    return this.strings.length;
                }

                @Override
                public Object getElementAt(int i) {
                    return this.strings[i];
                }
            });
            scrFontNameList.setViewportView(this.fontNameChoice);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)scrFontNameList, gridBagConstraints);
            this.fontSizeChoice.setModel(new AbstractListModel(){
                private static final long serialVersionUID = 4046867275908672992L;
                String[] strings = new String[]{"8", "10", "11", "12", "14", "16", "18", "20", "24", "30", "36", "40", "48", "60", "72"};

                @Override
                public int getSize() {
                    return this.strings.length;
                }

                @Override
                public Object getElementAt(int i) {
                    return this.strings[i];
                }
            });
            this.fontSizeChoice.setMaximumSize(new Dimension(50, 285));
            this.fontSizeChoice.setMinimumSize(new Dimension(50, 285));
            this.fontSizeChoice.setPreferredSize(new Dimension(50, 285));
            scrFontSizeList.setViewportView(this.fontSizeChoice);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)scrFontSizeList, gridBagConstraints);
            this.bold.setFont(new Font("DejaVu Sans", 1, 13));
            this.bold.setText("Bold");
            this.bold.setBorder(null);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.bold, gridBagConstraints);
            OBDAPreferencesPanel.this.pnlDisplayPreferencesTab.setLayout(new GridBagLayout());
            String currentFont = OBDAPreferencesPanel.this.pref.get("fontfamily").toString();
            int currentSize = Integer.parseInt(OBDAPreferencesPanel.this.pref.get("fontsize").toString());
            Boolean isBold = new Boolean(OBDAPreferencesPanel.this.pref.get("isBold").toString());
            int i = this.getIndexOfFont(currentFont);
            int j = this.getIndexOfSize(String.valueOf(currentSize));
            this.fontNameChoice.setSelectedIndex(i);
            this.fontSizeChoice.setSelectedIndex(j);
            this.bold.setSelected(isBold);
        }

        private int getIndexOfFont(String font) {
            AbstractListModel model = (AbstractListModel)this.fontNameChoice.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                if (!model.getElementAt(i).equals(font)) continue;
                return i;
            }
            return 0;
        }

        private int getIndexOfSize(String size) {
            AbstractListModel model = (AbstractListModel)this.fontSizeChoice.getModel();
            int length = model.getSize();
            for (int i = 0; i < length; ++i) {
                if (!model.getElementAt(i).equals(size)) continue;
                return i;
            }
            return 0;
        }

        protected void applyChanges() {
            this.resultName = (String)this.fontNameChoice.getSelectedValue();
            String resultSizeName = (String)this.fontSizeChoice.getSelectedValue();
            this.isBold = this.bold.isSelected();
            OBDAPreferencesPanel.this.pref.put("fontfamily", this.resultName);
            OBDAPreferencesPanel.this.pref.put("fontsize", resultSizeName);
            OBDAPreferencesPanel.this.pref.put("isBold", new Boolean(this.isBold).toString());
            this.button.setText(this.resultName + ", " + resultSizeName);
            this.button.setToolTipText(this.resultName + ", " + resultSizeName);
        }

        protected void previewFont() {
            this.resultName = (String)this.fontNameChoice.getSelectedValue();
            String resultSizeName = (String)this.fontSizeChoice.getSelectedValue();
            int resultSize = Integer.parseInt(resultSizeName);
            this.isBold = this.bold.isSelected();
            int attrs = 0;
            if (this.isBold) {
                attrs = 1;
            }
            if (this.isItalic) {
                attrs |= 2;
            }
            this.resultFont = new Font(this.resultName, attrs, resultSize);
        }

        public String getSelectedName() {
            return this.resultName;
        }

        public int getSelectedSize() {
            return this.resultSize;
        }

        public Font getSelectedFont() {
            return this.resultFont;
        }
    }

    private class ColorChooser
    extends JPanel {
        private static final long serialVersionUID = -5704647065277117955L;
        JButton button = null;
        String key = null;
        private JColorChooser jColorChooser1;
        private JLabel jLabel1;
        private JLabel jLabel2;

        private ColorChooser(JButton button, String key) {
            int ret;
            this.button = button;
            this.key = key;
            this.setSize(500, 500);
            this.initComponents();
            JOptionPane pane = new JOptionPane(this, -1, 2);
            JDialog d = pane.createDialog("Color Chooser");
            d.setModal(true);
            d.setVisible(true);
            Object o = pane.getValue();
            if (pane != null && (ret = ((Integer)o).intValue()) == 0) {
                this.applyPreferences();
            }
        }

        private void initComponents() {
            this.jColorChooser1 = new JColorChooser();
            OBDAPreferencesPanel.this.jLabelplaceholder2 = new JLabel();
            this.jLabel2 = new JLabel();
            this.setLayout(new GridBagLayout());
            this.jColorChooser1.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.ipady = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(7, 7, 7, 7);
            this.add((Component)this.jColorChooser1, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)OBDAPreferencesPanel.this.jLabelplaceholder2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.jLabel2, gridBagConstraints);
        }

        private void applyPreferences() {
            Color aux = this.jColorChooser1.getSelectionModel().getSelectedColor();
            Integer rgb = aux.getRGB();
            OBDAPreferencesPanel.this.pref.put(this.key, rgb.toString());
            this.button.setBackground(aux);
            this.button.setOpaque(true);
        }
    }
}

