/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.utils.ConnectionTools;
import it.unibz.inf.ontop.protege.utils.CustomTraversalPolicy;
import it.unibz.inf.ontop.protege.utils.DatasourceSelectorListener;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.JDBCConnectionManager;
import it.unibz.inf.ontop.spec.mapping.pp.impl.SQLPPMappingImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.protege.editor.owl.OWLEditorKit;

public class DatasourceParameterEditorPanel
extends JPanel
implements DatasourceSelectorListener {
    private static final long serialVersionUID = 3506358479342412849L;
    private final OWLEditorKit owlEditorKit;
    private OBDAModel obdaModel;
    private ComboBoxItemListener comboListener;
    private Timer timer = null;
    private JButton cmdTestConnection;
    private JLabel lblConnectionStatus;
    private JLabel lblDatabasePassword;
    private JLabel lblDatabaseUsername;
    private JLabel lblJdbcDriver;
    private JLabel lblJdbcUrl;
    private JPanel pnlDataSourceParameters;
    private JPanel pnlInformation;
    private JPasswordField txtDatabasePassword;
    private JTextField txtDatabaseUsername;
    private JComboBox<String> txtJdbcDriver;
    private JTextField txtJdbcUrl;

    public DatasourceParameterEditorPanel(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        OBDAModelManager obdaModelManager = (OBDAModelManager)owlEditorKit.get((Object)SQLPPMappingImpl.class.getName());
        OBDAModel model = obdaModelManager.getActiveOBDAModel();
        this.timer = new Timer(200, e -> this.handleTimer());
        this.initComponents();
        this.comboListener = new ComboBoxItemListener();
        this.txtJdbcDriver.addItemListener(this.comboListener);
        this.setNewDatasource(model);
        ArrayList<Component> order = new ArrayList<Component>(7);
        order.add(this.pnlDataSourceParameters);
        order.add(this.txtJdbcUrl);
        order.add(this.txtDatabaseUsername);
        order.add(this.txtDatabasePassword);
        order.add(this.txtJdbcDriver);
        order.add(this.cmdTestConnection);
        this.setFocusTraversalPolicy(new CustomTraversalPolicy(order));
    }

    private void handleTimer() {
        this.timer.stop();
        this.updateSourceValues();
    }

    public void setNewDatasource(OBDAModel model) {
        this.obdaModel = model;
        this.resetTextFields();
        this.currentDatasourceChange();
    }

    private void resetTextFields() {
        this.txtJdbcUrl.setText("");
        this.txtDatabasePassword.setText("");
        this.txtDatabaseUsername.setText("");
        this.comboListener.setNotify(false);
        this.txtJdbcDriver.setSelectedIndex(0);
        this.comboListener.setNotify(true);
    }

    private void initComponents() {
        this.pnlDataSourceParameters = new JPanel();
        this.txtJdbcUrl = new JTextField();
        this.txtDatabaseUsername = new JTextField();
        this.txtDatabasePassword = new JPasswordField();
        this.txtJdbcDriver = new JComboBox();
        this.cmdTestConnection = new JButton();
        this.lblJdbcUrl = new JLabel();
        this.lblDatabaseUsername = new JLabel();
        this.lblDatabasePassword = new JLabel();
        this.lblJdbcDriver = new JLabel();
        this.lblConnectionStatus = new JLabel();
        this.pnlInformation = new JPanel();
        this.setFocusable(false);
        this.setMinimumSize(new Dimension(640, 480));
        this.setPreferredSize(new Dimension(640, 480));
        this.setLayout(new GridBagLayout());
        this.pnlDataSourceParameters.setBorder(BorderFactory.createTitledBorder(null, "Connection parameters", 0, 0, new Font("Lucida Grande", 0, 13), new Color(53, 113, 163)));
        this.pnlDataSourceParameters.setForeground(new Color(53, 113, 163));
        this.pnlDataSourceParameters.setAlignmentX(5.0f);
        this.pnlDataSourceParameters.setAlignmentY(5.0f);
        this.pnlDataSourceParameters.setAutoscrolls(true);
        this.pnlDataSourceParameters.setFocusable(false);
        this.pnlDataSourceParameters.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.pnlDataSourceParameters.setMinimumSize(new Dimension(0, 0));
        this.pnlDataSourceParameters.setPreferredSize(new Dimension(1, 300));
        this.pnlDataSourceParameters.setLayout(new GridBagLayout());
        this.txtJdbcUrl.setFont(new Font("Courier New", 1, 13));
        this.txtJdbcUrl.setMaximumSize(new Dimension(25, Integer.MAX_VALUE));
        this.txtJdbcUrl.setMinimumSize(new Dimension(180, 24));
        this.txtJdbcUrl.setPreferredSize(new Dimension(180, 24));
        this.txtJdbcUrl.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DatasourceParameterEditorPanel.this.fieldChangeHandler(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(30, 0, 2, 30);
        this.pnlDataSourceParameters.add((Component)this.txtJdbcUrl, gridBagConstraints);
        this.txtDatabaseUsername.setFont(new Font("Courier New", 1, 13));
        this.txtDatabaseUsername.setMaximumSize(new Dimension(25, Integer.MAX_VALUE));
        this.txtDatabaseUsername.setMinimumSize(new Dimension(180, 24));
        this.txtDatabaseUsername.setPreferredSize(new Dimension(180, 24));
        this.txtDatabaseUsername.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DatasourceParameterEditorPanel.this.fieldChangeHandler(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 2, 30);
        this.pnlDataSourceParameters.add((Component)this.txtDatabaseUsername, gridBagConstraints);
        this.txtDatabasePassword.setFont(new Font("Courier New", 1, 13));
        this.txtDatabasePassword.setMinimumSize(new Dimension(180, 24));
        this.txtDatabasePassword.setPreferredSize(new Dimension(180, 24));
        this.txtDatabasePassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DatasourceParameterEditorPanel.this.fieldChangeHandler(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 0, 2, 30);
        this.pnlDataSourceParameters.add((Component)this.txtDatabasePassword, gridBagConstraints);
        this.txtJdbcDriver.setEditable(true);
        this.txtJdbcDriver.setFont(new Font("Courier New", 1, 13));
        this.txtJdbcDriver.setModel(new DefaultComboBoxModel<String>(new String[]{"select or type the JDBC Driver class...", "org.postgresql.Driver", "com.mysql.jdbc.Driver", "org.h2.Driver", "com.ibm.db2.jcc.DB2Driver", "oracle.jdbc.driver.OracleDriver", "com.microsoft.sqlserver.jdbc.SQLServerDriver"}));
        this.txtJdbcDriver.setMinimumSize(new Dimension(180, 24));
        this.txtJdbcDriver.setPreferredSize(new Dimension(180, 24));
        this.txtJdbcDriver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatasourceParameterEditorPanel.this.txtJdbcDriverActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 0, 2, 30);
        this.pnlDataSourceParameters.add(this.txtJdbcDriver, gridBagConstraints);
        this.cmdTestConnection.setIcon(IconLoader.getImageIcon("images/execute.png"));
        this.cmdTestConnection.setText("Test Connection");
        this.cmdTestConnection.setBorder(BorderFactory.createEtchedBorder());
        this.cmdTestConnection.setContentAreaFilled(false);
        this.cmdTestConnection.setIconTextGap(5);
        this.cmdTestConnection.setMaximumSize(new Dimension(110, 25));
        this.cmdTestConnection.setMinimumSize(new Dimension(110, 25));
        this.cmdTestConnection.setPreferredSize(new Dimension(110, 25));
        this.cmdTestConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatasourceParameterEditorPanel.this.cmdTestConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 10, 10, 20);
        this.pnlDataSourceParameters.add((Component)this.cmdTestConnection, gridBagConstraints);
        this.lblJdbcUrl.setFont(new Font("Dialog", 1, 12));
        this.lblJdbcUrl.setForeground(new Color(53, 113, 163));
        this.lblJdbcUrl.setText("Connection URL:");
        this.lblJdbcUrl.setFocusTraversalKeysEnabled(false);
        this.lblJdbcUrl.setFocusable(false);
        this.lblJdbcUrl.setMaximumSize(new Dimension(130, 24));
        this.lblJdbcUrl.setMinimumSize(new Dimension(130, 24));
        this.lblJdbcUrl.setPreferredSize(new Dimension(130, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(30, 10, 2, 20);
        this.pnlDataSourceParameters.add((Component)this.lblJdbcUrl, gridBagConstraints);
        this.lblDatabaseUsername.setFont(new Font("Dialog", 1, 12));
        this.lblDatabaseUsername.setForeground(new Color(53, 113, 163));
        this.lblDatabaseUsername.setText("Database Username:");
        this.lblDatabaseUsername.setFocusTraversalKeysEnabled(false);
        this.lblDatabaseUsername.setFocusable(false);
        this.lblDatabaseUsername.setMaximumSize(new Dimension(130, 24));
        this.lblDatabaseUsername.setMinimumSize(new Dimension(130, 24));
        this.lblDatabaseUsername.setPreferredSize(new Dimension(130, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 10, 2, 20);
        this.pnlDataSourceParameters.add((Component)this.lblDatabaseUsername, gridBagConstraints);
        this.lblDatabasePassword.setFont(new Font("Dialog", 1, 12));
        this.lblDatabasePassword.setForeground(new Color(53, 113, 163));
        this.lblDatabasePassword.setText("Database Password:");
        this.lblDatabasePassword.setFocusTraversalKeysEnabled(false);
        this.lblDatabasePassword.setFocusable(false);
        this.lblDatabasePassword.setMaximumSize(new Dimension(130, 24));
        this.lblDatabasePassword.setMinimumSize(new Dimension(130, 24));
        this.lblDatabasePassword.setPreferredSize(new Dimension(130, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 10, 2, 20);
        this.pnlDataSourceParameters.add((Component)this.lblDatabasePassword, gridBagConstraints);
        this.lblJdbcDriver.setFont(new Font("Dialog", 1, 12));
        this.lblJdbcDriver.setForeground(new Color(53, 113, 163));
        this.lblJdbcDriver.setText("Driver class:");
        this.lblJdbcDriver.setFocusTraversalKeysEnabled(false);
        this.lblJdbcDriver.setFocusable(false);
        this.lblJdbcDriver.setMaximumSize(new Dimension(130, 24));
        this.lblJdbcDriver.setMinimumSize(new Dimension(130, 24));
        this.lblJdbcDriver.setPreferredSize(new Dimension(130, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 10, 2, 20);
        this.pnlDataSourceParameters.add((Component)this.lblJdbcDriver, gridBagConstraints);
        this.lblConnectionStatus.setFont(new Font("Courier New", 1, 13));
        this.lblConnectionStatus.setVerticalAlignment(1);
        this.lblConnectionStatus.setBorder(BorderFactory.createEmptyBorder(5, 1, 1, 1));
        this.lblConnectionStatus.setFocusTraversalKeysEnabled(false);
        this.lblConnectionStatus.setFocusable(false);
        this.lblConnectionStatus.setMaximumSize(new Dimension(180, 108));
        this.lblConnectionStatus.setMinimumSize(new Dimension(180, 108));
        this.lblConnectionStatus.setPreferredSize(new Dimension(180, 108));
        this.lblConnectionStatus.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 0, 10, 10);
        this.pnlDataSourceParameters.add((Component)this.lblConnectionStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlDataSourceParameters, gridBagConstraints);
        this.pnlInformation.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlInformation, gridBagConstraints);
    }

    private void cmdHelpActionPerformed(ActionEvent evt) {
        DialogUtils.open(URI.create("https://github.com/ontop/ontop/wiki/ObdalibPluginJDBC"), this);
    }

    private void txtJdbcDriverActionPerformed(ActionEvent evt) {
        this.fieldChangeHandler(null);
    }

    private void cmdTestConnectionActionPerformed(ActionEvent evt) {
        this.lblConnectionStatus.setText("Establishing connection...");
        this.lblConnectionStatus.setForeground(Color.BLACK);
        OBDADataSource datasource = this.obdaModel.getDatasource();
        String driver = datasource.getParameter("jdbc.driver");
        if (driver.isEmpty()) {
            this.lblConnectionStatus.setForeground(Color.RED);
            this.lblConnectionStatus.setText("Please, select or type the JDBC Driver class.");
        } else {
            Runnable run = () -> {
                JDBCConnectionManager connm = JDBCConnectionManager.getJDBCConnectionManager();
                try {
                    try {
                        connm.closeConnection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Connection conn = ConnectionTools.getConnection(datasource);
                    if (conn == null) {
                        throw new SQLException("Error connecting to the database");
                    }
                    this.lblConnectionStatus.setForeground(Color.GREEN.darker());
                    this.lblConnectionStatus.setText("Connection is OK");
                }
                catch (SQLException e) {
                    String help = "";
                    if (e.getMessage().startsWith("No suitable driver")) {
                        help = "<br/><br/> HINT: To setup JDBC drivers, open the Preference panel and go to the \"JDBC Drives\" tab. (Windows and Linux: Files &gt; Preferences..., Mac OS X: Protege &gt; Preferences...) <br/> More information is on the Wiki: <a href='https://github.com/ontop/ontop/wiki/FAQ'>https://github.com/ontop/ontop/wiki/FAQ</a>";
                    }
                    this.lblConnectionStatus.setForeground(Color.RED);
                    this.lblConnectionStatus.setText(String.format("<html>%s (ERR-CODE: %s)%s</html>", e.getMessage(), e.getErrorCode(), help));
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    private void fieldChangeHandler(KeyEvent evt) {
        this.timer.restart();
    }

    private void updateSourceValues() {
        JDBCConnectionManager man = JDBCConnectionManager.getJDBCConnectionManager();
        try {
            man.closeConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String username = this.txtDatabaseUsername.getText();
        OBDADataSource currentDataSource = this.obdaModel.getDatasource();
        currentDataSource.setParameter("jdbc.user", username);
        String password = new String(this.txtDatabasePassword.getPassword());
        currentDataSource.setParameter("jdbc.password", password);
        String driver = this.txtJdbcDriver.getSelectedIndex() == 0 ? "" : (String)this.txtJdbcDriver.getSelectedItem();
        currentDataSource.setParameter("jdbc.driver", driver);
        String url = this.txtJdbcUrl.getText();
        currentDataSource.setParameter("jdbc.url", url);
        if (url.endsWith(" ")) {
            this.lblConnectionStatus.setForeground(Color.RED);
            this.lblConnectionStatus.setText("Warning the URL ends with a white space, this can give rise to connection problems");
        } else if (driver.endsWith(" ")) {
            this.lblConnectionStatus.setForeground(Color.RED);
            this.lblConnectionStatus.setText("Warning the Driver class ends with a white space, this can give rise to connection problems");
        } else if (password.endsWith(" ")) {
            this.lblConnectionStatus.setForeground(Color.RED);
            this.lblConnectionStatus.setText("Warning the password ends with a white space, this can give rise to connection problems");
        } else if (username.endsWith(" ")) {
            this.lblConnectionStatus.setForeground(Color.RED);
            this.lblConnectionStatus.setText("Warning the password ends with a white space, this can give rise to connection problems");
        } else {
            this.lblConnectionStatus.setText("");
        }
        this.obdaModel.fireSourceParametersUpdated();
    }

    private void currentDatasourceChange() {
        OBDADataSource source = this.obdaModel.getDatasource();
        this.comboListener.setNotify(false);
        String driverClass = source.getParameter("jdbc.driver");
        if (driverClass == null || driverClass.isEmpty()) {
            this.txtJdbcDriver.setSelectedIndex(0);
        } else {
            this.txtJdbcDriver.setSelectedItem(driverClass);
        }
        this.txtDatabaseUsername.setText(source.getParameter("jdbc.user"));
        this.txtDatabasePassword.setText(source.getParameter("jdbc.password"));
        this.txtJdbcUrl.setText(source.getParameter("jdbc.url"));
        this.lblConnectionStatus.setText("");
        this.comboListener.setNotify(true);
    }

    @Override
    public void datasourceChanged(OBDADataSource oldSource, OBDADataSource newSource) {
        this.currentDatasourceChange();
    }

    private class ComboBoxItemListener
    implements ItemListener {
        private boolean notify = false;

        private ComboBoxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.notify) {
                DatasourceParameterEditorPanel.this.fieldChangeHandler(null);
            }
        }

        public void setNotify(boolean notify) {
            this.notify = notify;
        }
    }
}

