/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.treemodels;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class IncrementalResultSetTableModel
implements TableModel {
    ResultSet set;
    ResultSetMetaData metadata;
    int numcols;
    int numrows;
    int fetchsize;
    Vector<Vector<String>> results = null;
    Vector<TableModelListener> listener = null;
    boolean isAfterLast = false;

    public IncrementalResultSetTableModel(ResultSet set) throws SQLException {
        int i;
        this.set = set;
        this.metadata = set.getMetaData();
        this.numcols = this.metadata.getColumnCount();
        this.listener = new Vector();
        this.numrows = 100;
        this.fetchsize = 100;
        this.results = new Vector();
        for (i = 1; i <= this.fetchsize && set.next(); ++i) {
            Vector<String> aux = new Vector<String>();
            for (int j = 1; j <= this.numcols; ++j) {
                String s = "";
                Object ob = set.getObject(j);
                s = ob == null ? "null" : ob.toString();
                aux.add(s);
            }
            this.results.add(aux);
        }
        this.numrows = i - 1;
        if (this.numrows < this.fetchsize) {
            this.isAfterLast = true;
        }
    }

    public void close() {
        try {
            Statement statement = this.set.getStatement();
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
            if (this.set != null && !this.set.isClosed()) {
                this.set.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public int getColumnCount() {
        return this.numcols;
    }

    @Override
    public int getRowCount() {
        return this.numrows;
    }

    @Override
    public String getColumnName(int column) {
        try {
            return this.metadata.getColumnLabel(column + 1);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            return e.toString();
        }
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (row + 2 >= this.numrows && !this.isAfterLast) {
                this.fetchMoreResults();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector<String> aux = this.results.get(row);
        return aux.get(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listener.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listener.remove(l);
    }

    private void fetchMoreResults() throws Exception {
        int i = 1;
        while (i <= this.fetchsize && !this.isAfterLast) {
            if (this.set.next()) {
                Vector<String> aux = new Vector<String>();
                for (int j = 1; j <= this.numcols; ++j) {
                    String s = "";
                    Object ob = this.set.getObject(j);
                    s = ob == null ? "null" : ob.toString();
                    aux.add(s);
                }
                this.results.add(aux);
                ++i;
                continue;
            }
            this.isAfterLast = true;
        }
        this.numrows = this.numrows + i - 1;
        this.fireTableChanged();
    }

    private void fireTableChanged() {
        for (TableModelListener l : this.listener) {
            l.tableChanged(new TableModelEvent(this));
        }
    }
}

