/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.component;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.vocabulary.OntopInternal;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.protege.gui.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.apache.commons.rdf.api.IRI;

public class DataTypeComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;

    public DataTypeComboBox() {
        super(DataTypeComboBox.getQuestDataTypes());
        this.setRenderer(new DataTypeRenderer());
        this.setPreferredSize(new Dimension(130, 23));
        this.setSelectedIndex(-1);
    }

    private static IRI[] getQuestDataTypes() {
        ImmutableList datatypeList = ImmutableList.of((Object)XSD.BASE64BINARY, (Object)XSD.BOOLEAN, (Object)XSD.BYTE, (Object)XSD.DATE, (Object)XSD.DATETIME, (Object)XSD.DATETIMESTAMP, (Object)XSD.DECIMAL, (Object)XSD.DOUBLE, (Object)XSD.FLOAT, (Object)XSD.GYEAR, (Object)XSD.INT, (Object)XSD.INTEGER, (Object[])new IRI[]{XSD.LONG, XSD.NEGATIVE_INTEGER, XSD.NON_NEGATIVE_INTEGER, XSD.NON_POSITIVE_INTEGER, XSD.POSITIVE_INTEGER, XSD.SHORT, XSD.STRING, XSD.TIME, XSD.UNSIGNED_BYTE, XSD.UNSIGNED_INT, XSD.UNSIGNED_LONG, XSD.UNSIGNED_SHORT});
        int length = datatypeList.size() + 1;
        IRI[] dataTypes = new IRI[length];
        dataTypes[0] = null;
        System.arraycopy(datatypeList.toArray(), 0, dataTypes, 1, datatypeList.size());
        return dataTypes;
    }

    class DataTypeRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;

        DataTypeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("<Undefined data type>");
                this.setIcon(null);
            } else if (value instanceof IRI) {
                IRI item = (IRI)value;
                String name = item.getIRIString();
                if (name.contains("http://www.w3.org/2001/XMLSchema#")) {
                    name = name.replace("http://www.w3.org/2001/XMLSchema#", OntopInternal.PREFIX_XSD);
                } else if (name.contains("http://www.w3.org/2000/01/rdf-schema#")) {
                    name = name.replace("http://www.w3.org/2000/01/rdf-schema#", OntopInternal.PREFIX_RDFS);
                }
                this.setText(name);
                this.setIcon(IconLoader.getImageIcon("images/datarange.png"));
            }
            return this;
        }
    }
}

