/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.action;

import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.materialization.MaterializationParams;
import it.unibz.inf.ontop.owlapi.OntopOWLAPIMaterializer;
import it.unibz.inf.ontop.owlapi.resultset.MaterializedGraphOWLResultSet;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.gui.action.MaterializeAction;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import it.unibz.inf.ontop.spec.mapping.pp.impl.SQLPPMappingImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLWorkspace;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboxMaterializationAction
extends ProtegeAction {
    private static final long serialVersionUID = -1211395039869926309L;
    private static final String RDF_XML = "RDF/XML";
    private static final String TURTLE = "Turtle";
    private static final String NTRIPLES = "N-Triples";
    private OWLWorkspace workspace;
    private OWLModelManager modelManager;
    private String lineSeparator;
    private OBDAModelManager obdaModelManager;
    private Logger log = LoggerFactory.getLogger(AboxMaterializationAction.class);

    public void initialise() {
        OWLEditorKit editorKit = (OWLEditorKit)this.getEditorKit();
        this.workspace = editorKit.getWorkspace();
        this.modelManager = editorKit.getOWLModelManager();
        this.obdaModelManager = (OBDAModelManager)editorKit.get((Object)SQLPPMappingImpl.class.getName());
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void dispose() {
    }

    public void actionPerformed(ActionEvent arg0) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Choose a materialization option: "), "North");
        JPanel radioAddPanel = new JPanel();
        radioAddPanel.setLayout(new BorderLayout());
        JRadioButton radioAdd = new JRadioButton("Add triples to current ontology", true);
        JPanel radioExportPanel = new JPanel(new BorderLayout());
        JRadioButton radioExport = new JRadioButton("Dump triples to an external file");
        ButtonGroup group = new ButtonGroup();
        group.add(radioAdd);
        group.add(radioExport);
        JLabel lFormat = new JLabel("Output format:\t");
        String[] fileOptions = new String[]{RDF_XML, TURTLE, NTRIPLES};
        JComboBox<String> comboFormats = new JComboBox<String>(fileOptions);
        comboFormats.setEnabled(false);
        JLabel info = new JLabel("<html><br><b>The operation may take some time and may require a lot of memory.<br>Use the command line version when data volume is too high.</b><br></html> ");
        info.setIcon(IconLoader.getImageIcon("images/alert.png"));
        radioExport.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                comboFormats.setEnabled(true);
            } else if (e.getStateChange() == 2) {
                comboFormats.setEnabled(false);
            }
        });
        radioAddPanel.add((Component)radioAdd, "North");
        radioExportPanel.add((Component)radioExport, "North");
        radioExportPanel.add((Component)lFormat, "Center");
        radioExportPanel.add(comboFormats, "East");
        radioExportPanel.add((Component)info, "South");
        panel.add((Component)radioAddPanel, "Center");
        panel.add((Component)radioExportPanel, "South");
        int res = JOptionPane.showOptionDialog((Component)this.workspace, panel, "Materialization options", 2, 3, null, null, null);
        if (res == 0) {
            if (radioAdd.isSelected()) {
                this.materializeOnto(this.modelManager.getActiveOntology(), this.modelManager.getOWLOntologyManager());
            } else if (radioExport.isSelected()) {
                String outputFormat = (String)comboFormats.getSelectedItem();
                this.materializeToFile(outputFormat);
            }
        }
    }

    private void materializeToFile(String format) {
        String fileName = "";
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(fileName));
        fc.showSaveDialog((Component)this.workspace);
        try {
            File file = fc.getSelectedFile();
            if (file == null) {
                String msg = "Could not open output file";
                this.log.error(msg);
                JOptionPane.showMessageDialog((Component)this.workspace, msg);
            } else {
                MaterializationStats stats;
                OWLOntology ontology = this.modelManager.getActiveOntology();
                OntopSQLOWLAPIConfiguration configuration = this.obdaModelManager.getConfigurationManager().buildOntopSQLOWLAPIConfiguration(ontology);
                MaterializationParams params = MaterializationParams.defaultBuilder().build();
                long startTime = System.currentTimeMillis();
                switch (format) {
                    case "Turtle": 
                    case "RDF/XML": 
                    case "N-Triples": {
                        stats = this.exportWithRDF4J(configuration, params, format, file);
                        break;
                    }
                    default: {
                        throw new Exception("Unknown format: " + format);
                    }
                }
                long endTime = System.currentTimeMillis();
                JOptionPane.showMessageDialog((Component)this.workspace, "Task is completed" + this.lineSeparator + "Nr. of triples: " + stats.getCount() + this.lineSeparator + "Vocabulary size: " + stats.getVocabSize() + this.lineSeparator + "Elapsed time: " + (endTime - startTime) + " ms.", "Done", 1);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog((Component)this.workspace, "ERROR: could not materialize data instances.");
        }
    }

    /*
     * Exception decompiling
     */
    private MaterializationStats exportWithRDF4J(OntopSQLOWLAPIConfiguration configuration, MaterializationParams params, String format, File file) throws OBDASpecificationException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void materializeOnto(OWLOntology ontology, OWLOntologyManager ontoManager) {
        String message = "The plugin will generate several triples and save them in this current ontology." + this.lineSeparator + "The operation may take some time and may require a lot of memory if the data volume is too high." + this.lineSeparator + this.lineSeparator + "Do you want to continue?";
        int response = JOptionPane.showConfirmDialog((Component)this.workspace, message, "Confirmation", 0);
        if (response == 0) {
            try {
                OntopSQLOWLAPIConfiguration configuration = this.obdaModelManager.getConfigurationManager().buildOntopSQLOWLAPIConfiguration(ontology);
                MaterializationParams materializationParams = MaterializationParams.defaultBuilder().build();
                OntopOWLAPIMaterializer materializer = OntopOWLAPIMaterializer.defaultMaterializer((OntopSystemConfiguration)configuration, (MaterializationParams)materializationParams);
                MaterializedGraphOWLResultSet graphResultSet = materializer.materialize();
                Container container = this.workspace.getRootPane().getParent();
                final MaterializeAction action = new MaterializeAction(ontology, ontoManager, graphResultSet, container);
                Thread th = new Thread("MaterializeDataInstances Thread"){

                    @Override
                    public void run() {
                        try {
                            OBDAProgressMonitor monitor = new OBDAProgressMonitor("Materializing data instances...", (Component)AboxMaterializationAction.this.workspace);
                            CountDownLatch latch = new CountDownLatch(1);
                            action.setCountdownLatch(latch);
                            monitor.addProgressListener(action);
                            monitor.start();
                            action.run();
                            latch.await();
                            monitor.stop();
                        }
                        catch (InterruptedException e) {
                            AboxMaterializationAction.this.log.error(e.getMessage(), (Throwable)e);
                            JOptionPane.showMessageDialog((Component)AboxMaterializationAction.this.workspace, "ERROR: could not materialize data instances.");
                        }
                    }
                };
                th.start();
            }
            catch (Exception e) {
                Container container = this.getWorkspace().getRootPane().getParent();
                JOptionPane.showMessageDialog(container, "Cannot create individuals! See the log information for the details.", "Error", 0);
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class ABoxMaterializationActionException
    extends OntopInternalBugException {
        ABoxMaterializationActionException(String message) {
            super(message);
        }
    }

    private static class MaterializationStats {
        private final long count;
        private final int vocabSize;

        MaterializationStats(long count, int vocabSize) {
            this.count = count;
            this.vocabSize = vocabSize;
        }

        public long getCount() {
            return this.count;
        }

        int getVocabSize() {
            return this.vocabSize;
        }
    }
}

