/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.dialogs;

import it.unibz.inf.ontop.protege.utils.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class MappingValidationDialog
extends JDialog {
    private static final long serialVersionUID = -3099215805478663834L;
    private JDialog myself = null;
    private DefaultStyledDocument doc = null;
    private int index = 0;
    public Style VALID = null;
    public Style CRITICAL_ERROR = null;
    public Style NONCRITICAL_ERROR = null;
    public Style NORMAL = null;
    public boolean closed = false;

    public MappingValidationDialog(JTree tree) {
        DialogUtils.installEscapeCloseOperation(this);
        this.myself = this;
        this.doc = new DefaultStyledDocument();
        this.createStyles();
        this.createContent();
        this.setModal(true);
    }

    private void createStyles() {
        StyleContext context = new StyleContext();
        this.VALID = context.getStyle("default");
        StyleConstants.setFontFamily(this.VALID, "Arial");
        StyleConstants.setFontSize(this.VALID, 12);
        StyleConstants.setForeground(this.VALID, Color.GREEN.darker());
        StyleContext context1 = new StyleContext();
        this.CRITICAL_ERROR = context1.getStyle("default");
        StyleConstants.setFontFamily(this.CRITICAL_ERROR, "Arial");
        StyleConstants.setFontSize(this.CRITICAL_ERROR, 12);
        StyleConstants.setForeground(this.CRITICAL_ERROR, Color.RED);
        StyleContext context2 = new StyleContext();
        this.NONCRITICAL_ERROR = context2.getStyle("default");
        StyleConstants.setFontFamily(this.NONCRITICAL_ERROR, "Arial");
        StyleConstants.setFontSize(this.NONCRITICAL_ERROR, 12);
        StyleConstants.setForeground(this.NONCRITICAL_ERROR, Color.BLACK);
        StyleContext context3 = new StyleContext();
        this.NORMAL = context3.getStyle("default");
        StyleConstants.setFontFamily(this.NONCRITICAL_ERROR, "Arial");
        StyleConstants.setFontSize(this.NONCRITICAL_ERROR, 11);
        StyleConstants.setForeground(this.NONCRITICAL_ERROR, Color.BLACK);
    }

    private void createContent() {
        this.setTitle("Validate Mapping...");
        this.setSize(new Dimension(500, 360));
        Container panel = this.getContentPane();
        panel.setLayout(new BorderLayout());
        JTextPane area = new JTextPane();
        area.setBounds(0, 0, 298, 273);
        area.setEditable(false);
        area.setBackground(Color.WHITE);
        area.setDocument(this.doc);
        JScrollPane areaScrollPane = new JScrollPane(area);
        areaScrollPane.setHorizontalScrollBarPolicy(32);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setBounds(0, 0, 300, 275);
        JButton button = new JButton();
        button.setText("OK");
        button.setBounds(120, 290, 60, 25);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MappingValidationDialog.this.closed = true;
                MappingValidationDialog.this.myself.dispose();
            }
        });
        button.requestFocus();
        panel.add((Component)areaScrollPane, "Center");
        panel.add((Component)button, "South");
        this.setResizable(true);
    }

    public void addText(final String text, final Style style) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        MappingValidationDialog.this.doc.insertString(MappingValidationDialog.this.index, text, style);
                        MappingValidationDialog.this.index = MappingValidationDialog.this.index + text.length();
                        MappingValidationDialog.this.invalidate();
                        MappingValidationDialog.this.repaint();
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

