/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core.impl;

import it.unibz.inf.ontop.com.google.common.base.Preconditions;
import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDADataSourceFactory;
import it.unibz.inf.ontop.protege.core.impl.DataSourceImpl;
import java.net.URI;
import java.util.UUID;

public class OBDADataSourceFactoryImpl
implements OBDADataSourceFactory {
    private static OBDADataSourceFactory INSTANCE = null;

    private OBDADataSourceFactoryImpl() {
    }

    public static OBDADataSourceFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OBDADataSourceFactoryImpl();
        }
        return INSTANCE;
    }

    @Override
    public OBDADataSource getJDBCDataSource(String jdbcurl, String username, String password, String driverclass) {
        URI id = URI.create(UUID.randomUUID().toString());
        return this.getJDBCDataSource(id.toString(), jdbcurl, username, password, driverclass);
    }

    @Override
    public OBDADataSource getJDBCDataSource(String sourceuri, String jdbcurl, String username, String password, String driverclass) {
        Preconditions.checkNotNull((Object)sourceuri, (Object)"sourceuri is null");
        Preconditions.checkNotNull((Object)jdbcurl, (Object)"jdbcurl is null");
        Preconditions.checkNotNull((Object)password, (Object)"password is null");
        Preconditions.checkNotNull((Object)username, (Object)"username is null");
        Preconditions.checkNotNull((Object)driverclass, (Object)"driverclass is null");
        DataSourceImpl source = new DataSourceImpl(URI.create(sourceuri));
        source.setParameter("jdbc.url", jdbcurl);
        source.setParameter("jdbc.password", password);
        source.setParameter("jdbc.user", username);
        source.setParameter("jdbc.driver", driverclass);
        return source;
    }
}

