/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.jdbc.prefs;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.protege.osgi.jdbc.JdbcRegistry;
import org.protege.osgi.jdbc.prefs.Activator;
import org.protege.osgi.jdbc.prefs.DriverInfo;
import org.protege.osgi.jdbc.prefs.DriverTableModel;
import org.protege.osgi.jdbc.prefs.EditorPanel;

public class PreferencesPanel
extends OWLPreferencesPanel {
    private static final long serialVersionUID = 2892884854196959326L;
    public static final String PREFERENCES_SET = "org.protege.osgi.jdbc.prefs";
    public static final String DRIVER_PREFERENCES_KEY = "driver.list";
    public static final String DEFAULT_DRIVER_DIR = "driver.dir";
    private JTable table;
    private DriverTableModel driverTableModel;
    private ServiceTracker jdbcRegistryTracker;

    public void initialise() throws Exception {
        BundleContext context = Activator.getInstance().getContext();
        this.jdbcRegistryTracker = new ServiceTracker(context, JdbcRegistry.class.getName(), null);
        this.setPreferredSize(new Dimension(620, 300));
        this.setLayout(new GridBagLayout());
        GridBagConstraints listConstraints = new GridBagConstraints();
        listConstraints.fill = 1;
        listConstraints.gridx = 0;
        listConstraints.gridy = 0;
        listConstraints.gridwidth = 3;
        listConstraints.gridheight = 3;
        listConstraints.weightx = 1.0;
        listConstraints.weighty = 1.0;
        GridBagConstraints buttonsConstraints = new GridBagConstraints();
        buttonsConstraints.gridx = 0;
        buttonsConstraints.gridy = 4;
        this.add(this.createList(), listConstraints);
        this.add(this.createButtons(), buttonsConstraints);
    }

    public void applyChanges() {
        this.setDrivers(this.driverTableModel.getDrivers());
    }

    public void dispose() {
    }

    public static List<DriverInfo> getDrivers() {
        ArrayList<DriverInfo> drivers = new ArrayList<DriverInfo>();
        Preferences prefs = PreferencesManager.getInstance().getPreferencesForSet(PREFERENCES_SET, DRIVER_PREFERENCES_KEY);
        Iterator driverStrings = prefs.getStringList(DRIVER_PREFERENCES_KEY, new ArrayList()).iterator();
        while (driverStrings.hasNext()) {
            drivers.add(new DriverInfo((String)driverStrings.next(), (String)driverStrings.next(), new File((String)driverStrings.next())));
        }
        return drivers;
    }

    private void setDrivers(List<DriverInfo> drivers) {
        Preferences prefs = PreferencesManager.getInstance().getPreferencesForSet(PREFERENCES_SET, DRIVER_PREFERENCES_KEY);
        ArrayList<String> prefsStringList = new ArrayList<String>();
        for (DriverInfo driver : drivers) {
            prefsStringList.add(driver.getDescription());
            prefsStringList.add(driver.getClassName());
            prefsStringList.add(driver.getDriverLocation().getPath());
        }
        prefs.clear();
        prefs.putStringList(DRIVER_PREFERENCES_KEY, prefsStringList);
    }

    private JComponent createList() {
        this.driverTableModel = new DriverTableModel(PreferencesPanel.getDrivers(), this.jdbcRegistryTracker);
        this.table = new JTable(this.driverTableModel);
        return new JScrollPane(this.table);
    }

    private JComponent createButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton add = new JButton("Add");
        add.addActionListener(this::handleAdd);
        panel.add(add);
        JButton remove = new JButton("Remove");
        panel.add(remove);
        remove.addActionListener(this::handleRemove);
        JButton edit = new JButton("Edit");
        panel.add(edit);
        edit.addActionListener(this::handleEdit);
        return panel;
    }

    public void handleAdd(ActionEvent e) {
        EditorPanel editor = new EditorPanel(this.jdbcRegistryTracker);
        DriverInfo info = editor.askUserForDriverInfo();
        if (info != null) {
            this.driverTableModel.addDriver(info);
        }
    }

    public void handleRemove(ActionEvent e) {
        int[] rows = this.table.getSelectedRows();
        ArrayList<Integer> rowList = new ArrayList<Integer>();
        for (int row : rows) {
            rowList.add(row);
        }
        this.driverTableModel.removeDrivers(rowList);
    }

    public void handleEdit(ActionEvent e) {
        int row = this.table.getSelectedRow();
        DriverInfo existing = this.driverTableModel.getDrivers().get(row);
        EditorPanel editor = new EditorPanel(this.jdbcRegistryTracker, existing.getDescription(), existing.getClassName(), existing.getDriverLocation());
        DriverInfo info = editor.askUserForDriverInfo();
        this.driverTableModel.replaceDriver(row, info);
    }
}

