/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.jdbc.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.osgi.util.tracker.ServiceTracker;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.osgi.jdbc.prefs.DriverInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorPanel
extends JDialog {
    private static final long serialVersionUID = -8958695683502439830L;
    private final Logger log = LoggerFactory.getLogger(EditorPanel.class);
    private final ServiceTracker jdbcRegistryTracker;
    private JLabel status = new JLabel();
    private JTextField nameField;
    private JComboBox<String> classField;
    private JTextField fileField;
    private JButton fileButton;
    private DriverInfo info;
    private File defaultDir;
    private final Preferences prefs;

    public EditorPanel(ServiceTracker jdbcRegistryTracker) {
        this.jdbcRegistryTracker = jdbcRegistryTracker;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createStatus(), "North");
        this.getContentPane().add((Component)this.createCenterPane(), "Center");
        this.getContentPane().add((Component)this.createButtons(), "South");
        this.prefs = PreferencesManager.getInstance().getPreferencesForSet("org.protege.osgi.jdbc.prefs", "driver.dir");
        String dirName = this.prefs.getString("driver.dir", null);
        if (dirName != null) {
            this.defaultDir = new File(dirName);
            if (!this.defaultDir.exists()) {
                this.defaultDir = null;
            }
        }
    }

    public EditorPanel(ServiceTracker jdbcRegistryTracker, String description, String className, File file) {
        this(jdbcRegistryTracker);
        this.nameField.setText(description);
        this.classField.setSelectedItem(className);
        this.fileField.setText(file.getAbsolutePath());
    }

    private JComponent createStatus() {
        this.status = new JLabel();
        return this.status;
    }

    private JComponent createCenterPane() {
        JPanel centerPane = new JPanel();
        centerPane.setLayout(new GridLayout(0, 2));
        centerPane.add(new JLabel("Description:"));
        this.nameField = new JTextField();
        centerPane.add(this.nameField);
        centerPane.add(new JLabel("Class Name:"));
        this.classField = new JComboBox();
        this.classField.setEditable(true);
        this.classField.setModel(new DefaultComboBoxModel<String>(new String[]{"select or type the JDBC Driver's class...", "org.postgresql.Driver", "com.mysql.jdbc.Driver", "org.h2.Driver", "com.ibm.db2.jcc.DB2Driver", "oracle.jdbc.driver.OracleDriver", "com.microsoft.sqlserver.jdbc.SQLServerDriver"}));
        centerPane.add(this.classField);
        centerPane.add(new JLabel("Driver File (jar):"));
        this.fileField = new JTextField();
        JLabel sample = new JLabel("/home/tredmond/dev/workspaces/protege4");
        Dimension size = sample.getPreferredSize();
        this.fileField.setPreferredSize(size);
        centerPane.add(this.fileField);
        centerPane.add(new JLabel());
        this.fileButton = new JButton("Browse");
        centerPane.add(this.fileButton);
        this.fileButton.addActionListener(e -> {
            JFileChooser fc = new JFileChooser(this.defaultDir);
            int retVal = fc.showOpenDialog(this);
            if (retVal == 0) {
                File file = fc.getSelectedFile();
                this.defaultDir = file.getParentFile();
                this.prefs.putString("driver.dir", this.defaultDir.getAbsolutePath());
                this.fileField.setText(file.getPath());
            }
        });
        return centerPane;
    }

    private JComponent createButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton ok = new JButton("Ok");
        ok.addActionListener(e -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        panel.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(e -> {
            this.info = null;
            this.dispose();
        });
        panel.add(cancel);
        return panel;
    }

    public DriverInfo askUserForDriverInfo() {
        this.setModal(true);
        this.pack();
        this.setVisible(true);
        return this.info;
    }
}

