/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.jdbc.prefs;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.osgi.util.tracker.ServiceTracker;
import org.protege.osgi.jdbc.JdbcRegistry;
import org.protege.osgi.jdbc.prefs.DriverInfo;

public class DriverTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7588371899390500462L;
    private List<DriverInfo> drivers = new ArrayList<DriverInfo>();
    private Set<String> foundDrivers = new HashSet<String>();
    private ServiceTracker jdbcRegistryTracker;

    public DriverTableModel(List<DriverInfo> drivers, ServiceTracker jdbcRegistryTracker) {
        this.drivers = drivers;
        this.jdbcRegistryTracker = jdbcRegistryTracker;
        this.refresh();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public String getColumnName(int column) {
        Column col = Column.values()[column];
        return col.getName();
    }

    @Override
    public int getRowCount() {
        return this.drivers.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DriverInfo info = this.drivers.get(rowIndex);
        switch (Column.values()[columnIndex]) {
            case DESCRIPTION: {
                return info != null ? info.getDescription() : null;
            }
            case STATUS: {
                return this.foundDrivers.contains(info.getClassName()) ? "ready" : "down";
            }
        }
        throw new UnsupportedOperationException("Programmer error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.foundDrivers.clear();
        try {
            this.jdbcRegistryTracker.open();
            for (Object o : this.jdbcRegistryTracker.getServices()) {
                JdbcRegistry registry = (JdbcRegistry)o;
                for (Driver d : registry.getJdbcDrivers()) {
                    this.foundDrivers.add(d.getClass().getName());
                }
            }
        }
        finally {
            this.jdbcRegistryTracker.close();
        }
        this.fireTableStructureChanged();
    }

    public List<DriverInfo> getDrivers() {
        return this.drivers;
    }

    public void addDriver(DriverInfo driver) {
        DriverInfo toRemove = null;
        for (DriverInfo existingDriver : this.drivers) {
            if (!existingDriver.getClassName().equals(driver.getClassName())) continue;
            toRemove = existingDriver;
            break;
        }
        if (toRemove != null) {
            this.drivers.remove(toRemove);
        }
        this.drivers.add(driver);
        this.refresh();
    }

    public void removeDrivers(List<Integer> rows) {
        Collections.sort(rows);
        Collections.reverse(rows);
        for (Integer row : rows) {
            this.drivers.remove(row);
        }
        this.refresh();
    }

    public void replaceDriver(int row, DriverInfo newDriver) {
        this.drivers.remove(row);
        this.drivers.add(row, newDriver);
    }

    public static enum Column {
        DESCRIPTION("Description"),
        STATUS("Status");

        private String name;

        private Column(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

