/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.protege.osgi.jdbc.JdbcRegistry;

public class OSGiJdbcDriver
implements Driver {
    private int majorVersion;
    private int minorVersion;
    private JdbcRegistry registry;

    public OSGiJdbcDriver(BundleContext context, JdbcRegistry registry) {
        String versionString = (String)context.getBundle().getHeaders().get("Bundle-Version");
        Version version = new Version(versionString);
        this.majorVersion = version.getMajor();
        this.minorVersion = version.getMinor();
        this.registry = registry;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        for (Driver delegate : this.registry.getJdbcDrivers()) {
            if (!delegate.acceptsURL(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        for (Driver delegate : this.registry.getJdbcDrivers()) {
            if (!delegate.acceptsURL(url)) continue;
            return delegate.connect(url, info);
        }
        return null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        for (Driver delegate : this.registry.getJdbcDrivers()) {
            if (!delegate.acceptsURL(url)) continue;
            return delegate.getPropertyInfo(url, info);
        }
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return this.registry.getJdbcDrivers().stream().allMatch(Driver::jdbcCompliant);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }
}

