/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.utils;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.utils.ConnectionTools;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQuery;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualABoxStatistics {
    private final OBDAModel obdaModel;
    private HashMap<String, HashMap<String, Integer>> statistics = new HashMap();
    private Logger log = LoggerFactory.getLogger(VirtualABoxStatistics.class);

    public VirtualABoxStatistics(OBDAModel obdaModel) {
        this.obdaModel = obdaModel;
    }

    public HashMap<String, HashMap<String, Integer>> getStatistics() {
        return this.statistics;
    }

    public HashMap<String, Integer> getStatistics(String datasourceId) {
        return this.statistics.get(datasourceId);
    }

    public int getStatistics(String datasourceId, String mappingId) {
        HashMap<String, Integer> mappingStat = this.getStatistics(datasourceId);
        return mappingStat.get(mappingId);
    }

    public int getTotalTriples() throws Exception {
        int total = 0;
        for (HashMap<String, Integer> mappingStat : this.statistics.values()) {
            for (Integer triplesCount : mappingStat.values()) {
                int triples = triplesCount;
                if (triples == -1) {
                    throw new Exception("An error was occurred in the counting process.");
                }
                total += triples;
            }
        }
        return total;
    }

    public String toString() {
        String str = "";
        for (String datasourceId : this.statistics.keySet()) {
            str = str + "Data Source Name: " + datasourceId + "\n";
            str = str + "Mappings: \n";
            HashMap<String, Integer> mappingStat = this.statistics.get(datasourceId);
            for (String mappingId : mappingStat.keySet()) {
                int count = mappingStat.get(mappingId);
                str = str + String.format("- %s produces %s %s.\n", mappingId, count, count == 1 ? "triple" : "triples");
            }
            str = str + "\n";
        }
        return str;
    }

    public void refresh() {
        OBDADataSource source = this.obdaModel.getDatasource();
        ImmutableList mappingList = this.obdaModel.generatePPMapping().getTripleMaps();
        HashMap<String, Integer> mappingStat = new HashMap<String, Integer>();
        for (SQLPPTriplesMap mapping : mappingList) {
            String mappingId = mapping.getId();
            int triplesCount = 0;
            try {
                SQLPPSourceQuery sourceQuery = mapping.getSourceQuery();
                int tuples = this.getTuplesCount(sourceQuery, source);
                ImmutableList targetQuery = mapping.getTargetAtoms();
                int atoms = targetQuery.size();
                triplesCount = tuples * atoms;
            }
            catch (Exception e) {
                triplesCount = -1;
                this.log.error("Exception while computing mapping statistics", (Throwable)e);
            }
            mappingStat.put(mappingId, triplesCount);
        }
        this.statistics.put(source.getSourceID().toString(), mappingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTuplesCount(SQLPPSourceQuery query, OBDADataSource source) throws Exception {
        Statement st = null;
        ResultSet rs = null;
        int count = -1;
        try {
            String sql = String.format("select COUNT(*) %s", this.getSelectionString(query));
            Connection c = ConnectionTools.getConnection(source);
            st = c.createStatement();
            rs = st.executeQuery(sql);
            count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                st.close();
            }
            catch (Exception exception) {}
        }
        return count;
    }

    private String getSelectionString(SQLPPSourceQuery query) throws Exception {
        String originalSql = query.toString();
        String sql = originalSql.toLowerCase();
        Matcher m = Pattern.compile("[\\n\\s\\t]*from[\\n\\s\\t]*").matcher(sql);
        if (m.find()) {
            int start = m.start();
            int end = sql.length();
            return originalSql.substring(start, end);
        }
        throw new Exception("Could not find the \"from\" keyword in the source query\n" + query);
    }
}

