/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.utils;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.ImmutableMetadata;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.JDBCMetadataProviderFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.protege.core.DuplicateMappingException;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.utils.JDBCConnectionManager;
import it.unibz.inf.ontop.spec.mapping.bootstrap.impl.DirectMappingEngine;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.util.MappingOntologyUtils;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class BootstrapGenerator {
    private final JDBCConnectionManager connManager = JDBCConnectionManager.getJDBCConnectionManager();
    private final OntopSQLOWLAPIConfiguration configuration;
    private final OBDAModel activeOBDAModel;
    private final OWLModelManager owlManager;
    private final TypeFactory typeFactory;
    private final DirectMappingEngine directMappingEngine;
    private final JDBCMetadataProviderFactory metadataProviderFactory;

    public BootstrapGenerator(OBDAModelManager obdaModelManager, String baseUri, OWLModelManager owlManager) throws DuplicateMappingException, MetadataExtractionException {
        this.owlManager = owlManager;
        this.configuration = obdaModelManager.getConfigurationManager().buildOntopSQLOWLAPIConfiguration(owlManager.getActiveOntology());
        this.activeOBDAModel = obdaModelManager.getActiveOBDAModel();
        this.typeFactory = obdaModelManager.getTypeFactory();
        Injector injector = this.configuration.getInjector();
        this.directMappingEngine = (DirectMappingEngine)injector.getInstance(DirectMappingEngine.class);
        this.metadataProviderFactory = (JDBCMetadataProviderFactory)injector.getInstance(JDBCMetadataProviderFactory.class);
        this.bootstrapMappingAndOntologyProtege(baseUri);
    }

    private void bootstrapMappingAndOntologyProtege(String baseUri) throws DuplicateMappingException, MetadataExtractionException {
        List<SQLPPTriplesMap> sqlppTriplesMaps = this.bootstrapMapping(this.activeOBDAModel.generatePPMapping(), baseUri);
        OWLOntologyManager manager = this.owlManager.getActiveOntology().getOWLOntologyManager();
        Set declarationAxioms = MappingOntologyUtils.extractDeclarationAxioms((OWLOntologyManager)manager, sqlppTriplesMaps.stream().flatMap(ax -> ax.getTargetAtoms().stream()), (TypeFactory)this.typeFactory, (boolean)true);
        List addAxioms = declarationAxioms.stream().map(ax -> new AddAxiom(this.owlManager.getActiveOntology(), (OWLAxiom)ax)).collect(Collectors.toList());
        this.owlManager.applyChanges(addAxioms);
    }

    private List<SQLPPTriplesMap> bootstrapMapping(SQLPPMapping ppMapping, String baseURI0) throws DuplicateMappingException, MetadataExtractionException {
        Connection conn;
        try {
            conn = this.connManager.getConnection((OntopSQLCredentialSettings)this.configuration.getSettings());
        }
        catch (SQLException e) {
            throw new RuntimeException("JDBC connection is missing, have you setup Ontop Mapping properties? Message: " + e.getMessage());
        }
        String baseURI = baseURI0 == null || baseURI0.isEmpty() ? ppMapping.getPrefixManager().getDefaultPrefix() : DirectMappingEngine.fixBaseURI((String)baseURI0);
        DBMetadataProvider metadataProvider = this.metadataProviderFactory.getMetadataProvider(conn);
        ImmutableList relations = ImmutableMetadata.extractImmutableMetadata((MetadataProvider)metadataProvider).getAllRelations();
        HashMap bnodeTemplateMap = new HashMap();
        AtomicInteger currentMappingIndex = new AtomicInteger(ppMapping.getTripleMaps().size() + 1);
        ImmutableList newTriplesMap = (ImmutableList)relations.stream().flatMap(td -> this.directMappingEngine.getMapping(td, baseURI, bnodeTemplateMap, currentMappingIndex).stream()).collect(ImmutableCollectors.toList());
        for (SQLPPTriplesMap triplesMap : newTriplesMap) {
            this.activeOBDAModel.addTriplesMap(triplesMap, true);
        }
        return newTriplesMap;
    }
}

