/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.views;

import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.core.OBDAModelManagerListener;
import it.unibz.inf.ontop.protege.panels.MappingManagerPanel;
import it.unibz.inf.ontop.spec.mapping.pp.impl.SQLPPMappingImpl;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.border.TitledBorder;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.protege.editor.owl.ui.view.Findable;
import org.semanticweb.owlapi.model.OWLEntity;

public class MappingsManagerView
extends AbstractOWLViewComponent
implements OBDAModelManagerListener,
Findable<OWLEntity> {
    private static final long serialVersionUID = 1790921396564256165L;
    OBDAModelManager controller = null;
    OBDAModel obdaModel;
    MappingManagerPanel mappingPanel = null;

    protected void disposeOWLView() {
        this.controller.removeListener(this);
    }

    protected void initialiseOWLView() throws Exception {
        final OWLEditorKit editor = this.getOWLEditorKit();
        this.controller = (OBDAModelManager)editor.get((Object)SQLPPMappingImpl.class.getName());
        this.controller.addListener(this);
        this.obdaModel = this.controller.getActiveOBDAModel();
        this.mappingPanel = new MappingManagerPanel(this.obdaModel);
        editor.getOWLWorkspace().getOWLSelectionModel().addListener(new OWLSelectionModelListener(){

            public void selectionChanged() throws Exception {
                OWLEntity entity = editor.getOWLWorkspace().getOWLSelectionModel().getSelectedEntity();
                if (entity == null) {
                    return;
                }
                if (!entity.isTopEntity()) {
                    String shortf = entity.getIRI().getFragment();
                    if (shortf == null) {
                        String iri = entity.getIRI().toString();
                        shortf = iri.substring(iri.lastIndexOf("/"));
                    }
                    MappingsManagerView.this.mappingPanel.setFilter(shortf);
                } else {
                    MappingsManagerView.this.mappingPanel.setFilter("");
                }
            }
        });
        if (this.obdaModel.getSources().size() > 0) {
            this.mappingPanel.datasourceChanged(this.mappingPanel.getSelectedSource(), (OBDADataSource)this.obdaModel.getSources().get(0));
        }
        this.mappingPanel.setBorder(new TitledBorder("Mapping manager"));
        this.setLayout(new BorderLayout());
        this.add(this.mappingPanel, "Center");
    }

    @Override
    public void activeOntologyChanged() {
        this.obdaModel = this.controller.getActiveOBDAModel();
        this.mappingPanel.datasourceChanged(this.mappingPanel.getSelectedSource(), (OBDADataSource)this.obdaModel.getSources().get(0));
    }

    public List<OWLEntity> find(String match) {
        return null;
    }

    public void show(OWLEntity owlEntity) {
    }
}

