/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.protege.core.MutableOntologyVocabulary;
import it.unibz.inf.ontop.protege.core.MutablePrefixManager;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.TargetQueryValidator;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.parser.TargetQueryParser;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.rdf.api.IRI;

public class QueryPainter {
    private final OBDAModel apic;
    private SimpleAttributeSet black;
    private SimpleAttributeSet brackets;
    private SimpleAttributeSet dataProp;
    private SimpleAttributeSet objectProp;
    private SimpleAttributeSet annotProp;
    private SimpleAttributeSet clazz;
    private SimpleAttributeSet individual;
    private Style invalidQuery;
    private Border defaultBorder;
    private Border outerBorder;
    private Border stateBorder;
    private Border errorBorder;
    private Timer timer;
    private TargetQueryParserException parsingException;
    private boolean invalid = false;
    private static final Color INVALID = Color.RED;
    private static final int DEFAULT_TOOL_TIP_INITIAL_DELAY = ToolTipManager.sharedInstance().getInitialDelay();
    private static final int DEFAULT_TOOL_TIP_DISMISS_DELAY = ToolTipManager.sharedInstance().getDismissDelay();
    private static final int ERROR_TOOL_TIP_INITIAL_DELAY = 100;
    private static final int ERROR_TOOL_TIP_DISMISS_DELAY = 9000;
    private Font plainFont;
    private Style plainStyle;
    private Style boldStyle;
    private Style nonBoldStyle;
    private Style foreground;
    private Style fontSizeStyle;
    private StyledDocument doc = null;
    private JTextPane parent = null;
    private Vector<ColorTask> tasks = new Vector();
    private List<ValidatorListener> validatorListeners = new LinkedList<ValidatorListener>();

    public QueryPainter(OBDAModel apic, JTextPane parent) {
        this.apic = apic;
        this.parent = parent;
        this.doc = parent.getStyledDocument();
        this.parent = parent;
        this.prepareStyles();
        this.prepareTextPane();
        this.prepareTimer();
        this.prepareBorder();
    }

    private void prepareBorder() {
        this.outerBorder = null;
        this.defaultBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY);
        this.errorBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.RED);
        this.setStateBorder(this.defaultBorder);
    }

    private void prepareTimer() {
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryPainter.this.handleTimer();
            }
        });
    }

    public void addValidatorListener(ValidatorListener listener) {
        this.validatorListeners.add(listener);
    }

    public void removeValidatorListener(ValidatorListener listener) {
        this.validatorListeners.remove(listener);
    }

    private void fireValidationOccurred() {
        for (ValidatorListener listener : this.validatorListeners) {
            listener.validated(!this.invalid);
        }
    }

    private void handleDocumentUpdated() {
        this.timer.restart();
        this.clearError();
    }

    private void handleTimer() {
        this.timer.stop();
        this.checkExpression();
        if (!this.invalid) {
            try {
                this.recolorQuery();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void validate() throws Exception {
        String text = this.parent.getText().trim();
        if (text.isEmpty() || text.length() == 1) {
            String msg = String.format("Empty query", new Object[0]);
            this.invalid = true;
            throw new Exception(msg);
        }
        TargetQueryParser textParser = this.apic.createTargetQueryParser();
        ImmutableList query = textParser.parse(text);
        if (query == null) {
            this.invalid = true;
            throw this.parsingException;
        }
        ImmutableList<IRI> invalidPredicates = TargetQueryValidator.validate((ImmutableList<TargetAtom>)query, this.apic.getCurrentVocabulary());
        if (!invalidPredicates.isEmpty()) {
            String invalidList = "";
            for (IRI predicateIri : invalidPredicates) {
                invalidList = invalidList + "- " + predicateIri + "\n";
            }
            String msg = String.format("ERROR: The below list of predicates is unknown by the ontology: \n %s Note: null indicates an unknown prefix.", invalidList);
            this.invalid = true;
            throw new Exception(msg);
        }
        this.invalid = false;
    }

    protected void checkExpression() {
        try {
            this.validate();
            this.invalid = false;
            this.setError(null);
        }
        catch (Exception e) {
            this.invalid = true;
            this.setError(e);
        }
        finally {
            this.fireValidationOccurred();
        }
    }

    private void setError(Exception e) {
        if (e != null) {
            ToolTipManager.sharedInstance().setInitialDelay(100);
            ToolTipManager.sharedInstance().setDismissDelay(9000);
            if (e instanceof IllegalArgumentException) {
                this.parent.setToolTipText("Syntax error");
            } else {
                Throwable cause = e.getCause();
                String errorstring = cause != null ? cause.getMessage() : e.getMessage();
                if (errorstring != null) {
                    this.parent.setToolTipText(QueryPainter.getHTMLErrorMessage(errorstring));
                } else {
                    this.parent.setToolTipText("Syntax error, check log");
                }
            }
            this.setStateBorder(this.errorBorder);
        } else {
            this.clearError();
        }
    }

    private static String getHTMLErrorMessage(String msg) {
        if (msg != null) {
            String html = "<html><body>";
            msg = msg.replace("\n", "<br>");
            msg = msg.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            html = html + msg;
            html = html + "</body></html>";
            return html;
        }
        return null;
    }

    private void clearError() {
        this.parent.setToolTipText(null);
        this.setStateBorder(this.defaultBorder);
        ToolTipManager.sharedInstance().setInitialDelay(DEFAULT_TOOL_TIP_INITIAL_DELAY);
        ToolTipManager.sharedInstance().setDismissDelay(DEFAULT_TOOL_TIP_DISMISS_DELAY);
    }

    public void setStateBorder(Border border) {
        this.stateBorder = border;
        this.parent.setBorder(BorderFactory.createCompoundBorder(this.outerBorder, this.stateBorder));
    }

    private void prepareStyles() {
        StyledDocument doc = this.parent.getStyledDocument();
        this.plainStyle = doc.addStyle("PLAIN_STYLE", null);
        StyleConstants.setItalic(this.plainStyle, false);
        this.boldStyle = doc.addStyle("BOLD_STYLE", null);
        StyleConstants.setBold(this.boldStyle, true);
        this.nonBoldStyle = doc.addStyle("NON_BOLD_STYLE", null);
        StyleConstants.setBold(this.nonBoldStyle, false);
        this.fontSizeStyle = doc.addStyle("FONT_SIZE", null);
        StyleConstants.setFontSize(this.fontSizeStyle, 40);
        this.invalidQuery = doc.addStyle("INVALID_STYLE", null);
        StyleConstants.setForeground(this.invalidQuery, INVALID);
        this.foreground = doc.addStyle("FOREGROUND", null);
        StyleConstants.setForeground(this.foreground, Color.black);
        this.black = new SimpleAttributeSet();
        this.black.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.black);
        this.brackets = new SimpleAttributeSet();
        this.brackets.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.BLACK);
        this.annotProp = new SimpleAttributeSet();
        Color c_dp = new Color(109, 159, 162);
        this.annotProp.addAttribute(StyleConstants.CharacterConstants.Foreground, c_dp);
        this.annotProp.addAttribute(StyleConstants.CharacterConstants.Bold, true);
        this.dataProp = new SimpleAttributeSet();
        Color c_ap = new Color(41, 167, 121);
        this.dataProp.addAttribute(StyleConstants.CharacterConstants.Foreground, c_ap);
        this.dataProp.addAttribute(StyleConstants.CharacterConstants.Bold, true);
        this.objectProp = new SimpleAttributeSet();
        Color c_op = new Color(41, 119, 167);
        this.objectProp.addAttribute(StyleConstants.CharacterConstants.Foreground, c_op);
        this.objectProp.addAttribute(StyleConstants.CharacterConstants.Bold, true);
        this.clazz = new SimpleAttributeSet();
        Color c_clazz = new Color(199, 155, 41);
        this.clazz.addAttribute(StyleConstants.CharacterConstants.Foreground, c_clazz);
        this.clazz.addAttribute(StyleConstants.CharacterConstants.Bold, true);
        this.individual = new SimpleAttributeSet();
        Color c_individual = new Color(83, 24, 82);
        this.individual.addAttribute(StyleConstants.CharacterConstants.Foreground, c_individual);
        this.individual.addAttribute(StyleConstants.CharacterConstants.Bold, true);
    }

    private void resetStyles() {
        this.setupFont();
        StyleConstants.setFontSize(this.fontSizeStyle, this.getFontSize());
        StyleConstants.setFontFamily(this.fontSizeStyle, this.plainFont.getFamily());
        StyleConstants.setForeground(this.fontSizeStyle, Color.black);
        this.fontSizeStyle.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.black);
        this.doc.setParagraphAttributes(0, this.doc.getLength(), this.fontSizeStyle, true);
    }

    private void prepareTextPane() {
        this.resetStyles();
        this.parent.setBorder(null);
        this.parent.getStyledDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                QueryPainter.this.handleDocumentUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                QueryPainter.this.handleDocumentUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void setupFont() {
        this.plainFont = new Font("Lucida Grande", 0, 14);
        this.parent.setFont(this.plainFont);
    }

    private int getFontSize() {
        return 14;
    }

    public void recolorQuery() throws Exception {
        ColorTask[] taskArray;
        MutablePrefixManager man = this.apic.getMutablePrefixManager();
        String input = this.doc.getText(0, this.doc.getLength());
        ImmutableList<TargetAtom> current_query = this.parse(input, (PrefixManager)man);
        if (current_query == null) {
            JOptionPane.showMessageDialog(null, "An error occured while parsing the mappings. For more info, see the logs.");
            throw new Exception("Unable to parse the query: " + input + ", " + (Object)((Object)this.parsingException));
        }
        input = this.doc.getText(0, this.doc.getLength());
        this.resetStyles();
        int pos = input.indexOf("(", 0);
        while (pos != -1) {
            this.doc.setCharacterAttributes(pos, 1, this.brackets, false);
            pos = input.indexOf("(", pos + 1);
        }
        pos = input.indexOf(")", 0);
        while (pos != -1) {
            this.doc.setCharacterAttributes(pos, 1, this.brackets, false);
            pos = input.indexOf(")", pos + 1);
        }
        pos = input.indexOf(".", 0);
        while (pos != -1) {
            this.doc.setCharacterAttributes(pos, 1, this.black, false);
            pos = input.indexOf(".", pos + 1);
        }
        pos = input.indexOf(",", 0);
        while (pos != -1) {
            this.doc.setCharacterAttributes(pos, 1, this.black, false);
            pos = input.indexOf(",", pos + 1);
        }
        pos = input.indexOf(":", 0);
        while (pos != -1) {
            this.doc.setCharacterAttributes(pos, 1, this.black, false);
            pos = input.indexOf(":", pos + 1);
        }
        MutableOntologyVocabulary vocabulary = this.apic.getCurrentVocabulary();
        for (TargetAtom atom : current_query) {
            ColorTask task;
            String rendered;
            Optional optionalPredicateIri = atom.getPredicateIRI();
            if (optionalPredicateIri.isPresent()) {
                ColorTask task2;
                IRI predicateIri = (IRI)optionalPredicateIri.get();
                String shortIRIForm = man.getShortForm("<" + predicateIri.getIRIString() + ">");
                if (vocabulary.classes().contains(predicateIri)) {
                    task2 = new ColorTask(shortIRIForm, this.clazz);
                    this.tasks.add(task2);
                } else if (vocabulary.objectProperties().contains(predicateIri)) {
                    task2 = new ColorTask(shortIRIForm, this.objectProp);
                    this.tasks.add(task2);
                } else if (vocabulary.dataProperties().contains(predicateIri)) {
                    task2 = new ColorTask(shortIRIForm, this.dataProp);
                    this.tasks.add(task2);
                } else if (vocabulary.annotationProperties().contains(predicateIri)) {
                    task2 = new ColorTask(shortIRIForm, this.annotProp);
                    this.tasks.add(task2);
                }
            }
            ImmutableList substitutedTerms = atom.getSubstitutedTerms();
            RDFAtomPredicate atomPredicate = (RDFAtomPredicate)atom.getProjectionAtom().getPredicate();
            ImmutableTerm term1 = atomPredicate.getSubject(substitutedTerms);
            ImmutableTerm term2 = atomPredicate.getObject(substitutedTerms);
            if (term1 instanceof IRIConstant) {
                rendered = man.getShortForm(((IRIConstant)term1).getIRI().toString());
                task = new ColorTask(rendered, this.individual);
                this.tasks.add(task);
            }
            if (!(term2 instanceof IRIConstant)) continue;
            rendered = man.getShortForm(((IRIConstant)term2).getIRI().toString());
            task = new ColorTask(rendered, this.individual);
            this.tasks.add(task);
        }
        for (ColorTask ct : taskArray = this.order(this.tasks)) {
            if (ct.text == null) continue;
            Matcher matcher = Pattern.compile("\\s(" + ct.text + ")[\\s\\.;,]").matcher(input);
            while (matcher.find()) {
                this.doc.setCharacterAttributes(matcher.start(1), ct.text.length(), ct.set, true);
            }
        }
        this.tasks.clear();
    }

    private ImmutableList<TargetAtom> parse(String query, PrefixManager man) {
        try {
            TargetQueryParser textParser = this.apic.createTargetQueryParser((ImmutableMap<String, String>)man.getPrefixMap());
            return textParser.parse(query);
        }
        catch (TargetQueryParserException e) {
            this.parsingException = e;
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ColorTask[] order(Vector<ColorTask> v) {
        ColorTask[] s = new ColorTask[v.size()];
        ColorTask[] result = v.toArray(s);
        for (int i = 1; i < result.length; ++i) {
            ColorTask str = result[i];
            int B = result[i].text.length();
            for (int j = i; j > 0 && result[j - 1].text != null && result[j - 1].text.length() > B; --j) {
                result[j] = result[j - 1];
            }
            result[j] = str;
        }
        return result;
    }

    public boolean isValidQuery() {
        return !this.invalid;
    }

    class ColorTask {
        public String text = null;
        public SimpleAttributeSet set = null;

        public ColorTask(String s, SimpleAttributeSet sas) {
            this.text = s;
            this.set = sas;
        }
    }

    public static interface ValidatorListener {
        public void validated(boolean var1);
    }
}

