/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import it.unibz.inf.ontop.protege.utils.ProgressPanel;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class OBDAProgressMonitor {
    private JDialog parent = new JDialog();
    private boolean bCancel = false;
    private boolean bFinish = false;
    private String msg = null;
    private final Component workspace;
    private Vector<OBDAProgressListener> listeners = new Vector();

    public OBDAProgressMonitor(String msg, Component workspace) {
        this.msg = msg;
        this.workspace = workspace;
    }

    public void start() {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                if (OBDAProgressMonitor.this.bFinish) {
                    return;
                }
                ProgressPanel panel = new ProgressPanel(OBDAProgressMonitor.this, OBDAProgressMonitor.this.msg);
                OBDAProgressMonitor.this.parent.setModal(true);
                OBDAProgressMonitor.this.parent.setContentPane(panel);
                OBDAProgressMonitor.this.parent.setDefaultCloseOperation(0);
                OBDAProgressMonitor.this.parent.setSize(280, 140);
                OBDAProgressMonitor.this.parent.setLocationRelativeTo(OBDAProgressMonitor.this.workspace);
                OBDAProgressMonitor.this.parent.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(action);
    }

    public void stop() {
        this.bFinish = true;
        this.bCancel = false;
        SwingUtilities.invokeLater(new Closer());
    }

    public void cancel() throws Exception {
        this.bFinish = false;
        this.bCancel = true;
        SwingUtilities.invokeLater(new Closer());
        for (OBDAProgressListener pl : this.listeners) {
            pl.actionCanceled();
        }
    }

    public void addProgressListener(OBDAProgressListener list) {
        this.listeners.add(list);
    }

    public void removeProgressListener(OBDAProgressListener list) {
        this.listeners.remove(list);
    }

    public boolean isFinished() {
        return this.bFinish;
    }

    public boolean isCanceled() {
        return this.bCancel;
    }

    private class Closer
    implements Runnable {
        private Closer() {
        }

        @Override
        public void run() {
            OBDAProgressMonitor.this.parent.setVisible(false);
            OBDAProgressMonitor.this.parent.dispose();
        }
    }
}

