/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConnectionManager {
    public static final String JDBC_AUTOCOMMIT = "autocommit";
    public static final String JDBC_FETCHSIZE = "fetchsize";
    public static final String JDBC_RESULTSETTYPE = "resultsettype";
    public static final String JDBC_RESULTSETCONCUR = "resultsetconcur";
    private static JDBCConnectionManager instance = null;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Connection connection = null;
    private static Logger log = LoggerFactory.getLogger(JDBCConnectionManager.class);

    private JDBCConnectionManager() {
        this.properties.put(JDBC_AUTOCOMMIT, false);
        this.properties.put(JDBC_FETCHSIZE, 100);
        this.properties.put(JDBC_RESULTSETCONCUR, 1007);
        this.properties.put(JDBC_RESULTSETTYPE, 1003);
    }

    public static JDBCConnectionManager getJDBCConnectionManager() {
        if (instance == null) {
            instance = new JDBCConnectionManager();
        }
        return instance;
    }

    public Connection createConnection(OntopSQLCredentialSettings settings) throws SQLException {
        return this.createConnection(settings.getJdbcUrl(), settings.getJdbcUser(), settings.getJdbcPassword());
    }

    public Connection createConnection(String url, String username, String password) throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return this.connection;
        }
        this.connection = DriverManager.getConnection(url, username, password);
        return this.connection;
    }

    public Connection getConnection(String url, String username, String password) throws SQLException {
        boolean alive = this.isConnectionAlive();
        if (!alive) {
            this.createConnection(url, username, password);
        }
        return this.connection;
    }

    public void closeConnection() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public boolean isConnectionAlive() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            return false;
        }
        return !this.connection.isClosed();
    }

    public void dispose() throws SQLException {
        try {
            this.closeConnection();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public Connection getConnection(OntopSQLCredentialSettings settings) throws SQLException {
        return this.getConnection(settings.getJdbcUrl(), settings.getJdbcUser(), settings.getJdbcPassword());
    }
}

