/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.gui.treemodels.QueryControllerTreeModel;
import it.unibz.inf.ontop.protege.gui.treemodels.QueryGroupTreeElement;
import it.unibz.inf.ontop.protege.gui.treemodels.QueryTreeElement;
import it.unibz.inf.ontop.protege.gui.treemodels.TreeElement;
import it.unibz.inf.ontop.protege.panels.SaveQueryPanel;
import it.unibz.inf.ontop.protege.panels.SavedQueriesPanelListener;
import it.unibz.inf.ontop.protege.panels.SavedQueriesTreeCellRenderer;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.utils.querymanager.QueryController;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerEntity;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerGroup;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerListener;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerQuery;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SavedQueriesPanel
extends JPanel
implements QueryControllerListener {
    private static final long serialVersionUID = 6920100822784727963L;
    private Vector<SavedQueriesPanelListener> listeners = new Vector();
    private QueryControllerTreeModel queryControllerModel = new QueryControllerTreeModel();
    private QueryController queryController;
    private QueryTreeElement currentId;
    private QueryTreeElement previousId;
    private JButton cmdAdd;
    private JButton cmdRemove;
    private JLabel lblSavedQuery;
    private JPanel pnlCommandPanel;
    private JPanel pnlSavedQuery;
    private JScrollPane scrSavedQuery;
    private JTree treSavedQuery;

    public SavedQueriesPanel(QueryController queryController) {
        this.initComponents();
        this.queryController = queryController;
        this.queryController.addListener((QueryControllerListener)this.queryControllerModel);
        this.queryController.addListener((QueryControllerListener)this);
        this.queryControllerModel.synchronize(queryController.getElements());
        this.queryControllerModel.reload();
    }

    public void changeQueryController(QueryController newQueryController) {
        this.queryControllerModel.reset();
        this.queryControllerModel.synchronize(this.queryController.getElements());
        this.queryControllerModel.reload();
        if (this.queryController != null) {
            this.queryController.removeAllListeners();
        }
        this.queryController = newQueryController;
        this.queryController.addListener((QueryControllerListener)this.queryControllerModel);
        this.queryController.addListener((QueryControllerListener)this);
    }

    public void addQueryManagerListener(SavedQueriesPanelListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeQueryManagerListener(SavedQueriesPanelListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void initComponents() {
        this.pnlSavedQuery = new JPanel();
        this.scrSavedQuery = new JScrollPane();
        this.treSavedQuery = new JTree();
        this.pnlCommandPanel = new JPanel();
        this.lblSavedQuery = new JLabel();
        this.cmdRemove = new JButton();
        this.cmdAdd = new JButton();
        this.setLayout(new BorderLayout());
        this.pnlSavedQuery.setMinimumSize(new Dimension(200, 50));
        this.pnlSavedQuery.setLayout(new BorderLayout());
        this.scrSavedQuery.setMinimumSize(new Dimension(400, 200));
        this.scrSavedQuery.setOpaque(false);
        this.scrSavedQuery.setPreferredSize(new Dimension(300, 200));
        this.treSavedQuery.setBorder(BorderFactory.createEtchedBorder());
        this.treSavedQuery.setForeground(new Color(51, 51, 51));
        this.treSavedQuery.setModel(this.queryControllerModel);
        this.treSavedQuery.setCellRenderer(new SavedQueriesTreeCellRenderer());
        this.treSavedQuery.setMaximumSize(new Dimension(5000, 5000));
        this.treSavedQuery.setRootVisible(false);
        this.treSavedQuery.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SavedQueriesPanel.this.reselectQueryNode(evt);
            }
        });
        this.treSavedQuery.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                SavedQueriesPanel.this.selectQueryNode(evt);
            }
        });
        this.scrSavedQuery.setViewportView(this.treSavedQuery);
        this.pnlSavedQuery.add((Component)this.scrSavedQuery, "Center");
        this.pnlCommandPanel.setLayout(new GridBagLayout());
        this.lblSavedQuery.setFont(new Font("Arial", 1, 11));
        this.lblSavedQuery.setForeground(new Color(153, 153, 153));
        this.lblSavedQuery.setText("Stored Query:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.5;
        this.pnlCommandPanel.add((Component)this.lblSavedQuery, gridBagConstraints);
        this.cmdRemove.setIcon(IconLoader.getImageIcon("images/minus.png"));
        this.cmdRemove.setText("Remove");
        this.cmdRemove.setToolTipText("Remove the selected query");
        this.cmdRemove.setBorder(BorderFactory.createEtchedBorder());
        this.cmdRemove.setContentAreaFilled(false);
        this.cmdRemove.setIconTextGap(5);
        this.cmdRemove.setMaximumSize(new Dimension(25, 25));
        this.cmdRemove.setMinimumSize(new Dimension(25, 25));
        this.cmdRemove.setPreferredSize(new Dimension(80, 25));
        this.cmdRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavedQueriesPanel.this.cmdRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.pnlCommandPanel.add((Component)this.cmdRemove, gridBagConstraints);
        this.cmdAdd.setIcon(IconLoader.getImageIcon("images/plus.png"));
        this.cmdAdd.setText("Add");
        this.cmdAdd.setToolTipText("Add a new query");
        this.cmdAdd.setBorder(BorderFactory.createEtchedBorder());
        this.cmdAdd.setContentAreaFilled(false);
        this.cmdAdd.setIconTextGap(4);
        this.cmdAdd.setMaximumSize(new Dimension(25, 25));
        this.cmdAdd.setMinimumSize(new Dimension(25, 25));
        this.cmdAdd.setPreferredSize(new Dimension(63, 25));
        this.cmdAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavedQueriesPanel.this.cmdAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.pnlCommandPanel.add((Component)this.cmdAdd, gridBagConstraints);
        this.pnlSavedQuery.add((Component)this.pnlCommandPanel, "North");
        this.add((Component)this.pnlSavedQuery, "Center");
    }

    private void selectQueryNode(TreeSelectionEvent evt) {
        String currentQuery = "";
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
        if (node instanceof QueryTreeElement) {
            QueryTreeElement queryElement = (QueryTreeElement)node;
            currentQuery = queryElement.getQuery();
            this.currentId = queryElement;
            TreeNode parent = queryElement.getParent();
            if (parent == null || parent.toString().equals("")) {
                this.fireQueryChanged("", currentQuery, this.currentId.getID());
            } else {
                this.fireQueryChanged(parent.toString(), currentQuery, this.currentId.getID());
            }
        } else if (node instanceof QueryGroupTreeElement) {
            QueryGroupTreeElement groupElement = (QueryGroupTreeElement)node;
            this.currentId = null;
            currentQuery = null;
            this.fireQueryChanged(groupElement.toString(), "", "");
        } else if (node == null) {
            this.currentId = null;
            currentQuery = null;
        }
    }

    private void reselectQueryNode(MouseEvent evt) {
        if (this.currentId == null) {
            return;
        }
        if (this.previousId == this.currentId) {
            this.fireQueryChanged(this.currentId.getParent().toString(), this.currentId.getQuery(), this.currentId.getID());
        } else {
            this.previousId = this.currentId;
        }
    }

    private void cmdAddActionPerformed(ActionEvent evt) {
        JDialog saveDialog = new JDialog();
        saveDialog.setTitle("New Query");
        saveDialog.setModalityType(Dialog.ModalityType.MODELESS);
        SaveQueryPanel savePanel = new SaveQueryPanel("", saveDialog, this.queryController);
        saveDialog.getContentPane().add((Component)savePanel, "Center");
        saveDialog.pack();
        DialogUtils.centerDialogWRTParent(this, saveDialog);
        DialogUtils.installEscapeCloseOperation(saveDialog);
        saveDialog.setVisible(true);
    }

    private void cmdRemoveActionPerformed(ActionEvent evt) {
        TreePath selected_path = this.treSavedQuery.getSelectionPath();
        if (selected_path == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "This will delete the selected query. \n Continue? ", "Delete confirmation", 2, 0) == 2) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected_path.getLastPathComponent();
        if (node instanceof TreeElement) {
            TreeElement element = (TreeElement)((Object)node);
            QueryController qc = this.queryController;
            if (node instanceof QueryTreeElement) {
                qc.removeQuery(element.getID());
            } else if (node instanceof QueryGroupTreeElement) {
                qc.removeGroup(element.getID());
            }
        }
    }

    public void fireQueryChanged(String newgroup, String newquery, String newid) {
        for (SavedQueriesPanelListener listener : this.listeners) {
            listener.selectedQueryChanged(newgroup, newquery, newid);
        }
    }

    public void elementAdded(QueryControllerEntity element) {
        String elementId = element.getID();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)((Object)this.queryControllerModel.getNode(elementId));
        this.treSavedQuery.setSelectionPath(new TreePath(node.getPath()));
        this.treSavedQuery.scrollPathToVisible(new TreePath(node.getPath()));
    }

    public void elementAdded(QueryControllerQuery query, QueryControllerGroup group) {
        String queryId = query.getID();
        String groupId = group.getID();
        QueryTreeElement node = this.queryControllerModel.getElementQuery(queryId, groupId);
        this.treSavedQuery.setSelectionPath(new TreePath(node.getPath()));
        this.treSavedQuery.scrollPathToVisible(new TreePath(node.getPath()));
    }

    public void elementRemoved(QueryControllerEntity element) {
        this.fireQueryChanged("", "", "");
    }

    public void elementRemoved(QueryControllerQuery query, QueryControllerGroup group) {
        this.fireQueryChanged("", "", "");
    }

    public void elementChanged(QueryControllerQuery query, QueryControllerGroup group) {
        String queryId = query.getID();
        String groupId = group.getID();
        QueryTreeElement node = this.queryControllerModel.getElementQuery(queryId, groupId);
        this.treSavedQuery.setSelectionPath(new TreePath(node.getPath()));
        this.treSavedQuery.scrollPathToVisible(new TreePath(node.getPath()));
    }

    public void elementChanged(QueryControllerQuery query) {
        String queryId = query.getID();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)((Object)this.queryControllerModel.getNode(queryId));
        this.treSavedQuery.setSelectionPath(new TreePath(node.getPath()));
        this.treSavedQuery.scrollPathToVisible(new TreePath(node.getPath()));
    }
}

