/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.utils.OptionPaneUtils;
import it.unibz.inf.ontop.utils.querymanager.QueryController;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SaveQueryPanel
extends JPanel {
    private static final long serialVersionUID = -7101725310389493765L;
    private static final String NEWGROUP = "New group...";
    private static final String NOGROUP = "No group...";
    private JDialog parent;
    private String query;
    private QueryController queryController;
    private JComboBox cmbQueryGroup;
    private JButton cmdCancel;
    private JButton cmdCreateNew;
    private JLabel lblDescription;
    private JLabel lblGroup;
    private JLabel lblGroupName;
    private JLabel lblID;
    private JPanel pnlCommandButton;
    private JPanel pnlSaveForm;
    private JTextField txtGroupName;
    private JTextField txtQueryID;

    public SaveQueryPanel(String query, JDialog parent, QueryController queryController) {
        this.query = query;
        this.parent = parent;
        this.queryController = queryController;
        this.initComponents();
        this.initCombo();
    }

    private void initCombo() {
        this.cmbQueryGroup.removeAllItems();
        this.cmbQueryGroup.insertItemAt(NOGROUP, this.cmbQueryGroup.getItemCount());
        QueryController qcontroller = this.queryController;
        List groups = qcontroller.getGroups();
        for (QueryControllerGroup queryGroup : groups) {
            this.cmbQueryGroup.insertItemAt(queryGroup.getID(), this.cmbQueryGroup.getItemCount());
        }
        this.cmbQueryGroup.insertItemAt(NEWGROUP, this.cmbQueryGroup.getItemCount());
        this.cmbQueryGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String name = (String)e.getItem();
                if (name.equals(SaveQueryPanel.NEWGROUP)) {
                    SaveQueryPanel.this.txtGroupName.setEnabled(true);
                } else {
                    SaveQueryPanel.this.txtGroupName.setEnabled(false);
                }
            }
        });
        this.cmbQueryGroup.setSelectedItem(NOGROUP);
    }

    private void initComponents() {
        this.pnlSaveForm = new JPanel();
        this.lblDescription = new JLabel();
        this.lblID = new JLabel();
        this.lblGroup = new JLabel();
        this.lblGroupName = new JLabel();
        this.txtQueryID = new JTextField();
        this.cmbQueryGroup = new JComboBox();
        this.txtGroupName = new JTextField();
        this.pnlCommandButton = new JPanel();
        this.cmdCreateNew = new JButton();
        this.cmdCancel = new JButton();
        this.setMaximumSize(new Dimension(320, 155));
        this.setMinimumSize(new Dimension(320, 155));
        this.setPreferredSize(new Dimension(320, 155));
        this.setLayout(new BorderLayout());
        this.pnlSaveForm.setMaximumSize(new Dimension(340, 120));
        this.pnlSaveForm.setMinimumSize(new Dimension(340, 120));
        this.pnlSaveForm.setPreferredSize(new Dimension(340, 120));
        this.pnlSaveForm.setLayout(new GridBagLayout());
        this.lblDescription.setFont(new Font("Arial", 0, 11));
        this.lblDescription.setText("<html>Insert an ID and group  for this query.</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.pnlSaveForm.add((Component)this.lblDescription, gridBagConstraints);
        this.lblID.setFont(new Font("Arial", 0, 11));
        this.lblID.setText("Query ID:");
        this.lblID.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.pnlSaveForm.add((Component)this.lblID, gridBagConstraints);
        this.lblGroup.setFont(new Font("Arial", 0, 11));
        this.lblGroup.setText("Query Group:");
        this.lblGroup.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.pnlSaveForm.add((Component)this.lblGroup, gridBagConstraints);
        this.lblGroupName.setFont(new Font("Arial", 0, 11));
        this.lblGroupName.setText("Group Name:");
        this.lblGroupName.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.pnlSaveForm.add((Component)this.lblGroupName, gridBagConstraints);
        this.txtQueryID.setMinimumSize(new Dimension(150, 22));
        this.txtQueryID.setPreferredSize(new Dimension(170, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.pnlSaveForm.add((Component)this.txtQueryID, gridBagConstraints);
        this.cmbQueryGroup.setModel(new DefaultComboBoxModel<String>(new String[]{NOGROUP}));
        this.cmbQueryGroup.setBorder(BorderFactory.createEtchedBorder());
        this.cmbQueryGroup.setPreferredSize(new Dimension(140, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        this.pnlSaveForm.add((Component)this.cmbQueryGroup, gridBagConstraints);
        this.txtGroupName.setEnabled(false);
        this.txtGroupName.setMinimumSize(new Dimension(150, 22));
        this.txtGroupName.setPreferredSize(new Dimension(170, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.pnlSaveForm.add((Component)this.txtGroupName, gridBagConstraints);
        this.add((Component)this.pnlSaveForm, "Center");
        this.pnlCommandButton.setMinimumSize(new Dimension(340, 35));
        this.pnlCommandButton.setPreferredSize(new Dimension(340, 35));
        this.cmdCreateNew.setIcon(IconLoader.getImageIcon("images/accept.png"));
        this.cmdCreateNew.setText("Accept");
        this.cmdCreateNew.setBorder(BorderFactory.createEtchedBorder());
        this.cmdCreateNew.setContentAreaFilled(false);
        this.cmdCreateNew.setIconTextGap(5);
        this.cmdCreateNew.setMaximumSize(new Dimension(95, 25));
        this.cmdCreateNew.setMinimumSize(new Dimension(95, 25));
        this.cmdCreateNew.setPreferredSize(new Dimension(95, 25));
        this.cmdCreateNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveQueryPanel.this.cmdCreateNewActionPerformed(evt);
            }
        });
        this.pnlCommandButton.add(this.cmdCreateNew);
        this.cmdCancel.setIcon(IconLoader.getImageIcon("images/cancel.png"));
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setBorder(BorderFactory.createEtchedBorder());
        this.cmdCancel.setContentAreaFilled(false);
        this.cmdCancel.setIconTextGap(5);
        this.cmdCancel.setMaximumSize(new Dimension(95, 25));
        this.cmdCancel.setMinimumSize(new Dimension(95, 25));
        this.cmdCancel.setPreferredSize(new Dimension(95, 25));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveQueryPanel.this.cmdCancelActionPerformed(evt);
            }
        });
        this.pnlCommandButton.add(this.cmdCancel);
        this.add((Component)this.pnlCommandButton, "South");
    }

    private void cmdCreateNewActionPerformed(ActionEvent evt) {
        String id = this.txtQueryID.getText();
        String group = (String)this.cmbQueryGroup.getSelectedItem();
        if (id.isEmpty()) {
            JOptionPane.showMessageDialog(this, "The query ID can't be blank!", "Error", 0);
            return;
        }
        int index = this.queryController.getElementPosition(id);
        if (index != -1) {
            JOptionPane.showMessageDialog(this, "The query or group ID already exists!", "Error", 0);
            return;
        }
        if (group.equals(NOGROUP)) {
            this.queryController.addQuery(this.query, id);
        } else if (group.equals(NEWGROUP)) {
            group = this.txtGroupName.getText().trim();
            if (group.isEmpty()) {
                JOptionPane.showMessageDialog(this, "The group ID can't be blank!", "Error", 0);
                return;
            }
            if (id.equals(group)) {
                JOptionPane.showMessageDialog(this, "The group ID can't have the same name as the query ID!", "Error", 0);
                return;
            }
            try {
                this.queryController.createGroup(group);
                this.queryController.addQuery(this.query, id, group);
            }
            catch (Exception e) {
                OptionPaneUtils.showPrettyMessageDialog(this, e.getMessage(), "Error", 0);
                return;
            }
        } else {
            this.queryController.addQuery(this.query, id, group);
        }
        this.parent.dispose();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.parent.dispose();
    }
}

