/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.answering.reformulation.input.SPARQLQueryUtility;
import it.unibz.inf.ontop.owlapi.resultset.BooleanOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.TupleOWLResultSet;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.gui.action.OBDADataQueryAction;
import it.unibz.inf.ontop.protege.panels.SavedQueriesPanelListener;
import it.unibz.inf.ontop.protege.panels.SelectPrefixPanel;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.utils.OBDAPreferenceChangeListener;
import it.unibz.inf.ontop.utils.querymanager.QueryController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyleContext;
import org.semanticweb.owlapi.model.OWLException;

public class QueryInterfacePanel
extends JPanel
implements SavedQueriesPanelListener,
TableModelListener,
OBDAPreferenceChangeListener {
    private static final long serialVersionUID = -5902798157183352944L;
    private DefaultStyledDocument styledDocument;
    private OBDADataQueryAction<TupleOWLResultSet> executeSelectAction;
    private OBDADataQueryAction<BooleanOWLResultSet> executeAskAction;
    private OBDADataQueryAction<?> executeGraphQueryAction;
    private OBDADataQueryAction<String> retrieveUCQExpansionAction;
    private OBDADataQueryAction<String> retrieveUCQUnfoldingAction;
    private OBDAModel apic;
    private QueryController qc;
    private double execTime = 0.0;
    private int fetchSizeCache = 100;
    private String currentGroup = "";
    private String currentId = "";
    private JCheckBox chkShowAll;
    private JCheckBox chkShowShortURI;
    private JButton cmdAttachPrefix;
    private JButton cmdExecuteQuery;
    private JButton cmdSaveChanges;
    private JMenuItem getSPARQLExpansion;
    private JMenuItem getSPARQLSQLExpansion;
    private JLabel jLabelHeader;
    private JScrollPane jScrollQueryPane;
    private JLabel lblExecutionInfo;
    private JLabel lblShow;
    private JPanel pnlExecutionInfo;
    private JPanel pnlQueryButtons;
    private JPanel pnlQueryEditor;
    private JTextPane queryTextPane;
    private JPopupMenu sparqlPopupMenu;
    private JTextField txtFetchSize;

    public QueryInterfacePanel(OBDAModel apic, QueryController qc) {
        this.qc = qc;
        this.apic = apic;
        this.initComponents();
        StyleContext style = new StyleContext();
        this.styledDocument = new DefaultStyledDocument(style);
        this.queryTextPane.setDocument(this.styledDocument);
        this.queryTextPane.setBackground(Color.WHITE);
        this.queryTextPane.setCaretColor(Color.BLACK);
        this.queryTextPane.addKeyListener(new CTRLEnterKeyListener());
    }

    public void setOBDAModel(OBDAModel api) {
        this.apic = api;
    }

    private void initComponents() {
        this.sparqlPopupMenu = new JPopupMenu();
        this.getSPARQLExpansion = new JMenuItem();
        this.getSPARQLSQLExpansion = new JMenuItem();
        this.pnlQueryButtons = new JPanel();
        this.pnlExecutionInfo = new JPanel();
        this.lblExecutionInfo = new JLabel();
        this.lblShow = new JLabel();
        this.txtFetchSize = new JTextField();
        this.chkShowAll = new JCheckBox();
        this.chkShowShortURI = new JCheckBox();
        this.cmdAttachPrefix = new JButton();
        this.cmdExecuteQuery = new JButton();
        this.cmdSaveChanges = new JButton();
        this.pnlQueryEditor = new JPanel();
        this.jLabelHeader = new JLabel();
        this.jScrollQueryPane = new JScrollPane();
        this.queryTextPane = new JTextPane();
        this.sparqlPopupMenu.setComponentPopupMenu(this.sparqlPopupMenu);
        this.getSPARQLExpansion.setText("Get expansion this UCQ...");
        this.getSPARQLExpansion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryInterfacePanel.this.getSPARQLExpansionActionPerformed(evt);
            }
        });
        this.sparqlPopupMenu.add(this.getSPARQLExpansion);
        this.getSPARQLSQLExpansion.setText("Get SQL translation...");
        this.getSPARQLSQLExpansion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryInterfacePanel.this.getSPARQLSQLExpansionActionPerformed(evt);
            }
        });
        this.sparqlPopupMenu.add(this.getSPARQLSQLExpansion);
        this.setLayout(new GridBagLayout());
        this.pnlQueryButtons.setPreferredSize(new Dimension(445, 30));
        this.pnlQueryButtons.setLayout(new GridBagLayout());
        this.pnlExecutionInfo.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlExecutionInfo.add((Component)this.lblExecutionInfo, gridBagConstraints);
        this.lblShow.setText("Show: ");
        this.pnlExecutionInfo.add((Component)this.lblShow, new GridBagConstraints());
        this.txtFetchSize.setHorizontalAlignment(4);
        this.txtFetchSize.setText("100");
        this.txtFetchSize.setPreferredSize(new Dimension(40, 20));
        this.pnlExecutionInfo.add((Component)this.txtFetchSize, new GridBagConstraints());
        this.chkShowAll.setText("All");
        this.chkShowAll.setHorizontalAlignment(0);
        this.chkShowAll.setPreferredSize(new Dimension(55, 23));
        this.chkShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryInterfacePanel.this.chkShowAllActionPerformed(evt);
            }
        });
        this.pnlExecutionInfo.add((Component)this.chkShowAll, new GridBagConstraints());
        this.chkShowShortURI.setText("Short IRI");
        this.chkShowShortURI.setHorizontalAlignment(2);
        this.chkShowShortURI.setMaximumSize(new Dimension(75, 23));
        this.chkShowShortURI.setMinimumSize(new Dimension(75, 23));
        this.pnlExecutionInfo.add((Component)this.chkShowShortURI, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlQueryButtons.add((Component)this.pnlExecutionInfo, gridBagConstraints);
        this.cmdAttachPrefix.setIcon(IconLoader.getImageIcon("images/attach.png"));
        this.cmdAttachPrefix.setText("Attach Prefixes");
        this.cmdAttachPrefix.setBorder(BorderFactory.createEtchedBorder());
        this.cmdAttachPrefix.setContentAreaFilled(false);
        this.cmdAttachPrefix.setIconTextGap(5);
        this.cmdAttachPrefix.setMaximumSize(new Dimension(112, 26));
        this.cmdAttachPrefix.setMinimumSize(new Dimension(112, 26));
        this.cmdAttachPrefix.setPreferredSize(new Dimension(112, 26));
        this.cmdAttachPrefix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryInterfacePanel.this.cmdAttachPrefixActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.pnlQueryButtons.add((Component)this.cmdAttachPrefix, gridBagConstraints);
        this.cmdExecuteQuery.setIcon(IconLoader.getImageIcon("images/execute.png"));
        this.cmdExecuteQuery.setMnemonic('x');
        this.cmdExecuteQuery.setText("Execute");
        this.cmdExecuteQuery.setBorder(BorderFactory.createEtchedBorder());
        this.cmdExecuteQuery.setContentAreaFilled(false);
        this.cmdExecuteQuery.setIconTextGap(5);
        this.cmdExecuteQuery.setMaximumSize(new Dimension(82, 26));
        this.cmdExecuteQuery.setMinimumSize(new Dimension(82, 26));
        this.cmdExecuteQuery.setPreferredSize(new Dimension(82, 26));
        this.cmdExecuteQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryInterfacePanel.this.cmdExecuteQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.pnlQueryButtons.add((Component)this.cmdExecuteQuery, gridBagConstraints);
        this.cmdSaveChanges.setIcon(IconLoader.getImageIcon("images/save.png"));
        this.cmdSaveChanges.setText("Save Changes");
        this.cmdSaveChanges.setBorder(BorderFactory.createEtchedBorder());
        this.cmdSaveChanges.setContentAreaFilled(false);
        this.cmdSaveChanges.setIconTextGap(5);
        this.cmdSaveChanges.setMaximumSize(new Dimension(112, 26));
        this.cmdSaveChanges.setMinimumSize(new Dimension(112, 26));
        this.cmdSaveChanges.setPreferredSize(new Dimension(112, 26));
        this.cmdSaveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryInterfacePanel.this.cmdSaveChangesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        this.pnlQueryButtons.add((Component)this.cmdSaveChanges, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.pnlQueryButtons, gridBagConstraints);
        this.pnlQueryEditor.setLayout(new BorderLayout());
        this.jLabelHeader.setFont(new Font("Arial", 1, 11));
        this.jLabelHeader.setForeground(new Color(153, 153, 153));
        this.jLabelHeader.setText("  Query Editor");
        this.jLabelHeader.setMaximumSize(new Dimension(68, 18));
        this.jLabelHeader.setMinimumSize(new Dimension(68, 18));
        this.jLabelHeader.setPreferredSize(new Dimension(68, 18));
        this.pnlQueryEditor.add((Component)this.jLabelHeader, "North");
        this.queryTextPane.setFont(new Font("Lucida Console", 0, 14));
        this.queryTextPane.setComponentPopupMenu(this.sparqlPopupMenu);
        this.jScrollQueryPane.setViewportView(this.queryTextPane);
        this.pnlQueryEditor.add((Component)this.jScrollQueryPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlQueryEditor, gridBagConstraints);
    }

    private synchronized void chkShowAllActionPerformed(ActionEvent evt) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (QueryInterfacePanel.this.chkShowAll.isSelected()) {
                    QueryInterfacePanel.this.fetchSizeCache = QueryInterfacePanel.this.getFetchSize();
                    QueryInterfacePanel.this.txtFetchSize.setText("0");
                    QueryInterfacePanel.this.txtFetchSize.setEditable(false);
                } else {
                    QueryInterfacePanel.this.txtFetchSize.setText(QueryInterfacePanel.this.fetchSizeCache + "");
                    QueryInterfacePanel.this.txtFetchSize.setEditable(true);
                }
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    private void getSPARQLExpansionActionPerformed(ActionEvent evt) {
        Thread queryRunnerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                OBDADataQueryAction<?> action = QueryInterfacePanel.this.getRetrieveUCQExpansionAction();
                action.run(QueryInterfacePanel.this.queryTextPane.getText());
            }
        });
        queryRunnerThread.start();
    }

    private void getSPARQLSQLExpansionActionPerformed(ActionEvent evt) {
        Thread queryRunnerThread = new Thread(() -> {
            OBDADataQueryAction<?> action = this.getRetrieveUCQUnfoldingAction();
            action.run(this.queryTextPane.getText());
        });
        queryRunnerThread.start();
    }

    private void cmdAttachPrefixActionPerformed(ActionEvent evt) {
        SelectPrefixPanel dialog = new SelectPrefixPanel((PrefixManager)this.apic.getMutablePrefixManager(), this.queryTextPane);
        dialog.show();
    }

    private void cmdExecuteQueryActionPerformed(ActionEvent evt) {
        try {
            Thread queryRunnerThread = new Thread(() -> {
                String queryString = this.queryTextPane.getText();
                OBDADataQueryAction<?> action = null;
                if (queryString.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Query editor cannot be empty.");
                } else if (SPARQLQueryUtility.isSelectQuery((String)queryString)) {
                    action = this.getExecuteSelectAction();
                } else if (SPARQLQueryUtility.isAskQuery((String)queryString)) {
                    action = this.getExecuteAskAction();
                } else if (SPARQLQueryUtility.isConstructQuery((String)queryString) || SPARQLQueryUtility.isDescribeQuery((String)queryString)) {
                    action = this.getExecuteGraphQueryAction();
                } else {
                    JOptionPane.showMessageDialog(this, "This type of SPARQL expression is not handled. Please use SELECT, ASK, DESCRIBE, or CONSTRUCT.");
                }
                if (action != null) {
                    int rows;
                    action.run(queryString);
                    this.execTime = action.getExecutionTime();
                    do {
                        rows = action.getNumberOfRows();
                        this.updateStatus(rows);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    } while (action.isRunning());
                    rows = action.getNumberOfRows();
                    this.updateStatus(rows);
                }
            });
            queryRunnerThread.start();
        }
        catch (Exception e) {
            DialogUtils.showQuickErrorDialog(this, e);
        }
    }

    private synchronized void cmdSaveChangesActionPerformed(ActionEvent evt) {
        String query = this.queryTextPane.getText();
        if (!this.currentId.isEmpty()) {
            if (!this.currentGroup.isEmpty()) {
                this.qc.addQuery(query, this.currentId, this.currentGroup);
            } else {
                this.qc.addQuery(query, this.currentId);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Please select first the query node that you would like to update", "Warning", 2);
        }
    }

    @Override
    public void selectedQueryChanged(String new_group, String new_query, String new_id) {
        QueryChanger runner = new QueryChanger(new_query);
        SwingUtilities.invokeLater(runner);
        this.currentGroup = new_group;
        this.currentId = new_id;
    }

    public void setExecuteSelectAction(OBDADataQueryAction<TupleOWLResultSet> executeUCQAction) {
        this.executeSelectAction = executeUCQAction;
    }

    public OBDADataQueryAction<?> getExecuteSelectAction() {
        return this.executeSelectAction;
    }

    public void setExecuteAskAction(OBDADataQueryAction<BooleanOWLResultSet> executeUCQAction) {
        this.executeAskAction = executeUCQAction;
    }

    public OBDADataQueryAction<?> getExecuteAskAction() {
        return this.executeAskAction;
    }

    public void setExecuteGraphQueryAction(OBDADataQueryAction<?> action) {
        this.executeGraphQueryAction = action;
    }

    public OBDADataQueryAction<?> getExecuteGraphQueryAction() {
        return this.executeGraphQueryAction;
    }

    public void setRetrieveUCQExpansionAction(OBDADataQueryAction<String> retrieveUCQExpansionAction) {
        this.retrieveUCQExpansionAction = retrieveUCQExpansionAction;
    }

    public OBDADataQueryAction<?> getRetrieveUCQExpansionAction() {
        return this.retrieveUCQExpansionAction;
    }

    public void setRetrieveUCQUnfoldingAction(OBDADataQueryAction<String> retrieveUCQUnfoldingAction) {
        this.retrieveUCQUnfoldingAction = retrieveUCQUnfoldingAction;
    }

    public OBDADataQueryAction<?> getRetrieveUCQUnfoldingAction() {
        return this.retrieveUCQUnfoldingAction;
    }

    public void updateStatus(long result) {
        if (result != -1L) {
            Double time = this.execTime / 1000.0;
            String s = String.format("Execution time: %s sec - Number of rows retrieved: %,d ", time, result);
            ExecTimeSetter time_setter = new ExecTimeSetter(s);
            SwingUtilities.invokeLater(time_setter);
        }
    }

    public void showBooleanActionResultInTextInfo(String title, BooleanOWLResultSet result) throws OWLException {
        AskQueryInfoSetter alter_result_panel = new AskQueryInfoSetter(title, result);
        SwingUtilities.invokeLater(alter_result_panel);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int rows = ((TableModel)e.getSource()).getRowCount();
        this.updateStatus(rows);
    }

    public boolean isShortURISelect() {
        return this.chkShowShortURI.isSelected();
    }

    public boolean isFetchAllSelect() {
        return this.chkShowAll.isSelected();
    }

    public boolean canGetMoreTuples() {
        return this.getFetchSize() > 100;
    }

    public String getQuery() {
        return this.queryTextPane.getText();
    }

    public int getFetchSize() {
        int fetchSize = 0;
        try {
            fetchSize = Integer.parseInt(this.txtFetchSize.getText());
        }
        catch (NumberFormatException e) {
            DialogUtils.showQuickErrorDialog(this, new Exception("Invalid input: " + this.txtFetchSize.getText()), e.toString());
        }
        return fetchSize;
    }

    @Override
    public synchronized void preferenceChanged() {
        String query = this.queryTextPane.getText();
        SetQueryTextPane setter = new SetQueryTextPane(query);
        SwingUtilities.invokeLater(setter);
    }

    private class SetQueryTextPane
    implements Runnable {
        String query;

        SetQueryTextPane(String query) {
            this.query = query;
        }

        @Override
        public void run() {
            QueryInterfacePanel.this.queryTextPane.setText(this.query);
        }
    }

    private class AskQueryInfoSetter
    implements Runnable {
        String title;
        BooleanOWLResultSet result;

        AskQueryInfoSetter(String title, BooleanOWLResultSet result) {
            this.title = title;
            this.result = result;
        }

        @Override
        public void run() {
            Double time = QueryInterfacePanel.this.execTime / 1000.0;
            String s = String.format("Execution time: %s sec - ", time);
            try {
                String answer;
                if (this.result.getValue()) {
                    answer = "true";
                    QueryInterfacePanel.this.lblExecutionInfo.setBackground(Color.GREEN);
                    QueryInterfacePanel.this.lblExecutionInfo.setOpaque(true);
                } else {
                    answer = "false";
                    QueryInterfacePanel.this.lblExecutionInfo.setBackground(Color.RED);
                    QueryInterfacePanel.this.lblExecutionInfo.setOpaque(true);
                }
                QueryInterfacePanel.this.lblExecutionInfo.setText(s + this.title + " " + answer);
            }
            catch (OWLException e) {
                JOptionPane.showMessageDialog(QueryInterfacePanel.this, (Object)e);
            }
        }
    }

    private class ExecTimeSetter
    implements Runnable {
        String s;

        ExecTimeSetter(String s) {
            this.s = s;
        }

        @Override
        public void run() {
            QueryInterfacePanel.this.lblExecutionInfo.setText(this.s);
            QueryInterfacePanel.this.lblExecutionInfo.setOpaque(false);
        }
    }

    private class QueryChanger
    implements Runnable {
        String new_query;

        QueryChanger(String new_query) {
            this.new_query = new_query;
        }

        @Override
        public void run() {
            QueryInterfacePanel.this.queryTextPane.setText(this.new_query);
        }
    }

    private class CTRLEnterKeyListener
    implements KeyListener {
        private CTRLEnterKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getModifiers() == 2 && e.getKeyCode() == 10) {
                QueryInterfacePanel.this.cmdExecuteQueryActionPerformed(null);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

