/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import it.unibz.inf.ontop.utils.VirtualABoxStatistics;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class OBDAModelStatisticsPanel
extends JPanel
implements OBDAProgressListener {
    private static final long serialVersionUID = 2317777246039649415L;
    private boolean bCancel = false;
    private boolean errorShown = false;
    private JLabel lblSummary;
    private JLabel lblSummaryValue;
    private JPanel pnlSummary;
    private JPanel pnlTriplesSummary;
    private JTabbedPane tabDataSources;

    public OBDAModelStatisticsPanel() {
        this.initComponents();
    }

    public void initContent(VirtualABoxStatistics statistics) {
        String message = "";
        try {
            int count = statistics.getTotalTriples();
            message = String.format("%s %s", count, count == 1 ? "triple" : "triples");
        }
        catch (Exception e) {
            message = String.format("%s. Please try again!", e.getMessage());
            this.errorShown = true;
            e.printStackTrace();
        }
        this.lblSummaryValue.setText(message);
        HashMap<String, HashMap<String, Integer>> data = statistics.getStatistics();
        for (String datasourceName : data.keySet()) {
            HashMap<String, Integer> mappingStat = data.get(datasourceName);
            int row = mappingStat.size();
            int col = 2;
            String[] columnNames = new String[]{"Mapping ID", "Number of Triples"};
            Object[][] rowData = new Object[row][2];
            int index = 0;
            for (String mappingId : mappingStat.keySet()) {
                rowData[index][0] = mappingId;
                rowData[index][1] = mappingStat.get(mappingId);
                ++index;
            }
            JTable tblTriplesCount = this.createStatisticTable(rowData, columnNames);
            this.tabDataSources.add(datasourceName, new JScrollPane(tblTriplesCount));
        }
    }

    private JTable createStatisticTable(Object[][] rowData, String[] columnNames) {
        DefaultTableModel model = new DefaultTableModel(rowData, columnNames);
        JTable table = new JTable(model){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        return table;
    }

    private void initComponents() {
        this.pnlSummary = new JPanel();
        this.lblSummary = new JLabel();
        this.lblSummaryValue = new JLabel();
        this.pnlTriplesSummary = new JPanel();
        this.tabDataSources = new JTabbedPane();
        this.setFont(new Font("Arial", 0, 18));
        this.setMinimumSize(new Dimension(520, 400));
        this.setPreferredSize(new Dimension(520, 400));
        this.setLayout(new BorderLayout());
        this.pnlSummary.setMinimumSize(new Dimension(156, 23));
        this.pnlSummary.setPreferredSize(new Dimension(156, 23));
        this.pnlSummary.setLayout(new FlowLayout(0));
        this.lblSummary.setFont(new Font("Tahoma", 1, 11));
        this.lblSummary.setText("Total triples produced:");
        this.pnlSummary.add(this.lblSummary);
        this.lblSummaryValue.setFont(new Font("Tahoma", 1, 11));
        this.pnlSummary.add(this.lblSummaryValue);
        this.add((Component)this.pnlSummary, "North");
        this.pnlTriplesSummary.setLayout(new BorderLayout());
        this.tabDataSources.setTabLayoutPolicy(1);
        this.tabDataSources.setTabPlacement(3);
        this.pnlTriplesSummary.add((Component)this.tabDataSources, "Center");
        this.add((Component)this.pnlTriplesSummary, "Center");
    }

    @Override
    public void actionCanceled() {
        this.bCancel = true;
    }

    @Override
    public boolean isCancelled() {
        return this.bCancel;
    }

    @Override
    public boolean isErrorShown() {
        return this.errorShown;
    }
}

