/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.owlapi.validation.QuestOWLEmptyEntitiesChecker;
import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptiesCheckPanel
extends JPanel
implements OBDAProgressListener {
    private static final long serialVersionUID = 2317777246039649415L;
    Logger log = LoggerFactory.getLogger(EmptiesCheckPanel.class);
    private boolean bCancel = false;
    private boolean errorShown = false;
    private JScrollPane jScrollConcepts;
    private JScrollPane jScrollRoles;
    private JLabel lblSummary;
    private JLabel lblSummaryValue;
    private JPanel pnlEmptiesSummary;
    private JPanel pnlSummary;

    public EmptiesCheckPanel() {
        this.initComponents();
    }

    public void initContent(QuestOWLEmptyEntitiesChecker check) {
        try {
            String message;
            Iterator emptyC = check.iEmptyConcepts();
            int rowConcepts = check.getEConceptsSize();
            boolean col = true;
            String[] columnConcept = new String[]{"Concepts"};
            Object[][] rowDataConcept = new Object[rowConcepts][1];
            JTable tblConceptCount = this.createTable(rowDataConcept, columnConcept);
            this.jScrollConcepts.setViewportView(tblConceptCount);
            DefaultTableModel modelConcept = (DefaultTableModel)tblConceptCount.getModel();
            while (emptyC.hasNext() && !this.bCancel) {
                modelConcept.addRow(new Object[]{((IRI)emptyC.next()).getIRIString()});
            }
            Iterator emptyR = check.iEmptyRoles();
            int rowRoles = check.getERolesSize();
            String[] columnRole = new String[]{"Roles"};
            Object[][] rowDataRole = new Object[rowRoles][1];
            JTable tblRoleCount = this.createTable(rowDataRole, columnRole);
            this.jScrollRoles.setViewportView(tblRoleCount);
            DefaultTableModel modelRole = (DefaultTableModel)tblRoleCount.getModel();
            while (emptyR.hasNext() && !this.bCancel) {
                modelRole.addRow(new Object[]{((IRI)emptyR.next()).getIRIString()});
            }
            try {
                message = check.toString();
            }
            catch (Exception e) {
                message = String.format("%s. Please try again!", e.getMessage());
            }
            this.lblSummaryValue.setText(message);
        }
        catch (Exception e) {
            this.errorShown = true;
            this.log.error("If OutOfMemoryError try increasing java heap size. ");
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred. For more info, see the logs.");
        }
    }

    private JTable createTable(Object[][] rowData, String[] columnNames) {
        DefaultTableModel model = new DefaultTableModel(rowData, columnNames);
        JTable table = new JTable(model){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        return table;
    }

    private void initComponents() {
        this.pnlSummary = new JPanel();
        this.lblSummary = new JLabel();
        this.lblSummaryValue = new JLabel();
        this.pnlEmptiesSummary = new JPanel();
        this.jScrollConcepts = new JScrollPane();
        this.jScrollRoles = new JScrollPane();
        this.setFont(new Font("Arial", 0, 18));
        this.setMinimumSize(new Dimension(520, 400));
        this.setPreferredSize(new Dimension(520, 400));
        this.setLayout(new BorderLayout());
        this.pnlSummary.setMinimumSize(new Dimension(156, 23));
        this.pnlSummary.setPreferredSize(new Dimension(156, 23));
        this.pnlSummary.setLayout(new FlowLayout(0));
        this.lblSummary.setFont(new Font("Tahoma", 1, 11));
        this.lblSummary.setText("Empty concepts and roles");
        this.pnlSummary.add(this.lblSummary);
        this.lblSummaryValue.setFont(new Font("Tahoma", 1, 11));
        this.pnlSummary.add(this.lblSummaryValue);
        this.add((Component)this.pnlSummary, "North");
        this.pnlEmptiesSummary.setLayout(new BoxLayout(this.pnlEmptiesSummary, 3));
        this.pnlEmptiesSummary.add(this.jScrollConcepts);
        this.jScrollRoles.setCursor(new Cursor(0));
        this.pnlEmptiesSummary.add(this.jScrollRoles);
        this.add((Component)this.pnlEmptiesSummary, "Center");
    }

    @Override
    public void actionCanceled() {
        this.bCancel = true;
    }

    @Override
    public boolean isCancelled() {
        return this.bCancel;
    }

    @Override
    public boolean isErrorShown() {
        return this.errorShown;
    }
}

