/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.treemodels;

import it.unibz.inf.ontop.protege.gui.treemodels.QueryGroupTreeElement;
import it.unibz.inf.ontop.protege.gui.treemodels.QueryTreeElement;
import it.unibz.inf.ontop.protege.gui.treemodels.TreeElement;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerEntity;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerGroup;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerListener;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerQuery;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class QueryControllerTreeModel
extends DefaultTreeModel
implements QueryControllerListener {
    private static final long serialVersionUID = -5182895959682699380L;

    public QueryControllerTreeModel() {
        super(new DefaultMutableTreeNode(""));
    }

    public void synchronize(List<QueryControllerEntity> queryEntities) {
        if (queryEntities.size() > 0) {
            for (QueryControllerEntity queryEntity : queryEntities) {
                if (queryEntity instanceof QueryControllerGroup) {
                    QueryControllerGroup group = (QueryControllerGroup)queryEntity;
                    QueryGroupTreeElement queryGroupEle = new QueryGroupTreeElement(group.getID());
                    Vector queries = group.getQueries();
                    for (QueryControllerQuery query : queries) {
                        QueryTreeElement queryTreeEle = new QueryTreeElement(query.getID(), query.getQuery());
                        this.insertNodeInto(queryTreeEle, queryGroupEle, queryGroupEle.getChildCount());
                    }
                    this.insertNodeInto(queryGroupEle, (DefaultMutableTreeNode)this.root, this.root.getChildCount());
                    continue;
                }
                QueryControllerQuery query = (QueryControllerQuery)queryEntity;
                QueryTreeElement queryTreeEle = new QueryTreeElement(query.getID(), query.getQuery());
                this.insertNodeInto(queryTreeEle, (DefaultMutableTreeNode)this.root, this.root.getChildCount());
            }
        }
    }

    public void reset() {
        Enumeration<? extends TreeNode> children = this.root.children();
        while (children.hasMoreElements()) {
            this.removeNodeFromParent((MutableTreeNode)children.nextElement());
            children = this.root.children();
        }
    }

    public void elementAdded(QueryControllerEntity element) {
        if (element instanceof QueryControllerGroup) {
            QueryControllerGroup group = (QueryControllerGroup)element;
            QueryGroupTreeElement ele = new QueryGroupTreeElement(group.getID());
            this.insertNodeInto(ele, (DefaultMutableTreeNode)this.root, this.root.getChildCount());
            this.nodeStructureChanged(this.root);
        } else if (element instanceof QueryControllerQuery) {
            QueryControllerQuery query = (QueryControllerQuery)element;
            QueryTreeElement ele = new QueryTreeElement(query.getID(), query.getQuery());
            this.insertNodeInto(ele, (DefaultMutableTreeNode)this.root, this.root.getChildCount());
            this.nodeStructureChanged(this.root);
        }
    }

    public void elementRemoved(QueryControllerEntity element) {
        block2: {
            block3: {
                if (!(element instanceof QueryControllerGroup)) break block3;
                QueryControllerGroup group = (QueryControllerGroup)element;
                QueryGroupTreeElement ele = new QueryGroupTreeElement(group.getID());
                Enumeration<? extends TreeNode> groups = this.root.children();
                while (groups.hasMoreElements()) {
                    QueryGroupTreeElement groupTElement;
                    TreeNode temporal = groups.nextElement();
                    if (!(temporal instanceof QueryGroupTreeElement) || !(groupTElement = (QueryGroupTreeElement)temporal).getID().equals(ele.getID())) continue;
                    this.removeNodeFromParent(groupTElement);
                    this.nodeStructureChanged(this.root);
                    break block2;
                }
                break block2;
            }
            if (!(element instanceof QueryControllerQuery)) break block2;
            QueryControllerQuery query = (QueryControllerQuery)element;
            QueryTreeElement elementQuery = new QueryTreeElement(query.getID(), query.getQuery());
            Enumeration<? extends TreeNode> elements = this.root.children();
            while (elements.hasMoreElements()) {
                QueryTreeElement deleteQuery;
                TreeNode currentElement = elements.nextElement();
                if (currentElement instanceof QueryGroupTreeElement || !(currentElement instanceof QueryTreeElement) || !(deleteQuery = (QueryTreeElement)currentElement).getID().equals(elementQuery.getID())) continue;
                this.removeNodeFromParent(deleteQuery);
                this.nodeStructureChanged(this.root);
                break;
            }
        }
    }

    public void elementAdded(QueryControllerQuery query, QueryControllerGroup group) {
        QueryGroupTreeElement groupTElement = null;
        QueryTreeElement elemQ = new QueryTreeElement(query.getID(), query.getQuery());
        Enumeration<? extends TreeNode> groups = this.root.children();
        while (groups.hasMoreElements()) {
            TreeNode temporal = groups.nextElement();
            if (!(temporal instanceof QueryGroupTreeElement) || !(groupTElement = (QueryGroupTreeElement)temporal).getID().equals(group.getID())) continue;
            this.insertNodeInto(elemQ, groupTElement, groupTElement.getChildCount());
            this.nodeStructureChanged(this.root);
            break;
        }
    }

    public void elementRemoved(QueryControllerQuery query, QueryControllerGroup group) {
        QueryGroupTreeElement ele = new QueryGroupTreeElement(group.getID());
        QueryTreeElement elemQ = new QueryTreeElement(query.getID(), query.getQuery());
        Enumeration<? extends TreeNode> groups = this.root.children();
        block0: while (groups.hasMoreElements()) {
            QueryGroupTreeElement groupTElement;
            TreeNode node = groups.nextElement();
            if (!(node instanceof QueryGroupTreeElement) || !(groupTElement = (QueryGroupTreeElement)node).getID().equals(ele.getID())) continue;
            Enumeration<TreeNode> queries = groupTElement.children();
            while (queries.hasMoreElements()) {
                QueryTreeElement queryTElement = (QueryTreeElement)queries.nextElement();
                if (!queryTElement.getID().equals(elemQ.getID())) continue;
                this.removeNodeFromParent(queryTElement);
                this.nodeStructureChanged(this.root);
                continue block0;
            }
        }
    }

    public void elementChanged(QueryControllerQuery query) {
        QueryTreeElement node = this.getTreeNode(this.root, query);
        node.setQuery(query.getQuery());
        this.nodeChanged(node);
    }

    public void elementChanged(QueryControllerQuery query, QueryControllerGroup group) {
        QueryTreeElement node = this.getTreeNode(this.root, group, query);
        node.setQuery(query.getQuery());
        this.nodeChanged(node);
    }

    private QueryTreeElement getTreeNode(TreeNode root, QueryControllerQuery query) {
        Enumeration<? extends TreeNode> parent = root.children();
        while (parent.hasMoreElements()) {
            QueryTreeElement queryNode;
            TreeNode node = parent.nextElement();
            if (!(node instanceof QueryTreeElement) || !(queryNode = (QueryTreeElement)node).getID().equals(query.getID())) continue;
            return queryNode;
        }
        return null;
    }

    private QueryTreeElement getTreeNode(TreeNode root, QueryControllerGroup group, QueryControllerQuery query) {
        Enumeration<? extends TreeNode> parent = root.children();
        while (parent.hasMoreElements()) {
            QueryGroupTreeElement groupNode;
            TreeNode node = parent.nextElement();
            if (!(node instanceof QueryGroupTreeElement) || !(groupNode = (QueryGroupTreeElement)node).getID().equals(group.getID())) continue;
            return this.getTreeNode(groupNode, query);
        }
        return null;
    }

    public TreeElement getNode(String element) {
        DefaultMutableTreeNode node = null;
        Enumeration<? extends TreeNode> elements = this.root.children();
        while (elements.hasMoreElements()) {
            QueryTreeElement queryTreeElement;
            QueryGroupTreeElement groupTElement;
            TreeElement currentNode = (TreeElement)elements.nextElement();
            if (currentNode instanceof QueryGroupTreeElement && (groupTElement = (QueryGroupTreeElement)currentNode).getID().equals(element)) {
                node = groupTElement;
                break;
            }
            if (!(currentNode instanceof QueryTreeElement) || !(queryTreeElement = (QueryTreeElement)currentNode).getID().equals(element)) continue;
            node = queryTreeElement;
            break;
        }
        return node;
    }

    public QueryTreeElement getElementQuery(String element, String group) {
        QueryTreeElement node = null;
        Enumeration<? extends TreeNode> elements = this.root.children();
        block0: while (elements.hasMoreElements()) {
            TreeElement currentNode = (TreeElement)elements.nextElement();
            if (!(currentNode instanceof QueryGroupTreeElement) || !currentNode.getID().equals(group)) continue;
            QueryGroupTreeElement groupTElement = (QueryGroupTreeElement)currentNode;
            Enumeration<TreeNode> queries = groupTElement.children();
            while (queries.hasMoreElements()) {
                QueryTreeElement queryTElement = (QueryTreeElement)queries.nextElement();
                if (!queryTElement.getID().equals(element)) continue;
                node = queryTElement;
                continue block0;
            }
        }
        return node;
    }
}

