/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.component;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class AutoSuggestComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private Vector<Object> items;
    private boolean hideFlag = false;

    public AutoSuggestComboBox(Vector<Object> items) {
        super(items);
        this.items = items;
        this.setFont(new Font("Dialog", 0, 14));
        this.setEditable(true);
        this.setSelectedIndex(-1);
        this.overrideEditorBehavior();
    }

    public void overrideEditorBehavior() {
        if (this.getEditor().getEditorComponent() instanceof JTextField) {
            final JTextField tf = (JTextField)this.getEditor().getEditorComponent();
            tf.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String text = tf.getText();
                            if (text.length() == 0) {
                                AutoSuggestComboBox.this.hidePopup();
                                AutoSuggestComboBox.this.setModel(new DefaultComboBoxModel(AutoSuggestComboBox.this.items), "");
                            } else {
                                DefaultComboBoxModel m = AutoSuggestComboBox.getSuggestedModel(AutoSuggestComboBox.this.items, text);
                                if (m.getSize() == 0 || AutoSuggestComboBox.this.hideFlag) {
                                    AutoSuggestComboBox.this.hidePopup();
                                    AutoSuggestComboBox.this.hideFlag = false;
                                } else {
                                    AutoSuggestComboBox.this.setModel(m, text);
                                    AutoSuggestComboBox.this.showPopup();
                                }
                            }
                            tf.setText(text);
                        }
                    });
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    String text = tf.getText();
                    int code = e.getKeyCode();
                    if (code == 27) {
                        AutoSuggestComboBox.this.hideFlag = true;
                    } else if (code == 39) {
                        for (int i = 0; i < AutoSuggestComboBox.this.items.size(); ++i) {
                            Object element = AutoSuggestComboBox.this.items.elementAt(i);
                            String value = element.toString();
                            if (!value.startsWith(text)) continue;
                            if (value.contains(":") && !text.contains(":")) {
                                tf.setText(value.substring(0, value.indexOf(":") + 1));
                            }
                            return;
                        }
                    } else if (code == 10) {
                        tf.transferFocus();
                        AutoSuggestComboBox.this.hideFlag = true;
                    }
                }
            });
        }
    }

    private void setModel(DefaultComboBoxModel mdl, String str) {
        this.setModel(mdl);
        this.setSelectedIndex(-1);
    }

    private static DefaultComboBoxModel getSuggestedModel(List<Object> items, String searchedText) {
        DefaultComboBoxModel<Object> m = new DefaultComboBoxModel<Object>();
        for (Object element : items) {
            String value = element.toString();
            if (!value.startsWith(searchedText)) continue;
            m.addElement(element);
        }
        return m;
    }
}

