/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.action;

import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import it.unibz.inf.ontop.spec.mapping.pp.impl.SQLPPMappingImpl;
import it.unibz.inf.ontop.spec.mapping.serializer.SQLPPMappingToR2RMLConverter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLWorkspace;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RMLExportAction
extends ProtegeAction {
    private static final long serialVersionUID = -1211395039869926309L;
    private OWLEditorKit editorKit = null;
    private OBDAModel obdaModel = null;
    private OWLModelManager modelManager = null;
    private Logger log = LoggerFactory.getLogger(R2RMLExportAction.class);

    public void initialise() throws Exception {
        this.editorKit = (OWLEditorKit)this.getEditorKit();
        this.obdaModel = ((OBDAModelManager)this.editorKit.get((Object)SQLPPMappingImpl.class.getName())).getActiveOBDAModel();
        this.modelManager = this.editorKit.getOWLModelManager();
    }

    public void dispose() throws Exception {
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            final OWLWorkspace workspace = this.editorKit.getWorkspace();
            if (this.obdaModel.getSources().isEmpty()) {
                JOptionPane.showMessageDialog((Component)workspace, "The data source is missing. Create one in ontop Mappings. ");
            } else {
                OWLOntology activeOntology = this.modelManager.getActiveOntology();
                IRI documentIRI = this.modelManager.getOWLOntologyManager().getOntologyDocumentIRI(activeOntology);
                File ontologyDir = new File(documentIRI.toURI().getPath());
                JFileChooser fc = new JFileChooser(ontologyDir);
                String shortForm = documentIRI.getShortForm();
                int i = shortForm.lastIndexOf(".");
                String ontologyName = i < 1 ? shortForm : shortForm.substring(0, i);
                fc.setSelectedFile(new File(ontologyName + "-mapping.ttl"));
                int approve = fc.showSaveDialog((Component)workspace);
                if (approve == 0) {
                    final File file = fc.getSelectedFile();
                    Thread th = new Thread("R2RML Export Action Thread"){

                        @Override
                        public void run() {
                            try {
                                OBDAProgressMonitor monitor = new OBDAProgressMonitor("Exporting the mapping to R2RML...", (Component)workspace);
                                R2RMLExportThread t = new R2RMLExportThread();
                                monitor.addProgressListener(t);
                                monitor.start();
                                t.run(file);
                                monitor.stop();
                                JOptionPane.showMessageDialog((Component)workspace, "R2RML Export completed.", "Done", 1);
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog((Component)workspace, "An error occurred. For more info, see the logs.");
                                R2RMLExportAction.this.log.error("Error during R2RML export. \n", (Object)e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    };
                    th.start();
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog((Component)this.getWorkspace(), "An error occurred. For more info, see the logs.");
            this.log.error("Error during R2RML export. \n");
            ex.printStackTrace();
        }
    }

    private class R2RMLExportThread
    implements OBDAProgressListener {
        private R2RMLExportThread() {
        }

        @Override
        public void actionCanceled() throws Exception {
        }

        public void run(File file) throws Exception {
            SQLPPMappingToR2RMLConverter writer = new SQLPPMappingToR2RMLConverter(R2RMLExportAction.this.obdaModel.generatePPMapping(), R2RMLExportAction.this.obdaModel.getRdfFactory(), R2RMLExportAction.this.obdaModel.getTermFactory());
            writer.write(file);
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isErrorShown() {
            return false;
        }
    }
}

