/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.action;

import com.google.common.collect.Sets;
import it.unibz.inf.ontop.owlapi.resultset.MaterializedGraphOWLResultSet;
import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import java.awt.Container;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.swing.JOptionPane;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializeAction
implements OBDAProgressListener {
    private Logger log = LoggerFactory.getLogger(MaterializeAction.class);
    private Thread thread = null;
    private CountDownLatch latch = null;
    private OWLOntology currentOntology = null;
    private OWLOntologyManager ontologyManager = null;
    private final MaterializedGraphOWLResultSet graphResultSet;
    private Container cont = null;
    private boolean bCancel = false;
    private boolean errorShown = false;

    public MaterializeAction(OWLOntology currentOntology, OWLOntologyManager ontologyManager, MaterializedGraphOWLResultSet graphResultSet, Container cont) {
        this.currentOntology = currentOntology;
        this.ontologyManager = ontologyManager;
        this.graphResultSet = graphResultSet;
        this.cont = cont;
    }

    public void setCountdownLatch(CountDownLatch cdl) {
        this.latch = cdl;
    }

    public void run() {
        if (this.latch == null) {
            try {
                throw new Exception("No CountDownLatch set");
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                JOptionPane.showMessageDialog(this.cont, "ERROR: could not materialize Abox.");
                this.errorShown = true;
                return;
            }
        }
        this.thread = new Thread("AddAxiomToOntology Thread"){

            @Override
            public void run() {
                try {
                    HashSet setAxioms = Sets.newHashSet();
                    while (MaterializeAction.this.graphResultSet.hasNext()) {
                        setAxioms.add(MaterializeAction.this.graphResultSet.next());
                    }
                    MaterializeAction.this.graphResultSet.close();
                    MaterializeAction.this.ontologyManager.addAxioms(MaterializeAction.this.currentOntology, (Set)setAxioms);
                    MaterializeAction.this.latch.countDown();
                    if (!MaterializeAction.this.bCancel) {
                        JOptionPane.showMessageDialog(MaterializeAction.this.cont, "Task is completed", "Done", 1);
                    }
                }
                catch (Exception e) {
                    MaterializeAction.this.latch.countDown();
                    MaterializeAction.this.log.error("Materialization of Abox failed", (Throwable)e);
                }
                catch (Error e) {
                    MaterializeAction.this.latch.countDown();
                    MaterializeAction.this.log.error("Materialization of Abox failed", (Throwable)e);
                    JOptionPane.showMessageDialog(null, "An error occurred. For more info, see the logs.");
                }
            }
        };
        this.thread.start();
    }

    @Override
    public void actionCanceled() {
        if (this.thread != null) {
            this.bCancel = true;
            this.latch.countDown();
            this.thread.interrupt();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.bCancel;
    }

    @Override
    public boolean isErrorShown() {
        return this.errorShown;
    }
}

