/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.action;

import it.unibz.inf.ontop.protege.core.OntopProtegeReasoner;
import it.unibz.inf.ontop.protege.gui.action.AboxMaterializationAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLWorkspace;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InconsistencyCheckAction
extends ProtegeAction {
    private static final long serialVersionUID = 1L;
    private OWLEditorKit editorKit = null;
    private OWLWorkspace workspace;
    private OWLModelManager modelManager;
    private Logger log = LoggerFactory.getLogger(AboxMaterializationAction.class);

    public void initialise() throws Exception {
        this.editorKit = (OWLEditorKit)this.getEditorKit();
        this.workspace = this.editorKit.getWorkspace();
        this.modelManager = this.editorKit.getOWLModelManager();
    }

    public void dispose() throws Exception {
    }

    public void actionPerformed(ActionEvent e) {
        block5: {
            OWLReasoner reasoner = this.modelManager.getOWLReasonerManager().getCurrentReasoner();
            if (reasoner instanceof OntopProtegeReasoner) {
                try {
                    OntopProtegeReasoner questReasoner = (OntopProtegeReasoner)reasoner;
                    boolean isConsistent = questReasoner.isQuestConsistent();
                    this.log.debug("Checking for inconsistency returned: " + isConsistent);
                    if (isConsistent) {
                        JOptionPane.showMessageDialog((Component)this.getWorkspace(), "Your ontology is consistent! Great job!");
                        break block5;
                    }
                    JOptionPane.showMessageDialog((Component)this.getWorkspace(), "Your ontology is not consistent. The axiom creating inconsistency is: \n" + questReasoner.getInconsistentAxiom().toString());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)this.getWorkspace(), "An error occured. For more info, see the logs.");
                    this.log.error("Error during inconsistency checking. \n" + ex.getMessage() + "\n" + ex.getLocalizedMessage());
                }
            } else {
                JOptionPane.showMessageDialog((Component)this.getWorkspace(), "You have to start ontop reasoner for this feature.");
            }
        }
    }
}

