/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SQLResultSetTableModel
implements TableModel {
    private ResultSet results;
    private ResultSetMetaData rsMetadata;
    private int numcols;
    private int numrows;
    private int fetchSizeLimit;
    private Vector<String[]> resultsTable;
    private Vector<TableModelListener> listener;
    private final int INITIAL_FETCH_SIZE = 100;
    private final int NEXT_FETCH_SIZE = 100;

    public SQLResultSetTableModel(ResultSet results, int fetchSizeLimit) throws SQLException {
        this.results = results;
        this.fetchSizeLimit = fetchSizeLimit;
        this.rsMetadata = results.getMetaData();
        this.numcols = this.rsMetadata.getColumnCount();
        this.numrows = 0;
        this.resultsTable = new Vector();
        this.listener = new Vector();
        int fetchSize = fetchSizeLimit;
        if (this.needFetchMore()) {
            fetchSize = 100;
        }
        this.fetchRows(fetchSize);
    }

    private void fetchRows(int size) throws SQLException {
        if (this.results == null) {
            return;
        }
        if (size != 0) {
            int counter = 0;
            while (this.results.next()) {
                String[] field = new String[this.numcols];
                for (int j = 0; j < this.numcols; ++j) {
                    field[j] = this.results.getString(j + 1);
                }
                this.resultsTable.add(field);
                this.updateRowCount();
                if (++counter != size) continue;
                break;
            }
        }
    }

    private void updateRowCount() {
        ++this.numrows;
    }

    protected void finalize() {
        try {
            this.results.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Class<String> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.numcols;
    }

    @Override
    public String getColumnName(int columnIndex) {
        try {
            return this.rsMetadata.getColumnLabel(columnIndex + 1);
        }
        catch (SQLException sQLException) {
            return "<UNKNOWN>";
        }
    }

    @Override
    public int getRowCount() {
        return this.numrows;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String value;
        if (this.needFetchMore()) {
            this.checkNextRowAvailability(row);
        }
        if ((value = this.resultsTable.get(row)[column]) == null) {
            return "";
        }
        return value;
    }

    public boolean needFetchMore() {
        return this.fetchSizeLimit > 100;
    }

    private void checkNextRowAvailability(int currentRowNumber) {
        try {
            int nextRowNumber = currentRowNumber + this.getRowCount() / 4;
            if (nextRowNumber >= this.getRowCount()) {
                int remainder = this.fetchSizeLimit - this.getRowCount();
                int c = remainder / 100;
                if (c != 0) {
                    this.fetchRows(100);
                } else {
                    this.fetchRows(remainder);
                }
                this.fireModelChangedEvent();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listener.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listener.remove(l);
    }

    private void fireModelChangedEvent() {
        Iterator<TableModelListener> it = this.listener.iterator();
        while (it.hasNext()) {
            it.next().tableChanged(new TableModelEvent(this));
        }
    }
}

