/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui;

import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import org.apache.commons.rdf.api.IRI;

public class PredicateItem {
    private IRI iri;
    private final PredicateType predicateType;
    private PrefixManager prefixManager;

    public PredicateItem(IRI iri, PredicateType predicateType, PrefixManager pm) {
        this.iri = iri;
        this.predicateType = predicateType;
        this.prefixManager = pm;
    }

    public String getQualifiedName() {
        if (this.prefixManager != null) {
            String shortName = this.prefixManager.getShortForm(this.getFullName());
            if (shortName.startsWith(":")) {
                return shortName.substring(1, shortName.length());
            }
            return shortName;
        }
        return this.getFullName();
    }

    public IRI getSource() {
        return this.iri;
    }

    public String getFullName() {
        return this.iri.getIRIString();
    }

    public boolean isDataPropertyPredicate() {
        return this.predicateType == PredicateType.DATA_PROPERTY;
    }

    public boolean isObjectPropertyPredicate() {
        return this.predicateType == PredicateType.OBJECT_PROPERTY;
    }

    public PrefixManager getPrefixManager() {
        return this.prefixManager;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public static enum PredicateType {
        DATA_PROPERTY,
        OBJECT_PROPERTY,
        CLASS;

    }
}

