/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.model.vocabulary.Ontop;
import it.unibz.inf.ontop.protege.core.MutableOntologyVocabulary;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import org.apache.commons.rdf.api.IRI;

public class TargetQueryValidator {
    public static ImmutableList<IRI> validate(ImmutableList<TargetAtom> targetQuery, MutableOntologyVocabulary vocabulary) {
        return (ImmutableList)targetQuery.stream().map(TargetQueryValidator::extractIRI).filter(iri -> !TargetQueryValidator.isValid(iri, vocabulary)).collect(ImmutableCollectors.toList());
    }

    private static IRI extractIRI(TargetAtom targetAtom) {
        return (IRI)targetAtom.getPredicateIRI().orElseThrow(() -> new NoPredicateIRIInTargetAtomException(targetAtom));
    }

    public static boolean isValid(IRI iri, MutableOntologyVocabulary vocabulary) {
        return vocabulary.classes().contains(iri) || vocabulary.objectProperties().contains(iri) || vocabulary.dataProperties().contains(iri) || vocabulary.annotationProperties().contains(iri) || iri.equals((Object)OWL.SAME_AS) || iri.equals((Object)Ontop.CANONICAL_IRI);
    }

    private static class NoPredicateIRIInTargetAtomException
    extends OntopInternalBugException {
        private NoPredicateIRIInTargetAtomException(TargetAtom targetAtom) {
            super("No IRI could be found the predicate in the target atom " + targetAtom + "\nShould have detected before");
        }
    }
}

