/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.injection.OntopSystemOWLAPIConfiguration;
import it.unibz.inf.ontop.owlapi.OntopOWLFactory;
import it.unibz.inf.ontop.owlapi.OntopOWLReasoner;
import it.unibz.inf.ontop.owlapi.connection.OWLConnection;
import it.unibz.inf.ontop.owlapi.connection.OntopOWLConnection;
import it.unibz.inf.ontop.owlapi.connection.OntopOWLStatement;
import it.unibz.inf.ontop.owlapi.validation.QuestOWLEmptyEntitiesChecker;
import it.unibz.inf.ontop.protege.core.OntopConfigurationManager;
import it.unibz.inf.ontop.protege.core.OntopProtegeOWLConfiguration;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.owlapi.OWLAPITranslatorOWL2QL;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.impl.OWLReasonerBase;
import org.semanticweb.owlapi.util.Version;

public class OntopProtegeReasoner
extends OWLReasonerBase
implements AutoCloseable {
    private OntopOWLReasoner reasoner;
    private final OntopOWLFactory factory = OntopOWLFactory.defaultFactory();
    private final OntopConfigurationManager configurationManager;
    private OntopOWLConnection owlConnection;
    private final OWLAPITranslatorOWL2QL owlapiTranslator;

    protected OntopProtegeReasoner(OWLOntology rootOntology, OntopProtegeOWLConfiguration configuration) throws IllegalConfigurationException {
        super(rootOntology, (OWLReasonerConfiguration)configuration, BufferingMode.BUFFERING);
        this.owlapiTranslator = configuration.getOWLAPITranslator();
        this.reasoner = this.factory.createReasoner(rootOntology, (OWLReasonerConfiguration)configuration);
        this.configurationManager = configuration.getOntopConfigurationManager();
        this.owlConnection = this.reasoner.getConnection();
    }

    public OntopOWLStatement getStatement() throws OWLException {
        if (this.owlConnection == null) {
            this.owlConnection = this.reasoner.getConnection();
        }
        return this.owlConnection.createStatement();
    }

    @Nonnull
    public String getReasonerName() {
        return this.reasoner.getReasonerName();
    }

    @Nonnull
    public Version getReasonerVersion() {
        return this.reasoner.getReasonerVersion();
    }

    public void flush() {
        super.flush();
        try {
            this.reasoner = this.factory.createReasoner((OntopSystemOWLAPIConfiguration)this.configurationManager.buildOntopSQLOWLAPIConfiguration(this.getRootOntology()));
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }

    public void interrupt() {
        this.reasoner.interrupt();
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) {
        this.reasoner.precomputeInferences(inferenceTypes);
    }

    public boolean isPrecomputed(@Nonnull InferenceType inferenceType) {
        return this.reasoner.isPrecomputed(inferenceType);
    }

    @Nonnull
    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return this.reasoner.getPrecomputableInferenceTypes();
    }

    protected void handleChanges(@Nonnull Set<OWLAxiom> addAxioms, @Nonnull Set<OWLAxiom> removeAxioms) {
        this.reasoner.flush();
    }

    public boolean isConsistent() {
        return true;
    }

    public boolean isQuestConsistent() throws ReasonerInterruptedException, TimeOutException {
        return this.reasoner.isConsistent();
    }

    public Object getInconsistentAxiom() {
        return this.reasoner.getInconsistentAxiom();
    }

    public boolean isSatisfiable(@Nonnull OWLClassExpression classExpression) {
        return this.reasoner.isSatisfiable(classExpression);
    }

    @Nonnull
    public Node<OWLClass> getUnsatisfiableClasses() {
        return this.reasoner.getUnsatisfiableClasses();
    }

    public boolean isEntailed(@Nonnull OWLAxiom axiom) {
        return this.reasoner.isEntailed(axiom);
    }

    public boolean isEntailed(@Nonnull Set<? extends OWLAxiom> axioms) {
        return this.reasoner.isEntailed(axioms);
    }

    public boolean isEntailmentCheckingSupported(@Nonnull AxiomType<?> axiomType) {
        return this.reasoner.isEntailmentCheckingSupported(axiomType);
    }

    @Nonnull
    public Node<OWLClass> getTopClassNode() {
        return this.reasoner.getTopClassNode();
    }

    @Nonnull
    public Node<OWLClass> getBottomClassNode() {
        return this.reasoner.getBottomClassNode();
    }

    @Nonnull
    public NodeSet<OWLClass> getSubClasses(@Nonnull OWLClassExpression ce, boolean direct) {
        return this.reasoner.getSubClasses(ce, direct);
    }

    @Nonnull
    public NodeSet<OWLClass> getSuperClasses(@Nonnull OWLClassExpression ce, boolean direct) {
        return this.reasoner.getSuperClasses(ce, direct);
    }

    @Nonnull
    public Node<OWLClass> getEquivalentClasses(@Nonnull OWLClassExpression ce) {
        return this.reasoner.getEquivalentClasses(ce);
    }

    @Nonnull
    public NodeSet<OWLClass> getDisjointClasses(@Nonnull OWLClassExpression ce) {
        return this.reasoner.getDisjointClasses(ce);
    }

    @Nonnull
    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.reasoner.getTopObjectPropertyNode();
    }

    @Nonnull
    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.reasoner.getBottomObjectPropertyNode();
    }

    @Nonnull
    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(@Nonnull OWLObjectPropertyExpression pe, boolean direct) {
        return this.reasoner.getSubObjectProperties(pe, direct);
    }

    @Nonnull
    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(@Nonnull OWLObjectPropertyExpression pe, boolean direct) {
        return this.reasoner.getSuperObjectProperties(pe, direct);
    }

    @Nonnull
    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(@Nonnull OWLObjectPropertyExpression pe) {
        return this.reasoner.getEquivalentObjectProperties(pe);
    }

    @Nonnull
    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(@Nonnull OWLObjectPropertyExpression pe) {
        return this.reasoner.getDisjointObjectProperties(pe);
    }

    @Nonnull
    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(@Nonnull OWLObjectPropertyExpression pe) {
        return this.reasoner.getInverseObjectProperties(pe);
    }

    @Nonnull
    public NodeSet<OWLClass> getObjectPropertyDomains(@Nonnull OWLObjectPropertyExpression pe, boolean direct) {
        return this.reasoner.getObjectPropertyDomains(pe, direct);
    }

    @Nonnull
    public NodeSet<OWLClass> getObjectPropertyRanges(@Nonnull OWLObjectPropertyExpression pe, boolean direct) {
        return this.reasoner.getObjectPropertyRanges(pe, direct);
    }

    @Nonnull
    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return this.reasoner.getTopDataPropertyNode();
    }

    @Nonnull
    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.reasoner.getBottomDataPropertyNode();
    }

    @Nonnull
    public NodeSet<OWLDataProperty> getSubDataProperties(@Nonnull OWLDataProperty pe, boolean direct) {
        return this.reasoner.getSubDataProperties(pe, direct);
    }

    @Nonnull
    public NodeSet<OWLDataProperty> getSuperDataProperties(@Nonnull OWLDataProperty pe, boolean direct) {
        return this.reasoner.getSuperDataProperties(pe, direct);
    }

    @Nonnull
    public Node<OWLDataProperty> getEquivalentDataProperties(@Nonnull OWLDataProperty pe) {
        return this.reasoner.getEquivalentDataProperties(pe);
    }

    @Nonnull
    public NodeSet<OWLDataProperty> getDisjointDataProperties(@Nonnull OWLDataPropertyExpression pe) {
        return this.reasoner.getDisjointDataProperties(pe);
    }

    @Nonnull
    public NodeSet<OWLClass> getDataPropertyDomains(@Nonnull OWLDataProperty pe, boolean direct) {
        return this.reasoner.getDataPropertyDomains(pe, direct);
    }

    @Nonnull
    public NodeSet<OWLClass> getTypes(@Nonnull OWLNamedIndividual ind, boolean direct) {
        return this.reasoner.getTypes(ind, direct);
    }

    @Nonnull
    public NodeSet<OWLNamedIndividual> getInstances(@Nonnull OWLClassExpression ce, boolean direct) {
        return this.reasoner.getInstances(ce, direct);
    }

    @Nonnull
    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(@Nonnull OWLNamedIndividual ind, @Nonnull OWLObjectPropertyExpression pe) {
        return this.reasoner.getObjectPropertyValues(ind, pe);
    }

    @Nonnull
    public Set<OWLLiteral> getDataPropertyValues(@Nonnull OWLNamedIndividual ind, @Nonnull OWLDataProperty pe) {
        return this.reasoner.getDataPropertyValues(ind, pe);
    }

    @Nonnull
    public Node<OWLNamedIndividual> getSameIndividuals(@Nonnull OWLNamedIndividual ind) {
        return this.reasoner.getSameIndividuals(ind);
    }

    @Nonnull
    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(@Nonnull OWLNamedIndividual ind) {
        return this.reasoner.getDifferentIndividuals(ind);
    }

    @Override
    public void close() throws Exception {
        this.owlConnection.close();
        this.reasoner.close();
    }

    public QuestOWLEmptyEntitiesChecker getEmptyEntitiesChecker() throws Exception {
        OWLOntology rootOntology = this.getRootOntology();
        Ontology mergeOntology = this.owlapiTranslator.translateAndClassify(rootOntology);
        ClassifiedTBox tBox = mergeOntology.tbox();
        return new QuestOWLEmptyEntitiesChecker(tBox, (OWLConnection)this.owlConnection);
    }

    public OWLConnection replaceConnection() throws OntopConnectionException {
        OntopOWLConnection oldconn = this.owlConnection;
        this.owlConnection = this.reasoner.getConnection();
        return oldconn;
    }
}

