/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllConfiguration;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.injection.TargetQueryParserFactory;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.protege.core.DisposableProperties;
import it.unibz.inf.ontop.protege.core.MutablePrefixManager;
import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDAMappingListener;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelListener;
import it.unibz.inf.ontop.protege.core.OBDAModelManagerListener;
import it.unibz.inf.ontop.protege.core.OntopConfigurationManager;
import it.unibz.inf.ontop.protege.core.OntopReasonerInfo;
import it.unibz.inf.ontop.protege.core.TargetQueryValidator;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.JDBCConnectionManager;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQueryFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.converter.OldSyntaxMappingConverter;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.impl.OntopNativeMappingSerializer;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.querymanager.QueryController;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerEntity;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerGroup;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerListener;
import it.unibz.inf.ontop.utils.querymanager.QueryControllerQuery;
import it.unibz.inf.ontop.utils.querymanager.QueryIOManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.RDF;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerInfo;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.semanticweb.owlapi.change.AddImportData;
import org.semanticweb.owlapi.change.RemoveImportData;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBDAModelManager
implements Disposable {
    private static final String OBDA_EXT = ".obda";
    private static final String QUERY_EXT = ".q";
    private static final String PROPERTY_EXT = ".properties";
    private static final String DBPREFS_EXT = ".db_prefs";
    private final OWLEditorKit owlEditorKit;
    private final OWLOntologyManager mmgr;
    private final TermFactory termFactory;
    private final TypeFactory typeFactory;
    private QueryController queryController;
    private final OBDAModel obdaModel;
    private final List<OBDAModelManagerListener> obdaManagerListeners;
    private final JDBCConnectionManager connectionManager = JDBCConnectionManager.getJDBCConnectionManager();
    private final OntopConfigurationManager configurationManager;
    private static final Logger log = LoggerFactory.getLogger(OBDAModelManager.class);
    private final RDF rdfFactory;
    private final OWLModelManagerListener modelManagerListener = new OBDAPluginOWLModelManagerListener();
    private final ProtegeQueryControllerListener qlistener = new ProtegeQueryControllerListener();
    private final ProtegeMappingControllerListener mlistener = new ProtegeMappingControllerListener();
    private final ProtegeDatasourcesControllerListener dlistener = new ProtegeDatasourcesControllerListener();
    private boolean loadingData;
    private Optional<OWLOntologyID> lastKnownOntologyId;
    private final AtomFactory atomFactory;
    private final TargetAtomFactory targetAtomFactory;

    public OBDAModelManager(EditorKit editorKit) {
        Injector defaultInjector = ((OntopMappingSQLAllConfiguration.Builder)((OntopMappingSQLAllConfiguration.Builder)((OntopMappingSQLAllConfiguration.Builder)((OntopMappingSQLAllConfiguration.Builder)OntopMappingSQLAllConfiguration.defaultBuilder().jdbcDriver("")).jdbcUrl("")).jdbcUser("")).jdbcPassword("")).build().getInjector();
        SpecificationFactory specificationFactory = (SpecificationFactory)defaultInjector.getInstance(SpecificationFactory.class);
        SQLPPMappingFactory ppMappingFactory = (SQLPPMappingFactory)defaultInjector.getInstance(SQLPPMappingFactory.class);
        this.atomFactory = (AtomFactory)defaultInjector.getInstance(AtomFactory.class);
        this.termFactory = (TermFactory)defaultInjector.getInstance(TermFactory.class);
        this.typeFactory = (TypeFactory)defaultInjector.getInstance(TypeFactory.class);
        this.targetAtomFactory = (TargetAtomFactory)defaultInjector.getInstance(TargetAtomFactory.class);
        this.rdfFactory = (RDF)defaultInjector.getInstance(RDF.class);
        TargetAtomFactory targetAtomFactory = (TargetAtomFactory)defaultInjector.getInstance(TargetAtomFactory.class);
        SubstitutionFactory substitutionFactory = (SubstitutionFactory)defaultInjector.getInstance(SubstitutionFactory.class);
        TargetQueryParserFactory targetQueryParserFactory = (TargetQueryParserFactory)defaultInjector.getInstance(TargetQueryParserFactory.class);
        SQLPPSourceQueryFactory sourceQueryFactory = (SQLPPSourceQueryFactory)defaultInjector.getInstance(SQLPPSourceQueryFactory.class);
        this.lastKnownOntologyId = Optional.empty();
        if (!(editorKit instanceof OWLEditorKit)) {
            throw new IllegalArgumentException("The OBDA Plugin only works with OWLEditorKit instances.");
        }
        this.owlEditorKit = (OWLEditorKit)editorKit;
        OWLModelManager modelManager = this.owlEditorKit.getModelManager();
        this.mmgr = modelManager.getOWLOntologyManager();
        OWLModelManager owlmmgr = (OWLModelManager)editorKit.getModelManager();
        owlmmgr.addListener(this.modelManagerListener);
        this.obdaManagerListeners = new ArrayList<OBDAModelManagerListener>();
        this.mmgr.addOntologyChangeListener((OWLOntologyChangeListener)new OntologyRefactoringListener());
        this.queryController = new QueryController();
        PrefixDocumentFormat prefixFormat = PrefixUtilities.getPrefixOWLOntologyFormat((OWLOntology)modelManager.getActiveOntology());
        this.obdaModel = new OBDAModel(ppMappingFactory, prefixFormat, this.atomFactory, this.termFactory, this.typeFactory, targetAtomFactory, substitutionFactory, this.rdfFactory, targetQueryParserFactory, sourceQueryFactory);
        this.obdaModel.addSourceListener(this.dlistener);
        this.obdaModel.addMappingsListener(this.mlistener);
        this.queryController.addListener((QueryControllerListener)this.qlistener);
        DisposableProperties settings = (DisposableProperties)this.owlEditorKit.get((Object)DisposableProperties.class.getName());
        this.configurationManager = new OntopConfigurationManager(this.obdaModel, settings);
    }

    public OntopConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    private org.apache.commons.rdf.api.IRI getIRI(OWLEntity entity) {
        return this.rdfFactory.createIRI(entity.getIRI().toString());
    }

    public void addListener(OBDAModelManagerListener listener) {
        this.obdaManagerListeners.add(listener);
    }

    public void removeListener(OBDAModelManagerListener listener) {
        this.obdaManagerListeners.remove(listener);
    }

    public OBDAModel getActiveOBDAModel() {
        return this.obdaModel;
    }

    public QueryController getQueryController() {
        if (this.queryController == null) {
            this.queryController = new QueryController();
        }
        return this.queryController;
    }

    private void loadVocabularyAndDefaultPrefix(OBDAModel obdaModel, Set<OWLOntology> ontologies, OWLOntology activeOntology) {
        for (OWLOntology ontology : ontologies) {
            for (OWLClass c : ontology.getClassesInSignature()) {
                obdaModel.getCurrentVocabulary().classes().declare(this.getIRI((OWLEntity)c));
            }
            for (OWLObjectProperty r : ontology.getObjectPropertiesInSignature()) {
                obdaModel.getCurrentVocabulary().objectProperties().declare(this.getIRI((OWLEntity)r));
            }
            for (OWLDataProperty p : ontology.getDataPropertiesInSignature()) {
                obdaModel.getCurrentVocabulary().dataProperties().declare(this.getIRI((OWLEntity)p));
            }
            for (OWLDataProperty p : ontology.getAnnotationPropertiesInSignature()) {
                obdaModel.getCurrentVocabulary().annotationProperties().declare(this.getIRI((OWLEntity)p));
            }
        }
        this.updateDefaultPrefixNamespace(obdaModel, activeOntology);
    }

    private void updateDefaultPrefixNamespace(OBDAModel obdaModel, OWLOntology ontology) {
        Optional<String> ns = MutablePrefixManager.getDeclaredDefaultPrefixNamespace(ontology);
        if (ns.isPresent()) {
            obdaModel.setExplicitDefaultPrefixNamespace(ns.get());
        } else {
            MutablePrefixManager.generateDefaultPrefixNamespaceFromID(ontology.getOntologyID()).ifPresent(id -> obdaModel.addPrefix(":", (String)id));
        }
    }

    public void fireActiveOBDAModelChange() {
        for (OBDAModelManagerListener listener : this.obdaManagerListeners) {
            try {
                listener.activeOntologyChanged();
            }
            catch (Exception e) {
                log.debug("Badly behaved listener: {}", (Object)listener.getClass().toString());
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void triggerOntologyChanged() {
        if (this.loadingData) {
            return;
        }
        OWLModelManager owlmm = this.owlEditorKit.getOWLModelManager();
        OWLOntology ontology = owlmm.getActiveOntology();
        if (ontology == null) {
            return;
        }
        OWLClass newClass = owlmm.getOWLDataFactory().getOWLClass(IRI.create((String)"http://www.unibz.it/inf/obdaplugin#RandomClass6677841155"));
        OWLDeclarationAxiom axiom = owlmm.getOWLDataFactory().getOWLDeclarationAxiom((OWLEntity)newClass);
        try {
            AddAxiom addChange = new AddAxiom(ontology, (OWLAxiom)axiom);
            owlmm.applyChange((OWLOntologyChange)addChange);
            RemoveAxiom removeChange = new RemoveAxiom(ontology, (OWLAxiom)axiom);
            owlmm.applyChange((OWLOntologyChange)removeChange);
        }
        catch (Exception e) {
            log.warn("Exception forcing an ontology change. Your OWL model might contain a new class that you need to remove manually: {}", (Object)newClass.getIRI());
            log.warn(e.getMessage());
            log.debug(e.getMessage(), (Throwable)e);
        }
    }

    public void dispose() {
        try {
            this.owlEditorKit.getModelManager().removeListener(this.getModelManagerListener());
            this.connectionManager.dispose();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    protected OWLModelManagerListener getModelManagerListener() {
        return this.modelManagerListener;
    }

    private class ProtegeQueryControllerListener
    implements QueryControllerListener {
        private static final long serialVersionUID = 4536639410306364312L;

        private ProtegeQueryControllerListener() {
        }

        public void elementAdded(QueryControllerEntity element) {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        public void elementAdded(QueryControllerQuery query, QueryControllerGroup group) {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        public void elementRemoved(QueryControllerEntity element) {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        public void elementRemoved(QueryControllerQuery query, QueryControllerGroup group) {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        public void elementChanged(QueryControllerQuery query) {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        public void elementChanged(QueryControllerQuery query, QueryControllerGroup group) {
            OBDAModelManager.this.triggerOntologyChanged();
        }
    }

    private class ProtegeMappingControllerListener
    implements OBDAMappingListener {
        private static final long serialVersionUID = -5794145688669702879L;

        private ProtegeMappingControllerListener() {
        }

        @Override
        public void allMappingsRemoved() {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        @Override
        public void currentSourceChanged(URI oldsrcuri, URI newsrcuri) {
        }

        @Override
        public void mappingDeleted(URI srcuri) {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        @Override
        public void mappingInserted(URI srcuri) {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        @Override
        public void mappingUpdated() {
            OBDAModelManager.this.triggerOntologyChanged();
        }
    }

    private class ProtegeDatasourcesControllerListener
    implements OBDAModelListener {
        private static final long serialVersionUID = -1633463551656406417L;

        private ProtegeDatasourcesControllerListener() {
        }

        @Override
        public void datasourceUpdated(String oldname, OBDADataSource currendata) {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        @Override
        public void datasourceDeleted(OBDADataSource source) {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        @Override
        public void datasourceAdded(OBDADataSource source) {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        @Override
        public void alldatasourcesDeleted() {
            OBDAModelManager.this.triggerOntologyChanged();
        }

        @Override
        public void datasourceParametersUpdated() {
            OBDAModelManager.this.triggerOntologyChanged();
        }
    }

    private class OBDAPluginOWLModelManagerListener
    implements OWLModelManagerListener {
        boolean initializing = false;

        private OBDAPluginOWLModelManagerListener() {
        }

        public void handleChange(OWLModelManagerChangeEvent event) {
            OWLModelManager source = event.getSource();
            OWLOntology activeOntology = source.getActiveOntology();
            EventType eventType = event.getType();
            switch (eventType) {
                case ABOUT_TO_CLASSIFY: {
                    log.debug("ABOUT TO CLASSIFY");
                    OBDAModelManager.this.loadingData = true;
                    break;
                }
                case ENTITY_RENDERER_CHANGED: {
                    log.debug("RENDERER CHANGED");
                    break;
                }
                case ONTOLOGY_CLASSIFIED: {
                    OBDAModelManager.this.loadingData = false;
                    break;
                }
                case ACTIVE_ONTOLOGY_CHANGED: {
                    log.debug("ACTIVE ONTOLOGY CHANGED");
                    OWLOntologyID id = activeOntology.getOntologyID();
                    if (OBDAModelManager.this.lastKnownOntologyId.filter(last -> last.equals((Object)id)).isPresent()) break;
                    OBDAModelManager.this.lastKnownOntologyId = Optional.of(id);
                    this.handleNewActiveOntology();
                    break;
                }
                case ENTITY_RENDERING_CHANGED: {
                    break;
                }
                case ONTOLOGY_CREATED: {
                    log.debug("ONTOLOGY CREATED");
                    break;
                }
                case ONTOLOGY_LOADED: 
                case ONTOLOGY_RELOADED: {
                    log.debug("ONTOLOGY LOADED/RELOADED");
                    this.handleOntologyLoadedAndReLoaded(source, activeOntology);
                    break;
                }
                case ONTOLOGY_SAVED: {
                    log.debug("ONTOLOGY SAVED");
                    this.handleOntologySaved(source, activeOntology);
                    break;
                }
                case ONTOLOGY_VISIBILITY_CHANGED: {
                    log.debug("ONTOLOGY VISIBILITY CHANGED");
                    break;
                }
                case REASONER_CHANGED: {
                    log.info("REASONER CHANGED");
                }
            }
        }

        private void handleNewActiveOntology() {
            this.initializing = true;
            OWLModelManager mmgr = OBDAModelManager.this.owlEditorKit.getOWLWorkspace().getOWLModelManager();
            OWLOntology ontology = mmgr.getActiveOntology();
            PrefixDocumentFormat owlPrefixManager = PrefixUtilities.getPrefixOWLOntologyFormat((OWLOntology)ontology);
            OBDAModelManager.this.obdaModel.reset(owlPrefixManager);
            OBDAModelManager.this.loadVocabularyAndDefaultPrefix(OBDAModelManager.this.obdaModel, mmgr.getOntologies(), ontology);
            OBDAModelManager.this.configurationManager.clearImplicitDBConstraintFile();
            DisposableProperties settings = (DisposableProperties)OBDAModelManager.this.owlEditorKit.get((Object)DisposableProperties.class.getName());
            OBDAModelManager.this.configurationManager.resetProperties(settings.clone());
            ProtegeOWLReasonerInfo factory = OBDAModelManager.this.owlEditorKit.getOWLModelManager().getOWLReasonerManager().getCurrentReasonerFactory();
            if (factory instanceof OntopReasonerInfo) {
                OntopReasonerInfo questfactory = (OntopReasonerInfo)factory;
                questfactory.setConfigurationGenerator(OBDAModelManager.this.configurationManager);
            }
            OBDAModelManager.this.fireActiveOBDAModelChange();
            this.initializing = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleOntologyLoadedAndReLoaded(OWLModelManager owlModelManager, OWLOntology activeOntology) {
            OBDAModelManager.this.loadingData = true;
            try {
                IRI documentIRI = owlModelManager.getOWLOntologyManager().getOntologyDocumentIRI(activeOntology);
                if (!UIUtil.isLocalFile((URI)documentIRI.toURI())) {
                    return;
                }
                String owlDocumentIriString = documentIRI.toString();
                int i = owlDocumentIriString.lastIndexOf(".");
                String owlName = owlDocumentIriString.substring(0, i);
                String obdaDocumentIri = owlName + OBDAModelManager.OBDA_EXT;
                String queryDocumentIri = owlName + OBDAModelManager.QUERY_EXT;
                String propertyFilePath = owlName + OBDAModelManager.PROPERTY_EXT;
                String implicitDBConstraintFilePath = owlName + OBDAModelManager.DBPREFS_EXT;
                File obdaFile = new File(URI.create(obdaDocumentIri));
                File queryFile = new File(URI.create(queryDocumentIri));
                File propertyFile = new File(URI.create(propertyFilePath));
                File implicitDBConstraintFile = new File(URI.create(implicitDBConstraintFilePath));
                if (implicitDBConstraintFile.exists()) {
                    OBDAModelManager.this.configurationManager.setImplicitDBConstraintFile(implicitDBConstraintFile);
                }
                if (propertyFile.exists()) {
                    OBDAModelManager.this.configurationManager.loadPropertyFile(propertyFile);
                }
                if (obdaFile.exists()) {
                    try {
                        Reader mappingReader = new FileReader(obdaFile);
                        OldSyntaxMappingConverter converter = new OldSyntaxMappingConverter(new FileReader(obdaFile), obdaFile.getName());
                        Optional<Properties> optionalDataSourceProperties = converter.getOBDADataSourceProperties();
                        if (optionalDataSourceProperties.isPresent()) {
                            OBDAModelManager.this.configurationManager.loadProperties(optionalDataSourceProperties.get());
                            mappingReader = converter.getOutputReader();
                        }
                        OBDAModelManager.this.obdaModel.parseMapping(mappingReader, OBDAModelManager.this.configurationManager.snapshotProperties());
                    }
                    catch (Exception ex) {
                        throw new Exception("Exception occurred while loading OBDA document: " + obdaFile + "\n\n" + ex.getMessage());
                    }
                    try {
                        QueryIOManager queryIO = new QueryIOManager(OBDAModelManager.this.queryController);
                        queryIO.load(queryFile);
                    }
                    catch (Exception ex) {
                        OBDAModelManager.this.queryController.reset();
                        throw new Exception("Exception occurred while loading Query document: " + queryFile + "\n\n" + ex.getMessage());
                    }
                }
                log.warn("No OBDA model was loaded because no .obda file exists in the same location as the .owl file");
                for (SQLPPTriplesMap mapping : OBDAModelManager.this.obdaModel.generatePPMapping().getTripleMaps()) {
                    ImmutableList tq = mapping.getTargetAtoms();
                    ImmutableList<org.apache.commons.rdf.api.IRI> invalidIRIs = TargetQueryValidator.validate((ImmutableList<TargetAtom>)tq, OBDAModelManager.this.obdaModel.getCurrentVocabulary());
                    if (invalidIRIs.isEmpty()) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Found an invalid target query: \n  ");
                    stringBuilder.append("mappingId:\t").append(mapping.getId());
                    if (mapping.getOptionalTargetString().isPresent()) {
                        stringBuilder.append("\n  target:\t").append((String)mapping.getOptionalTargetString().get());
                    }
                    stringBuilder.append("\n  predicates not declared in the ontology: ").append(invalidIRIs);
                    String message = stringBuilder.toString();
                    throw new Exception(message);
                }
            }
            catch (Exception e) {
                InvalidOntopConfigurationException ex = new InvalidOntopConfigurationException("An exception has occurred when loading input file.\nMessage: " + e.getMessage());
                DialogUtils.showQuickErrorDialog(null, (Exception)ex, "Open file error");
                log.error(e.getMessage());
            }
            finally {
                OBDAModelManager.this.loadingData = false;
                OBDAModelManager.this.fireActiveOBDAModelChange();
            }
        }

        private void handleOntologySaved(OWLModelManager owlModelManager, OWLOntology activeOntology) {
            try {
                IRI documentIRI = owlModelManager.getOWLOntologyManager().getOntologyDocumentIRI(activeOntology);
                String owlDocumentIriString = documentIRI.toString();
                if (!UIUtil.isLocalFile((URI)documentIRI.toURI())) {
                    return;
                }
                int i = owlDocumentIriString.lastIndexOf(".");
                String owlName = owlDocumentIriString.substring(0, i);
                String obdaDocumentIri = owlName + OBDAModelManager.OBDA_EXT;
                String queryDocumentIri = owlName + OBDAModelManager.QUERY_EXT;
                File obdaFile = new File(URI.create(obdaDocumentIri));
                if (OBDAModelManager.this.obdaModel.hasTripleMaps()) {
                    SQLPPMapping ppMapping = OBDAModelManager.this.obdaModel.generatePPMapping();
                    OntopNativeMappingSerializer writer = new OntopNativeMappingSerializer(ppMapping);
                    writer.save(obdaFile);
                    log.info("mapping file saved to {}", (Object)obdaFile);
                } else {
                    Files.deleteIfExists(obdaFile.toPath());
                }
                if (!OBDAModelManager.this.queryController.getElements().isEmpty()) {
                    File queryFile = new File(URI.create(queryDocumentIri));
                    QueryIOManager queryIO = new QueryIOManager(OBDAModelManager.this.queryController);
                    queryIO.save(queryFile);
                    log.info("query file saved to {}", (Object)queryFile);
                }
                String propertyFilePath = owlName + OBDAModelManager.PROPERTY_EXT;
                File propertyFile = new File(URI.create(propertyFilePath));
                Properties properties = OBDAModelManager.this.configurationManager.snapshotUserProperties();
                if (properties.entrySet().stream().anyMatch(e -> !e.getKey().equals("jdbc.name") && !e.getValue().equals(""))) {
                    FileOutputStream outputStream = new FileOutputStream(propertyFile);
                    properties.store(outputStream, null);
                    outputStream.flush();
                    outputStream.close();
                    log.info("Property file saved to {}", (Object)propertyFilePath);
                } else {
                    Files.deleteIfExists(propertyFile.toPath());
                }
            }
            catch (Exception e2) {
                log.error(e2.getMessage());
                Exception newException = new Exception("Error saving the OBDA file. Closing Protege now can result in losing changes in your data sources or mappings. Please resolve the issue that prevents saving in the current location, or do \"Save as..\" to save in an alternative location. \n\nThe error message was: \n" + e2.getMessage());
                DialogUtils.showQuickErrorDialog(null, newException, "Error saving OBDA file");
                OBDAModelManager.this.triggerOntologyChanged();
            }
        }
    }

    public class OntologyRefactoringListener
    implements OWLOntologyChangeListener {
        public void ontologiesChanged(@Nonnull List<? extends OWLOntologyChange> changes) {
            HashMap<OWLEntity, OWLEntity> renamings = new HashMap<OWLEntity, OWLEntity>();
            HashSet<OWLEntity> removals = new HashSet<OWLEntity>();
            for (int idx = 0; changes.size() > idx; ++idx) {
                OWLDeclarationAxiom declaration;
                OWLEntity removedEntity;
                OWLAnnotationProperty ap;
                OWLDataProperty op;
                OWLObjectProperty or;
                OWLClass oc;
                OBDAModel activeOBDAModel;
                OWLEntity entity;
                OWLAxiom axiom;
                OBDAModel activeOBDAModel2;
                OWLOntologyChange change = changes.get(idx);
                if (change instanceof SetOntologyID) {
                    log.debug("Ontology ID changed");
                    log.debug("Old ID: {}", (Object)((SetOntologyID)change).getOriginalOntologyID());
                    OWLOntologyID newID = ((SetOntologyID)change).getNewOntologyID();
                    log.debug("New ID: {}", (Object)newID);
                    if (OBDAModelManager.this.obdaModel.getExplicitDefaultPrefixNamespace().isPresent()) continue;
                    MutablePrefixManager.generateDefaultPrefixNamespaceFromID(newID).ifPresent(id -> OBDAModelManager.this.obdaModel.addPrefix(":", (String)id));
                    continue;
                }
                if (change instanceof AddImport) {
                    AddImportData addedImport = ((AddImport)change).getChangeData();
                    IRI addedOntoIRI = addedImport.getDeclaration().getIRI();
                    OWLOntology addedOnto = OBDAModelManager.this.mmgr.getOntology(addedOntoIRI);
                    activeOBDAModel2 = OBDAModelManager.this.getActiveOBDAModel();
                    for (OWLClass c : addedOnto.getClassesInSignature()) {
                        activeOBDAModel2.getCurrentVocabulary().classes().declare(OBDAModelManager.this.getIRI((OWLEntity)c));
                    }
                    for (OWLObjectProperty r : addedOnto.getObjectPropertiesInSignature()) {
                        activeOBDAModel2.getCurrentVocabulary().objectProperties().declare(OBDAModelManager.this.getIRI((OWLEntity)r));
                    }
                    for (OWLDataProperty p : addedOnto.getDataPropertiesInSignature()) {
                        activeOBDAModel2.getCurrentVocabulary().dataProperties().declare(OBDAModelManager.this.getIRI((OWLEntity)p));
                    }
                    for (OWLDataProperty p : addedOnto.getAnnotationPropertiesInSignature()) {
                        activeOBDAModel2.getCurrentVocabulary().annotationProperties().declare(OBDAModelManager.this.getIRI((OWLEntity)p));
                    }
                    continue;
                }
                if (change instanceof RemoveImport) {
                    RemoveImportData removedImport = ((RemoveImport)change).getChangeData();
                    IRI removedOntoIRI = removedImport.getDeclaration().getIRI();
                    OWLOntology removedOnto = OBDAModelManager.this.mmgr.getOntology(removedOntoIRI);
                    activeOBDAModel2 = OBDAModelManager.this.getActiveOBDAModel();
                    for (OWLClass c : removedOnto.getClassesInSignature()) {
                        activeOBDAModel2.getCurrentVocabulary().classes().remove(OBDAModelManager.this.getIRI((OWLEntity)c));
                    }
                    for (OWLObjectProperty r : removedOnto.getObjectPropertiesInSignature()) {
                        activeOBDAModel2.getCurrentVocabulary().objectProperties().remove(OBDAModelManager.this.getIRI((OWLEntity)r));
                    }
                    for (OWLDataProperty p : removedOnto.getDataPropertiesInSignature()) {
                        activeOBDAModel2.getCurrentVocabulary().dataProperties().remove(OBDAModelManager.this.getIRI((OWLEntity)p));
                    }
                    for (OWLDataProperty p : removedOnto.getAnnotationPropertiesInSignature()) {
                        activeOBDAModel2.getCurrentVocabulary().annotationProperties().remove(OBDAModelManager.this.getIRI((OWLEntity)p));
                    }
                    continue;
                }
                if (change instanceof AddAxiom) {
                    axiom = change.getAxiom();
                    if (axiom instanceof OWLDeclarationAxiom) {
                        entity = ((OWLDeclarationAxiom)axiom).getEntity();
                        activeOBDAModel = OBDAModelManager.this.getActiveOBDAModel();
                        if (entity instanceof OWLClass) {
                            oc = (OWLClass)entity;
                            activeOBDAModel.getCurrentVocabulary().classes().declare(OBDAModelManager.this.getIRI((OWLEntity)oc));
                        } else if (entity instanceof OWLObjectProperty) {
                            or = (OWLObjectProperty)entity;
                            activeOBDAModel.getCurrentVocabulary().objectProperties().declare(OBDAModelManager.this.getIRI((OWLEntity)or));
                        } else if (entity instanceof OWLDataProperty) {
                            op = (OWLDataProperty)entity;
                            activeOBDAModel.getCurrentVocabulary().dataProperties().declare(OBDAModelManager.this.getIRI((OWLEntity)op));
                        } else if (entity instanceof OWLAnnotationProperty) {
                            ap = (OWLAnnotationProperty)entity;
                            activeOBDAModel.getCurrentVocabulary().annotationProperties().declare(OBDAModelManager.this.getIRI((OWLEntity)ap));
                        }
                    }
                } else if (change instanceof RemoveAxiom && (axiom = change.getAxiom()) instanceof OWLDeclarationAxiom) {
                    entity = ((OWLDeclarationAxiom)axiom).getEntity();
                    activeOBDAModel = OBDAModelManager.this.getActiveOBDAModel();
                    if (entity instanceof OWLClass) {
                        oc = (OWLClass)entity;
                        activeOBDAModel.getCurrentVocabulary().classes().remove(OBDAModelManager.this.getIRI((OWLEntity)oc));
                    } else if (entity instanceof OWLObjectProperty) {
                        or = (OWLObjectProperty)entity;
                        activeOBDAModel.getCurrentVocabulary().objectProperties().remove(OBDAModelManager.this.getIRI((OWLEntity)or));
                    } else if (entity instanceof OWLDataProperty) {
                        op = (OWLDataProperty)entity;
                        activeOBDAModel.getCurrentVocabulary().dataProperties().remove(OBDAModelManager.this.getIRI((OWLEntity)op));
                    } else if (entity instanceof OWLAnnotationProperty) {
                        ap = (OWLAnnotationProperty)entity;
                        activeOBDAModel.getCurrentVocabulary().annotationProperties().remove(OBDAModelManager.this.getIRI((OWLEntity)ap));
                    }
                }
                if (idx + 1 < changes.size() && change instanceof RemoveAxiom && changes.get(idx + 1) instanceof AddAxiom) {
                    RemoveAxiom remove = (RemoveAxiom)change;
                    AddAxiom add = (AddAxiom)changes.get(idx + 1);
                    if (!(remove.getAxiom() instanceof OWLDeclarationAxiom) || !(add.getAxiom() instanceof OWLDeclarationAxiom)) continue;
                    OWLEntity olde = ((OWLDeclarationAxiom)remove.getAxiom()).getEntity();
                    OWLEntity newe = ((OWLDeclarationAxiom)add.getAxiom()).getEntity();
                    renamings.put(olde, newe);
                    continue;
                }
                if (!(change instanceof RemoveAxiom) || !(change.getAxiom() instanceof OWLDeclarationAxiom) || (removedEntity = (declaration = (OWLDeclarationAxiom)change.getAxiom()).getEntity()).getIRI().toQuotedString().equals("<http://www.unibz.it/inf/obdaplugin#RandomClass6677841155>")) continue;
                removals.add(removedEntity);
            }
            OBDAModel obdamodel = OBDAModelManager.this.getActiveOBDAModel();
            for (OWLEntity olde : renamings.keySet()) {
                OWLEntity newEntity = (OWLEntity)renamings.get(olde);
                org.apache.commons.rdf.api.IRI removedIRI = OBDAModelManager.this.getIRI(olde);
                org.apache.commons.rdf.api.IRI newIRI = OBDAModelManager.this.getIRI(newEntity);
                obdamodel.changePredicateIri(removedIRI, newIRI);
            }
            for (OWLEntity removede : removals) {
                org.apache.commons.rdf.api.IRI removedIRI = OBDAModelManager.this.getIRI(removede);
                obdamodel.deletePredicateIRI(removedIRI);
            }
        }
    }
}

