/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.answering.connection.pool.JDBCConnectionPool;
import it.unibz.inf.ontop.answering.connection.pool.impl.ConnectionGenerator;
import it.unibz.inf.ontop.protege.core.DisposableOBDAPreferences;
import it.unibz.inf.ontop.protege.core.DisposableProperties;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.spec.mapping.pp.impl.SQLPPMappingImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.plugin.EditorKitHook;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.OWLEditorKit;

public class OBDAEditorKitSynchronizerPlugin
extends EditorKitHook {
    OBDAModelManager instance = null;
    OWLEditorKit kit = null;
    DisposableOBDAPreferences obdaPref = null;
    DisposableProperties reasonerPref = null;

    protected void setup(EditorKit editorKit) {
        super.setup(editorKit);
    }

    public void initialise() throws Exception {
        this.obdaPref = new DisposableOBDAPreferences();
        this.getEditorKit().put((Object)DisposableOBDAPreferences.class.getName(), (Disposable)this.obdaPref);
        this.reasonerPref = new DisposableProperties();
        this.getEditorKit().put((Object)DisposableProperties.class.getName(), (Disposable)this.reasonerPref);
        this.loadPreferences();
        this.instance = new OBDAModelManager(this.getEditorKit());
        this.getEditorKit().put((Object)OBDAEditorKitSynchronizerPlugin.class.getName(), (Disposable)this);
        this.kit = (OWLEditorKit)this.getEditorKit();
        this.getEditorKit().put((Object)OBDAModelManager.class.getName(), (Disposable)this.instance);
        this.getEditorKit().put((Object)SQLPPMappingImpl.class.getName(), (Disposable)this.instance);
        this.loadPreferences();
    }

    public void dispose() throws Exception {
        this.storePreferences();
        this.instance.dispose();
    }

    private void loadPreferences() {
        PreferencesManager man = PreferencesManager.getInstance();
        Preferences pref = man.getApplicationPreferences("OBDA Plugin");
        List<String> keys = this.obdaPref.getOBDAPreferenceKeys();
        for (String key : keys) {
            String value = pref.getString(key, null);
            if (value == null) continue;
            this.obdaPref.put(key, value);
        }
        keys = this.reasonerPref.getReformulationPlatformPreferencesKeys();
        Iterator<String> it = keys.iterator();
        boolean isCalssic = false;
        while (it.hasNext()) {
            String key = it.next();
            String value = pref.getString(key, null);
            if (value == null) continue;
            if (key.equals("org.obda.owlreformulationplatform.aboxmode") && value.equals("classic")) {
                this.reasonerPref.put(key, value);
                isCalssic = true;
                continue;
            }
            this.reasonerPref.put(key, value);
        }
        this.reasonerPref.put(JDBCConnectionPool.class.getCanonicalName(), ConnectionGenerator.class.getCanonicalName());
        this.getEditorKit().put((Object)DisposableProperties.class.getName(), (Disposable)this.reasonerPref);
    }

    private void storePreferences() {
        Object value;
        PreferencesManager man = PreferencesManager.getInstance();
        Preferences pref = man.getApplicationPreferences("OBDA Plugin");
        Set<Object> keys = this.obdaPref.keySet();
        for (Object key : keys) {
            value = this.obdaPref.get(key);
            pref.putString(key.toString(), value.toString());
        }
        keys = this.reasonerPref.keySet();
        for (Object key : keys) {
            value = this.reasonerPref.get(key);
            pref.putString(key.toString(), value.toString());
        }
    }
}

