/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.spec.mapping.impl.AbstractPrefixManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.protege.editor.owl.model.entity.EntityCreationPreferences;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.OWLOntologyXMLNamespaceManager;

public class MutablePrefixManager
extends AbstractPrefixManager {
    private PrefixDocumentFormat owlmapper;

    MutablePrefixManager(PrefixDocumentFormat owlmapper) {
        this.owlmapper = owlmapper;
    }

    public String getDefaultPrefix() {
        return super.getDefaultPrefix();
    }

    public Optional<String> getPrefix(String uri) {
        return this.owlmapper.getPrefixName2PrefixMap().entrySet().stream().filter(e -> ((String)e.getValue()).equals(uri)).map(Map.Entry::getKey).findFirst();
    }

    public ImmutableMap<String, String> getPrefixMap() {
        return ImmutableMap.copyOf((Map)this.owlmapper.getPrefixName2PrefixMap());
    }

    public String getURIDefinition(String prefix) {
        return this.owlmapper.getPrefix(prefix);
    }

    public boolean contains(String prefix) {
        return this.owlmapper.containsPrefixMapping(prefix);
    }

    void addPrefix(String name, String uri) {
        this.owlmapper.setPrefix(name, uri);
    }

    public void clear() {
        this.owlmapper.clear();
    }

    public List<String> getOrderedNamespaces() {
        ArrayList<String> namespaceList = new ArrayList<String>((Collection<String>)this.getPrefixMap().values());
        Collections.sort(namespaceList, Collections.reverseOrder());
        return namespaceList;
    }

    void addPrefixes(ImmutableMap<String, String> prefixMap) {
        prefixMap.forEach((key, value) -> this.owlmapper.setPrefix(key, value));
    }

    static Optional<String> getDeclaredDefaultPrefixNamespace(OWLOntology ontology) {
        OWLOntologyXMLNamespaceManager nsm = new OWLOntologyXMLNamespaceManager(ontology, ontology.getOWLOntologyManager().getOntologyFormat(ontology));
        if (StreamSupport.stream(nsm.getPrefixes().spliterator(), false).anyMatch(p -> p.equals(""))) {
            return Optional.of(nsm.getNamespaceForPrefix(""));
        }
        return Optional.empty();
    }

    static Optional<String> generateDefaultPrefixNamespaceFromID(OWLOntologyID ontologyID) {
        com.google.common.base.Optional ontologyIRI = ontologyID.getOntologyIRI();
        return ontologyIRI.isPresent() ? Optional.of(MutablePrefixManager.getProperPrefixURI(((IRI)ontologyIRI.get()).toString())) : Optional.empty();
    }

    private static String getProperPrefixURI(String prefixUri) {
        String defaultSeparator;
        if (!(prefixUri.endsWith("#") || prefixUri.endsWith("/") || prefixUri.endsWith(defaultSeparator = EntityCreationPreferences.getDefaultSeparator()))) {
            prefixUri = prefixUri + defaultSeparator;
        }
        return prefixUri;
    }
}

