package it.unibz.inf.ontop.protege.core;

/*
 * #%L
 * ontop-protege
 * %%
 * Copyright (C) 2009 - 2013 KRDB Research Centre. Free University of Bozen Bolzano.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.protege.editor.owl.model.inference.AbstractProtegeOWLReasonerInfo;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;


public class OntopReasonerInfo extends AbstractProtegeOWLReasonerInfo {


	private OntopConfigurationManager configurationGenerator;
	private final OntopProtegeOWLFactory factory = new OntopProtegeOWLFactory();

	@Override
	public BufferingMode getRecommendedBuffering() {
		return BufferingMode.BUFFERING;
	}

	@Override
	public OWLReasonerFactory getReasonerFactory() {
		return factory;
	}

	@Override
    public OWLReasonerConfiguration getConfiguration(ReasonerProgressMonitor monitor) {
		OWLOntology activeOntology = getOWLModelManager().getActiveOntology();
		return new OntopProtegeOWLConfiguration(configurationGenerator.buildOntopSQLOWLAPIConfiguration(activeOntology), monitor, configurationGenerator);
    }

	public void setConfigurationGenerator(OntopConfigurationManager configurationGenerator) {
		this.configurationGenerator = configurationGenerator;
	}
}
