/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.jdbc.impl;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.protege.osgi.jdbc.JdbcRegistry;
import org.protege.osgi.jdbc.RegistryException;

public class JdbcRegistryImpl
implements JdbcRegistry {
    private List<Driver> drivers = new ArrayList<Driver>();

    @Override
    public void addJdbcDriver(String className, URL location) throws RegistryException {
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{location}, ClassLoader.getSystemClassLoader());
            Class<?> driverClass = classLoader.loadClass(className);
            Driver driver = (Driver)driverClass.newInstance();
            this.drivers.add(driver);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ie) {
            throw new RegistryException(ie);
        }
    }

    @Override
    public void removeJdbcDriver(String className) {
        Driver found = null;
        for (Driver driver : this.drivers) {
            if (!driver.getClass().toString().equals(className)) continue;
            found = driver;
            break;
        }
        if (found != null) {
            this.drivers.remove(found);
        }
    }

    public List<Driver> getJdbcDrivers() {
        return Collections.unmodifiableList(this.drivers);
    }
}

